/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.lumine.xikage.mythicmobs.utils.metadata.MetadataKey;
import io.lumine.xikage.mythicmobs.utils.metadata.MetadataMap;
import io.lumine.xikage.mythicmobs.utils.metadata.TransientValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

final class SimpleMetadataMap
implements MetadataMap {
    private final Map<MetadataKey<?>, Object> map = new HashMap();
    private final transient ReentrantLock lock = new ReentrantLock();

    SimpleMetadataMap() {
    }

    @Override
    public <T> void put(MetadataKey<T> key, T value) {
        this.internalPut(key, value);
    }

    @Override
    public <T> void put(MetadataKey<T> key, TransientValue<T> value) {
        this.internalPut(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPut(MetadataKey<?> key, Object value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.lock.lock();
        try {
            MetadataKey<?> existing = null;
            for (MetadataKey<?> k : this.map.keySet()) {
                if (!k.equals(key)) continue;
                existing = k;
                break;
            }
            if (existing != null && !existing.getType().equals(key.getType())) {
                throw new ClassCastException("Cannot cast key with id " + key.getId() + " with type " + key.getType().getRawType() + " to existing stored type " + existing.getType().getRawType());
            }
            this.map.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> void forcePut(MetadataKey<T> key, T value) {
        this.internalForcePut(key, value);
    }

    @Override
    public <T> void forcePut(MetadataKey<T> key, TransientValue<T> value) {
        this.internalForcePut(key, value);
    }

    private void internalForcePut(MetadataKey<?> key, Object value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.lock.lock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> boolean putIfAbsent(MetadataKey<T> key, T value) {
        return this.internalPutIfAbsent(key, value);
    }

    @Override
    public <T> boolean putIfAbsent(MetadataKey<T> key, TransientValue<T> value) {
        return this.internalPutIfAbsent(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalPutIfAbsent(MetadataKey<?> key, Object value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.lock.lock();
        try {
            this.doExpire();
            boolean bl = this.map.putIfAbsent(key, value) == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Optional<T> get(MetadataKey<T> key) {
        Preconditions.checkNotNull(key, "key");
        this.lock.lock();
        try {
            Optional optional;
            Map.Entry<MetadataKey<?>, Object> existing = null;
            Iterator<Map.Entry<MetadataKey<?>, Object>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MetadataKey<?>, Object> kv = it.next();
                if (kv.getValue() instanceof TransientValue) {
                    TransientValue transientValue = (TransientValue)kv.getValue();
                    Object unboxed = transientValue.getOrNull();
                    if (unboxed == null) {
                        it.remove();
                        continue;
                    }
                    if (!kv.getKey().equals(key)) continue;
                    existing = Maps.immutableEntry(kv.getKey(), unboxed);
                    break;
                }
                if (!kv.getKey().equals(key)) continue;
                existing = kv;
                break;
            }
            if (existing == null) {
                optional = Optional.empty();
                return optional;
            }
            if (!((MetadataKey)existing.getKey()).getType().equals(key.getType())) {
                throw new ClassCastException("Cannot cast key with id " + key.getId() + " with type " + key.getType().getRawType() + " to existing stored type " + existing.getKey().getType().getRawType());
            }
            optional = Optional.of(key.cast(existing.getValue()));
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T getOrNull(MetadataKey<T> key) {
        Preconditions.checkNotNull(key, "key");
        return this.get(key).orElse(null);
    }

    @Override
    public <T> T getOrDefault(MetadataKey<T> key, T def) {
        Preconditions.checkNotNull(key, "key");
        return this.get(key).orElse(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOrPut(MetadataKey<T> key, Supplier<T> def) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(def, "def");
        this.lock.lock();
        try {
            Map.Entry<MetadataKey<?>, Object> existing = null;
            Iterator<Map.Entry<MetadataKey<?>, Object>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MetadataKey<?>, Object> kv = it.next();
                if (kv.getValue() instanceof TransientValue) {
                    TransientValue transientValue = (TransientValue)kv.getValue();
                    Object unboxed = transientValue.getOrNull();
                    if (unboxed == null) {
                        it.remove();
                        continue;
                    }
                    if (!kv.getKey().equals(key)) continue;
                    existing = Maps.immutableEntry(kv.getKey(), unboxed);
                    break;
                }
                if (!kv.getKey().equals(key)) continue;
                existing = kv;
                break;
            }
            if (existing == null) {
                T t = def.get();
                Preconditions.checkNotNull(t, "supplied def");
                this.map.put(key, t);
                T t2 = t;
                return t2;
            }
            if (!((MetadataKey)existing.getKey()).getType().equals(key.getType())) {
                throw new ClassCastException("Cannot cast key with id " + key.getId() + " with type " + key.getType().getRawType() + " to existing stored type " + existing.getKey().getType().getRawType());
            }
            T t = key.cast(existing.getValue());
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOrPutExpiring(MetadataKey<T> key, Supplier<TransientValue<T>> def) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(def, "def");
        this.lock.lock();
        try {
            Map.Entry<MetadataKey<?>, Object> existing = null;
            Iterator<Map.Entry<MetadataKey<?>, Object>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MetadataKey<?>, Object> kv = it.next();
                if (kv.getValue() instanceof TransientValue) {
                    TransientValue transientValue = (TransientValue)kv.getValue();
                    Object unboxed = transientValue.getOrNull();
                    if (unboxed == null) {
                        it.remove();
                        continue;
                    }
                    if (!kv.getKey().equals(key)) continue;
                    existing = Maps.immutableEntry(kv.getKey(), unboxed);
                    break;
                }
                if (!kv.getKey().equals(key)) continue;
                existing = kv;
                break;
            }
            if (existing == null) {
                TransientValue<T> t = def.get();
                Preconditions.checkNotNull(t, "supplied def");
                T value = t.getOrNull();
                if (value == null) {
                    throw new IllegalArgumentException("Transient value already expired: " + t);
                }
                this.map.put(key, t);
                T t2 = value;
                return t2;
            }
            if (!((MetadataKey)existing.getKey()).getType().equals(key.getType())) {
                throw new ClassCastException("Cannot cast key with id " + key.getId() + " with type " + key.getType().getRawType() + " to existing stored type " + existing.getKey().getType().getRawType());
            }
            T t = key.cast(existing.getValue());
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(MetadataKey<?> key) {
        Preconditions.checkNotNull(key, "key");
        this.lock.lock();
        try {
            Map.Entry<MetadataKey<?>, Object> existing = null;
            Iterator<Map.Entry<MetadataKey<?>, Object>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                TransientValue transientValue;
                Map.Entry<MetadataKey<?>, Object> kv = it.next();
                if (kv.getValue() instanceof TransientValue && (transientValue = (TransientValue)kv.getValue()).shouldExpire()) {
                    it.remove();
                    continue;
                }
                if (!kv.getKey().equals(key)) continue;
                existing = kv;
                break;
            }
            boolean bl = existing != null && ((MetadataKey)existing.getKey()).getType().equals(key.getType());
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(MetadataKey<?> key) {
        Preconditions.checkNotNull(key, "key");
        this.lock.lock();
        try {
            boolean bl = this.map.remove(key) != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ImmutableMap<MetadataKey<?>, Object> asMap() {
        this.lock.lock();
        try {
            ImmutableMap<MetadataKey<?>, Object> immutableMap = ImmutableMap.copyOf(this.map);
            return immutableMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            this.doExpire();
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doExpire() {
        this.lock.lock();
        try {
            this.map.values().removeIf(o -> o instanceof TransientValue && ((TransientValue)o).shouldExpire());
        }
        finally {
            this.lock.unlock();
        }
    }
}

