/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.network.messaging.lilypad;

import com.google.common.reflect.TypeToken;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.network.messaging.AbstractMessenger;
import io.lumine.xikage.mythicmobs.utils.network.messaging.Channel;
import io.lumine.xikage.mythicmobs.utils.network.messaging.lilypad.LilyPad;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import lilypad.client.connect.api.Connect;
import lilypad.client.connect.api.event.EventListener;
import lilypad.client.connect.api.event.MessageEvent;
import lilypad.client.connect.api.request.Request;
import lilypad.client.connect.api.request.RequestException;
import lilypad.client.connect.api.request.impl.MessageRequest;
import lilypad.client.connect.api.request.impl.RedirectRequest;

public class LilyPadImpl
implements LilyPad {
    private final LuminePlugin plugin;
    private final Connect connect;
    private final AbstractMessenger messenger;
    private final AtomicBoolean listening = new AtomicBoolean(false);

    public LilyPadImpl(LuminePlugin plugin, String serverName) {
        this.plugin = plugin;
        this.connect = (Connect)plugin.getServer().getServicesManager().getRegistration(Connect.class).getProvider();
        this.messenger = new AbstractMessenger(serverName, (channel, message) -> {
            try {
                this.connect.request((Request)new MessageRequest(Collections.emptyList(), channel, message));
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }, (server, channel, message) -> {
            try {
                this.connect.request((Request)new MessageRequest(server, channel, message));
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }, channel -> {
            if (this.listening.getAndSet(true)) {
                return;
            }
            try {
                this.connect.registerEvents((Object)this);
            }
            catch (Exception e) {
                this.listening.set(false);
            }
        }, channel -> {});
        plugin.provideService(LilyPad.class, this);
    }

    @EventListener
    public void onMessage(MessageEvent event) {
        String sender = event.getSender();
        String channel = event.getChannel();
        byte[] message = event.getMessage();
        this.messenger.registerIncomingMessage(channel, sender, message);
    }

    @Override
    public void redirectPlayer(@Nonnull String serverId, @Nonnull String playerUsername) {
        try {
            this.connect.request((Request)new RedirectRequest(serverId, playerUsername));
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nonnull
    public Connect getConnect() {
        return this.connect;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.connect.getSettings().getUsername();
    }

    @Override
    @Nonnull
    public Set<String> getGroups() {
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        return this.messenger.getChannel(name, type);
    }

    private static final class MessageSpecificRequestTask
    implements Runnable {
        private final Connect connect;
        private final String server;
        private final String channel;
        private final byte[] message;
        private int attempts = 0;

        MessageSpecificRequestTask(Connect connect, String server, String channel, byte[] message) {
            this.connect = connect;
            this.server = server;
            this.channel = channel;
            this.message = message;
        }

        @Override
        public void run() {
            ++this.attempts;
            try {
                this.connect.request((Request)new MessageRequest(this.server, this.channel, this.message));
            }
            catch (RequestException e) {
                if (e.getMessage().equals("Not open") || e.getMessage().equals("Not connected")) {
                    if (this.attempts < 3) {
                        Schedulers.async().runLater(this, 2L, TimeUnit.SECONDS);
                    }
                }
                e.printStackTrace();
            }
        }
    }

    private static final class MessageRequestTask
    implements Runnable {
        private final Connect connect;
        private final String channel;
        private final byte[] message;
        private int attempts = 0;

        MessageRequestTask(Connect connect, String channel, byte[] message) {
            this.connect = connect;
            this.channel = channel;
            this.message = message;
        }

        @Override
        public void run() {
            ++this.attempts;
            try {
                this.connect.request((Request)new MessageRequest(Collections.emptyList(), this.channel, this.message));
            }
            catch (RequestException e) {
                if (e.getMessage().equals("Not open") || e.getMessage().equals("Not connected")) {
                    if (this.attempts < 3) {
                        Schedulers.async().runLater(this, 2L, TimeUnit.SECONDS);
                    }
                }
                e.printStackTrace();
            }
        }
    }
}

