/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.prompts;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import io.lumine.xikage.mythicmobs.utils.Players;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.plugin.LoaderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SignPrompt {
    private static final ProtocolManager PROTOCOL_MANAGER = ProtocolLibrary.getProtocolManager();

    public static void openPrompt(final Player player, final List<String> startLines, final Predicate<List<String>> callback) {
        try {
            final Location location = player.getLocation().clone();
            location.setY(255.0);
            Players.sendBlockChange(player, location, Material.OAK_WALL_SIGN);
            BlockPosition position = new BlockPosition(location.toVector());
            PacketContainer openSign = new PacketContainer(PacketType.Play.Server.OPEN_SIGN_EDITOR);
            openSign.getBlockPositionModifier().write(0, (Object)position);
            PROTOCOL_MANAGER.sendServerPacket(player, openSign);
            PacketContainer writeToSign = new PacketContainer(PacketType.Play.Server.TILE_ENTITY_DATA);
            writeToSign.getBlockPositionModifier().write(0, (Object)position);
            writeToSign.getIntegers().write(0, (Object)9);
            NbtCompound compound = NbtFactory.ofCompound((String)"");
            for (int i = 0; i < 4; ++i) {
                compound.put("Text" + (i + 1), "{\"text\":\"" + (startLines.size() > i ? startLines.get(i) : "") + "\"}");
            }
            compound.put("id", "minecraft:sign");
            compound.put("x", position.getX());
            compound.put("y", position.getY());
            compound.put("z", position.getZ());
            writeToSign.getNbtModifier().write(0, (Object)compound);
            PROTOCOL_MANAGER.sendServerPacket(player, writeToSign);
            PROTOCOL_MANAGER.addPacketListener((PacketListener)new PacketAdapter((Plugin)LoaderUtils.getPlugin(), new PacketType[]{PacketType.Play.Client.UPDATE_SIGN}){

                public void onPacketReceiving(PacketEvent event) {
                    if (event.getPlayer().getUniqueId().equals(player.getUniqueId())) {
                        PacketContainer container = event.getPacket();
                        String[] newLines = (String[])container.getStringArrays().read(0);
                        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(newLines));
                        boolean pass = callback.test(lines);
                        if (!pass) {
                            Schedulers.sync().runLater(() -> {
                                if (player.isOnline()) {
                                    SignPrompt.openPrompt(player, startLines, callback);
                                }
                            }, 1L);
                        }
                        PROTOCOL_MANAGER.removePacketListener((PacketListener)this);
                        Players.sendBlockChange(player, location, Material.AIR);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

