/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.redis.jedis;

import io.lumine.xikage.mythicmobs.utils.redis.jedis.HostAndPort;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.Jedis;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.JedisClusterInfoCache;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.JedisPool;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.exceptions.JedisConnectionException;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public abstract class JedisClusterConnectionHandler
implements Closeable {
    protected final JedisClusterInfoCache cache;

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, password, null);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        this.cache = new JedisClusterInfoCache(poolConfig, connectionTimeout, soTimeout, password, clientName);
        this.initializeSlotsCache(nodes, poolConfig, connectionTimeout, soTimeout, password, clientName);
    }

    abstract Jedis getConnection();

    abstract Jedis getConnectionFromSlot(int var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        return this.cache.setupNodeIfNotExist(node).getResource();
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        for (HostAndPort hostAndPort : startNodes) {
            Jedis jedis = null;
            try {
                jedis = new Jedis(hostAndPort.getHost(), hostAndPort.getPort(), connectionTimeout, soTimeout);
                if (password != null) {
                    jedis.auth(password);
                }
                if (clientName != null) {
                    jedis.clientSetname(clientName);
                }
                this.cache.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException jedisConnectionException) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
    }

    public void renewSlotCache() {
        this.cache.renewClusterSlots(null);
    }

    public void renewSlotCache(Jedis jedis) {
        this.cache.renewClusterSlots(jedis);
    }

    @Override
    public void close() {
        this.cache.reset();
    }
}

