/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.redis.jedis;

import io.lumine.xikage.mythicmobs.utils.redis.jedis.Builder;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.exceptions.JedisDataException;

public class Response<T> {
    protected T response = null;
    protected JedisDataException exception = null;
    private boolean building = false;
    private boolean built = false;
    private boolean set = false;
    private Builder<T> builder;
    private Object data;
    private Response<?> dependency = null;

    public Response(Builder<T> b) {
        this.builder = b;
    }

    public void set(Object data) {
        this.data = data;
        this.set = true;
    }

    public T get() {
        if (this.dependency != null && this.dependency.set && !this.dependency.built) {
            super.build();
        }
        if (!this.set) {
            throw new JedisDataException("Please close pipeline or multi block before calling this method.");
        }
        if (!this.built) {
            this.build();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.response;
    }

    public void setDependency(Response<?> dependency) {
        this.dependency = dependency;
    }

    private void build() {
        if (this.building) {
            return;
        }
        this.building = true;
        try {
            if (this.data != null) {
                if (this.data instanceof JedisDataException) {
                    this.exception = (JedisDataException)this.data;
                } else {
                    this.response = this.builder.build(this.data);
                }
            }
            this.data = null;
        }
        finally {
            this.building = false;
            this.built = true;
        }
    }

    public String toString() {
        return "Response " + this.builder.toString();
    }
}

