/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.signprompt;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import io.lumine.xikage.mythicmobs.utils.Players;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.protocol.Protocol;
import io.lumine.xikage.mythicmobs.utils.signprompt.SignPromptFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PacketSignPromptFactory
implements SignPromptFactory {
    @Override
    public void openPrompt(@Nonnull Player player, @Nonnull List<String> lines, @Nonnull SignPromptFactory.ResponseHandler responseHandler) {
        Location location = player.getLocation().clone();
        location.setY(254.0);
        Players.sendBlockChange(player, location, Material.OAK_SIGN);
        BlockPosition position = new BlockPosition(location.toVector());
        PacketContainer writeToSign = new PacketContainer(PacketType.Play.Server.TILE_ENTITY_DATA);
        writeToSign.getBlockPositionModifier().write(0, (Object)position);
        writeToSign.getIntegers().write(0, (Object)9);
        NbtCompound compound = NbtFactory.ofCompound((String)"");
        for (int i = 0; i < 4; ++i) {
            compound.put("Text" + (i + 1), "{\"text\":\"" + (lines.size() > i ? lines.get(i) : "") + "\"}");
        }
        compound.put("id", "minecraft:sign");
        compound.put("x", position.getX());
        compound.put("y", position.getY());
        compound.put("z", position.getZ());
        writeToSign.getNbtModifier().write(0, (Object)compound);
        Protocol.sendPacket(player, writeToSign);
        PacketContainer openSign = new PacketContainer(PacketType.Play.Server.OPEN_SIGN_EDITOR);
        openSign.getBlockPositionModifier().write(0, (Object)position);
        Protocol.sendPacket(player, openSign);
        AtomicBoolean active = new AtomicBoolean(true);
        Protocol.subscribe(PacketType.Play.Client.UPDATE_SIGN).filter(e -> e.getPlayer().getUniqueId().equals(player.getUniqueId())).biHandler((sub, event) -> {
            if (!active.getAndSet(false)) {
                return;
            }
            event.setCancelled(true);
            PacketContainer container = event.getPacket();
            ArrayList<Object> input = new ArrayList<Object>(Arrays.asList((Object[])container.getStringArrays().read(0)));
            SignPromptFactory.Response response = responseHandler.handleResponse(input);
            if (response == SignPromptFactory.Response.TRY_AGAIN) {
                Schedulers.sync().runLater(() -> {
                    if (player.isOnline()) {
                        this.openPrompt(player, lines, responseHandler);
                    }
                }, 1L);
            }
            sub.close();
            Players.sendBlockChange(player, location, Material.AIR);
        });
    }
}

