/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.tasks.builder;

import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.promise.ThreadContext;
import io.lumine.xikage.mythicmobs.utils.tasks.Task;
import io.lumine.xikage.mythicmobs.utils.tasks.builder.ContextualPromiseBuilder;
import io.lumine.xikage.mythicmobs.utils.tasks.builder.ContextualTaskBuilder;
import io.lumine.xikage.mythicmobs.utils.tasks.builder.TaskBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class TaskBuilderImpl
implements TaskBuilder {
    static final TaskBuilder INSTANCE = new TaskBuilderImpl();
    private final TaskBuilder.ThreadContextual sync = new ThreadContextualBuilder(ThreadContext.SYNC);
    private final TaskBuilder.ThreadContextual async = new ThreadContextualBuilder(ThreadContext.ASYNC);

    private TaskBuilderImpl() {
    }

    @Override
    @Nonnull
    public TaskBuilder.ThreadContextual sync() {
        return this.sync;
    }

    @Override
    @Nonnull
    public TaskBuilder.ThreadContextual async() {
        return this.async;
    }

    private static class ContextualTaskBuilderTimeImpl
    implements ContextualTaskBuilder {
        private final ThreadContext context;
        private final long delay;
        private final TimeUnit delayUnit;
        private final long interval;
        private final TimeUnit intervalUnit;

        ContextualTaskBuilderTimeImpl(ThreadContext context, long delay, TimeUnit delayUnit, long interval, TimeUnit intervalUnit) {
            this.context = context;
            this.delay = delay;
            this.delayUnit = delayUnit;
            this.interval = interval;
            this.intervalUnit = intervalUnit;
        }

        @Override
        @Nonnull
        public Task consume(@Nonnull Consumer<Task> consumer) {
            return Schedulers.get(this.context).runRepeating(consumer, this.delay, this.delayUnit, this.interval, this.intervalUnit);
        }

        @Override
        @Nonnull
        public Task run(@Nonnull Runnable runnable) {
            return Schedulers.get(this.context).runRepeating(runnable, this.delay, this.delayUnit, this.interval, this.intervalUnit);
        }
    }

    private static class ContextualTaskBuilderTickImpl
    implements ContextualTaskBuilder {
        private final ThreadContext context;
        private final long delay;
        private final long interval;

        ContextualTaskBuilderTickImpl(ThreadContext context, long delay, long interval) {
            this.context = context;
            this.delay = delay;
            this.interval = interval;
        }

        @Override
        @Nonnull
        public Task consume(@Nonnull Consumer<Task> consumer) {
            return Schedulers.get(this.context).runRepeating(consumer, this.delay, this.interval);
        }

        @Override
        @Nonnull
        public Task run(@Nonnull Runnable runnable) {
            return Schedulers.get(this.context).runRepeating(runnable, this.delay, this.interval);
        }
    }

    private static class ContextualPromiseBuilderImpl
    implements ContextualPromiseBuilder {
        private final ThreadContext context;

        ContextualPromiseBuilderImpl(ThreadContext context) {
            this.context = context;
        }

        @Override
        @Nonnull
        public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
            return Schedulers.get(this.context).supply(supplier);
        }

        @Override
        @Nonnull
        public <T> Promise<T> call(@Nonnull Callable<T> callable) {
            return Schedulers.get(this.context).call(callable);
        }

        @Override
        @Nonnull
        public Promise<Void> run(@Nonnull Runnable runnable) {
            return Schedulers.get(this.context).run(runnable);
        }
    }

    private static final class DelayedTimeBuilder
    implements TaskBuilder.DelayedTime {
        private final ThreadContext context;
        private final long delay;
        private final TimeUnit delayUnit;

        DelayedTimeBuilder(ThreadContext context, long delay, TimeUnit delayUnit) {
            this.context = context;
            this.delay = delay;
            this.delayUnit = delayUnit;
        }

        @Override
        @Nonnull
        public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
            return Schedulers.get(this.context).supplyLater(supplier, this.delay, this.delayUnit);
        }

        @Override
        @Nonnull
        public <T> Promise<T> call(@Nonnull Callable<T> callable) {
            return Schedulers.get(this.context).callLater(callable, this.delay, this.delayUnit);
        }

        @Override
        @Nonnull
        public Promise<Void> run(@Nonnull Runnable runnable) {
            return Schedulers.get(this.context).runLater(runnable, this.delay, this.delayUnit);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder every(long duration, TimeUnit unit) {
            return new ContextualTaskBuilderTimeImpl(this.context, this.delay, this.delayUnit, duration, unit);
        }
    }

    private static final class DelayedTickBuilder
    implements TaskBuilder.DelayedTick {
        private final ThreadContext context;
        private final long delay;

        DelayedTickBuilder(ThreadContext context, long delay) {
            this.context = context;
            this.delay = delay;
        }

        @Override
        @Nonnull
        public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
            return Schedulers.get(this.context).supplyLater(supplier, this.delay);
        }

        @Override
        @Nonnull
        public <T> Promise<T> call(@Nonnull Callable<T> callable) {
            return Schedulers.get(this.context).callLater(callable, this.delay);
        }

        @Override
        @Nonnull
        public Promise<Void> run(@Nonnull Runnable runnable) {
            return Schedulers.get(this.context).runLater(runnable, this.delay);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder every(long ticks) {
            return new ContextualTaskBuilderTickImpl(this.context, this.delay, ticks);
        }
    }

    private static final class ThreadContextualBuilder
    implements TaskBuilder.ThreadContextual {
        private final ThreadContext context;
        private final ContextualPromiseBuilder instant;

        ThreadContextualBuilder(ThreadContext context) {
            this.context = context;
            this.instant = new ContextualPromiseBuilderImpl(context);
        }

        @Override
        @Nonnull
        public ContextualPromiseBuilder now() {
            return this.instant;
        }

        @Override
        @Nonnull
        public TaskBuilder.DelayedTick after(long ticks) {
            return new DelayedTickBuilder(this.context, ticks);
        }

        @Override
        @Nonnull
        public TaskBuilder.DelayedTime after(long duration, @Nonnull TimeUnit unit) {
            return new DelayedTimeBuilder(this.context, duration, unit);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder afterAndEvery(long ticks) {
            return new ContextualTaskBuilderTickImpl(this.context, ticks, ticks);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder afterAndEvery(long duration, @Nonnull TimeUnit unit) {
            return new ContextualTaskBuilderTimeImpl(this.context, duration, unit, duration, unit);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder every(long ticks) {
            return new ContextualTaskBuilderTickImpl(this.context, 0L, ticks);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder every(long duration, @Nonnull TimeUnit unit) {
            return new ContextualTaskBuilderTimeImpl(this.context, 0L, TimeUnit.NANOSECONDS, duration, unit);
        }
    }
}

