/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.api.text;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public class Colors {
    private static final char COLOR_PREFIX = '&';
    private static Replacer replacer;

    public static void init(boolean bl) {
        if (Colors.isSupportRgb() && bl) {
            replacer = new RgbReplacer();
            return;
        }
        replacer = new SimpleReplacer();
    }

    public static String of(String string) {
        return replacer.replace(string);
    }

    public static List<String> ofList(List<String> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.set(i2, Colors.of(list.get(i2)));
        }
        return list;
    }

    public static String[] ofArr(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = Colors.of(stringArray[i2]);
        }
        return stringArray;
    }

    private static boolean isSupportRgb() {
        try {
            Class.forName("net.md_5.bungee.api.ChatColor").getDeclaredMethod("of", String.class);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static class RgbReplacer
    implements Replacer {
        private static final Pattern PATTERN = Pattern.compile("<#([A-Fa-f0-9]){6}>");

        private RgbReplacer() {
        }

        @Override
        public String replace(String string) {
            Matcher matcher = PATTERN.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                string2 = net.md_5.bungee.api.ChatColor.of((String)string2.substring(1, string2.length() - 1));
                String string3 = string.substring(0, matcher.start());
                string = string.substring(matcher.end());
                string = string3 + string2 + string;
                matcher = PATTERN.matcher(string);
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        }
    }

    private static class SimpleReplacer
    implements Replacer {
        private SimpleReplacer() {
        }

        @Override
        public String replace(String string) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        }
    }

    private static interface Replacer {
        public String replace(String var1);
    }
}

