/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.abstractmenus.hocon.api.ConfigNode;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;
import ru.abstractmenus.hocon.api.serialize.NodeSerializers;
import ru.abstractmenus.hocon.i;
import ru.abstractmenus.hocon.l;
import ru.abstractmenus.hocon.t;
import ru.abstractmenus.hocon.u;

class SimpleConfigNode
implements ConfigNode {
    private final NodeSerializers serializers;
    private final String key;
    private final ConfigNode parent;
    private final t wrapped;

    public SimpleConfigNode(String string, ConfigNode configNode, t t2, NodeSerializers nodeSerializers) {
        this.key = string;
        this.parent = configNode;
        this.wrapped = t2;
        this.serializers = nodeSerializers;
    }

    @Override
    public t wrapped() {
        return this.wrapped;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String[] path() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (ConfigNode configNode = this; configNode != null; configNode = configNode.parent()) {
            linkedList.addFirst(configNode.key());
        }
        return linkedList.toArray(new String[0]);
    }

    @Override
    public ConfigNode parent() {
        return this.parent;
    }

    @Override
    public ConfigNode node(String ... stringArray) {
        ConfigNode configNode = this;
        for (String string : stringArray) {
            configNode = configNode.child(string);
        }
        return configNode;
    }

    @Override
    public ConfigNode child(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Node key cannot be null");
        }
        if (this.wrapped instanceof l) {
            t t2 = (l)this.wrapped;
            if ((t2 = t2.a(string)) != null) {
                return new SimpleConfigNode(string, this, t2, this.serializers);
            }
        }
        return new SimpleConfigNode(string, this, null, this.serializers);
    }

    @Override
    public boolean hasChildren() {
        if (this.wrapped instanceof l) {
            return !((l)this.wrapped).isEmpty();
        }
        if (this.wrapped instanceof i) {
            return !((i)this.wrapped).isEmpty();
        }
        return false;
    }

    @Override
    public boolean isList() {
        return !this.isNull() && this.wrapped.e() == u.b;
    }

    @Override
    public boolean isMap() {
        return !this.isNull() && this.wrapped.e() == u.a;
    }

    @Override
    public boolean isPrimitive() {
        return !this.isNull() && (this.wrapped.e() == u.d || this.wrapped.e() == u.c || this.wrapped.e() == u.f);
    }

    @Override
    public boolean isNull() {
        return this.wrapped == null || this.wrapped.e() == u.e;
    }

    @Override
    public Object rawValue() {
        if (!this.isNull()) {
            return this.wrapped.b();
        }
        return null;
    }

    @Override
    public <T> T getValue(Class<T> clazz, T object) throws NodeSerializeException {
        if (this.isNull()) {
            return object;
        }
        object = this.serializers.getSerializer(clazz);
        return object.deserialize(clazz, this);
    }

    @Override
    public <T> List<T> getList(Class<T> clazz) throws NodeSerializeException {
        if (!this.isNull()) {
            NodeSerializer<T> nodeSerializer = this.serializers.getSerializer(clazz);
            ArrayList<T> arrayList = new ArrayList<T>();
            if (this.isList()) {
                for (ConfigNode configNode : this.childrenList()) {
                    arrayList.add(nodeSerializer.deserialize(clazz, configNode));
                }
                return arrayList;
            }
            T t2 = nodeSerializer.deserialize(clazz, this);
            if (t2 != null) {
                arrayList.add(t2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConfigNode> childrenList() {
        if (this.isList()) {
            Object object = (i)this.wrapped;
            LinkedList<ConfigNode> linkedList = new LinkedList<ConfigNode>();
            object = object.iterator();
            while (object.hasNext()) {
                t t2 = (t)object.next();
                linkedList.add(new SimpleConfigNode(null, this, t2, this.serializers));
            }
            return linkedList;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, ConfigNode> childrenMap() {
        if (this.isMap()) {
            l l2 = (l)this.wrapped;
            LinkedHashMap<String, ConfigNode> linkedHashMap = new LinkedHashMap<String, ConfigNode>();
            for (Map.Entry entry : l2.entrySet()) {
                SimpleConfigNode simpleConfigNode = new SimpleConfigNode((String)entry.getKey(), this, (t)entry.getValue(), this.serializers);
                linkedHashMap.put((String)entry.getKey(), simpleConfigNode);
            }
            return linkedHashMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean getBoolean(boolean bl) {
        try {
            return this.getValue(Boolean.class, bl);
        }
        catch (NodeSerializeException nodeSerializeException) {
            return bl;
        }
    }

    @Override
    public int getInt(int n2) {
        try {
            return this.getValue(Integer.class, n2);
        }
        catch (NodeSerializeException nodeSerializeException) {
            return n2;
        }
    }

    @Override
    public long getLong(long l2) {
        try {
            return this.getValue(Long.class, l2);
        }
        catch (NodeSerializeException nodeSerializeException) {
            return l2;
        }
    }

    @Override
    public float getFloat(float f2) {
        try {
            return this.getValue(Float.class, Float.valueOf(f2)).floatValue();
        }
        catch (NodeSerializeException nodeSerializeException) {
            return f2;
        }
    }

    @Override
    public double getDouble(double d2) {
        try {
            return this.getValue(Double.class, d2);
        }
        catch (NodeSerializeException nodeSerializeException) {
            return d2;
        }
    }

    @Override
    public String getString(String string) {
        try {
            return this.getValue(String.class, string);
        }
        catch (NodeSerializeException nodeSerializeException) {
            return string;
        }
    }

    public String toString() {
        if (this.isNull()) {
            return "null";
        }
        if (this.isMap()) {
            return this.childrenMap().toString();
        }
        if (this.isList()) {
            return this.childrenList().toString();
        }
        return this.wrapped.b().toString();
    }
}

