/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.serialize.defaults;

import ru.abstractmenus.hocon.api.ConfigNode;
import ru.abstractmenus.hocon.api.Preconditions;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;

public class DoubleSerializer
implements NodeSerializer<Double> {
    @Override
    public Double deserialize(Class<Double> object, ConfigNode configNode) throws NodeSerializeException {
        Preconditions.checkNodeNull(configNode);
        object = configNode.rawValue();
        if (object instanceof Double) {
            return (Double)object;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new NodeSerializeException(configNode, "Cannot parse double from '" + object + "'");
        }
    }
}

