/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.source;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import ru.abstractmenus.hocon.api.source.ConfigSource;

public abstract class AbstractConfigSource
implements ConfigSource {
    private final String name;
    private Path copyTo;

    public AbstractConfigSource(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<Path> getCopyDirectory() {
        return Optional.ofNullable(this.copyTo);
    }

    @Override
    public ConfigSource copyTo(Path object) {
        this.copyTo = object;
        Path path = Paths.get(object.toString(), this.name);
        try {
            if (!Files.exists((Path)object, new LinkOption[0])) {
                Files.createDirectories((Path)object, new FileAttribute[0]);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                Files.copy(this.getStream(), path, new CopyOption[0]);
            }
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return this;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.copyTo == null) {
            return this.getSourceReader();
        }
        return Files.newBufferedReader(Paths.get(this.copyTo.toString(), this.name));
    }

    @Override
    public BufferedWriter getWriter() throws IOException {
        if (this.copyTo == null) {
            return this.getSourceWriter();
        }
        return Files.newBufferedWriter(Paths.get(this.copyTo.toString(), this.name), new OpenOption[0]);
    }

    protected abstract BufferedReader getSourceReader() throws IOException;

    protected abstract BufferedWriter getSourceWriter() throws IOException;
}

