/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api;

import com.francobm.magicosmetics.api.CosmeticType;
import com.francobm.magicosmetics.api.MagicAPI;
import com.google.common.collect.Lists;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.value.MaterialValue;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.util.J;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import xyz.xenondevs.particle.utils.MathUtils;

public interface Component {
    default public void wisdom(Player p, long w) {
        XP.wisdom(p, w);
    }

    default public ItemStack damage(ItemStack item, int damage) {
        if (item == null) {
            return null;
        }
        if (item.getItemMeta() == null) {
            if (item.getAmount() == 1) {
                return null;
            }
            item = item.clone();
            item.setAmount(item.getAmount() - 1);
            return item;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable d = (Damageable)itemMeta;
            if (d.getDamage() + 1 > item.getType().getMaxDurability()) {
                return null;
            }
            d.setDamage(d.getDamage() + 1);
            item = item.clone();
            item.setItemMeta((ItemMeta)d);
            return item;
        }
        if (item.getAmount() == 1) {
            return null;
        }
        item = item.clone();
        item.setAmount(item.getAmount() - 1);
        return item;
    }

    default public void decrementItemstack(ItemStack hand, Player p) {
        if (hand.getAmount() > 1) {
            hand.setAmount(hand.getAmount() - 1);
        } else {
            p.getInventory().setItemInMainHand(null);
        }
    }

    default public double getArmorValue(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack boots = inv.getBoots();
        ItemStack helmet = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack pants = inv.getLeggings();
        double armorValue = 0.0;
        if (helmet == null) {
            armorValue += 0.0;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("MagicCosmetics") != null && MagicAPI.hasEquipCosmetic((Player)player, (CosmeticType)CosmeticType.HAT)) {
            armorValue += 0.0;
        } else if (helmet.getType() == Material.LEATHER_HELMET) {
            armorValue += 0.04;
        } else if (helmet.getType() == Material.GOLDEN_HELMET) {
            armorValue += 0.08;
        } else if (helmet.getType() == Material.TURTLE_HELMET) {
            armorValue += 0.08;
        } else if (helmet.getType() == Material.CHAINMAIL_HELMET) {
            armorValue += 0.08;
        } else if (helmet.getType() == Material.IRON_HELMET) {
            armorValue += 0.08;
        } else if (helmet.getType() == Material.DIAMOND_HELMET) {
            armorValue += 0.12;
        } else if (helmet.getType() == Material.NETHERITE_HELMET) {
            armorValue += 0.12;
        }
        if (boots == null) {
            armorValue += 0.0;
        } else if (boots.getType() == Material.LEATHER_BOOTS) {
            armorValue += 0.04;
        } else if (boots.getType() == Material.GOLDEN_BOOTS) {
            armorValue += 0.04;
        } else if (boots.getType() == Material.CHAINMAIL_BOOTS) {
            armorValue += 0.04;
        } else if (boots.getType() == Material.IRON_BOOTS) {
            armorValue += 0.08;
        } else if (boots.getType() == Material.DIAMOND_BOOTS) {
            armorValue += 0.12;
        } else if (boots.getType() == Material.NETHERITE_BOOTS) {
            armorValue += 0.12;
        }
        if (pants == null) {
            armorValue += 0.0;
        } else if (pants.getType() == Material.LEATHER_LEGGINGS) {
            armorValue += 0.08;
        } else if (pants.getType() == Material.GOLDEN_LEGGINGS) {
            armorValue += 0.12;
        } else if (pants.getType() == Material.CHAINMAIL_LEGGINGS) {
            armorValue += 0.16;
        } else if (pants.getType() == Material.IRON_LEGGINGS) {
            armorValue += 0.2;
        } else if (pants.getType() == Material.DIAMOND_LEGGINGS) {
            armorValue += 0.24;
        } else if (pants.getType() == Material.NETHERITE_LEGGINGS) {
            armorValue += 0.24;
        }
        if (chest == null) {
            armorValue += 0.0;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("MagicCosmetics") != null && MagicAPI.hasEquipCosmetic((Player)player, (CosmeticType)CosmeticType.BAG)) {
            armorValue += 0.0;
        } else if (chest.getType() == Material.LEATHER_CHESTPLATE) {
            armorValue += 0.12;
        } else if (chest.getType() == Material.GOLDEN_CHESTPLATE) {
            armorValue += 0.2;
        } else if (chest.getType() == Material.CHAINMAIL_CHESTPLATE) {
            armorValue += 0.2;
        } else if (chest.getType() == Material.IRON_CHESTPLATE) {
            armorValue += 0.24;
        } else if (chest.getType() == Material.DIAMOND_CHESTPLATE) {
            armorValue += 0.32;
        } else if (chest.getType() == Material.NETHERITE_CHESTPLATE) {
            armorValue += 0.32;
        }
        return armorValue;
    }

    default public PotionEffect getRawPotionEffect(ItemStack is) {
        PotionMeta p;
        ItemMeta itemMeta;
        if (is != null && is.getItemMeta() != null && (itemMeta = is.getItemMeta()) instanceof PotionMeta && (p = (PotionMeta)itemMeta).getBasePotionData().getType().getEffectType() != null) {
            int t;
            int g;
            int e;
            boolean l = is.getType().equals((Object)Material.LINGERING_POTION);
            boolean x = p.getBasePotionData().isExtended();
            boolean u = p.getBasePotionData().isUpgraded();
            int n = x ? (l ? 2400 : 9600) : (e = l ? 900 : 3600);
            int n2 = u ? (l ? 440 : 1800) : (g = e);
            int n3 = x ? (l ? 1200 : 4800) : (t = l ? 440 : 1800);
            int h = u ? (l ? 100 : 420) : (x ? (l ? 440 : 1800) : (l ? 220 : 900));
            PotionEffectType potionEffectType = p.getBasePotionData().getType().getEffectType();
            return new PotionEffect(potionEffectType, switch (p.getBasePotionData().getType()) {
                case PotionType.NIGHT_VISION, PotionType.INVISIBILITY, PotionType.FIRE_RESISTANCE, PotionType.WATER_BREATHING -> e;
                case PotionType.JUMP, PotionType.SPEED, PotionType.STRENGTH -> g;
                case PotionType.SLOWNESS -> {
                    if (u) {
                        if (l) {
                            yield 100;
                        }
                        yield 400;
                    }
                    yield t;
                }
                case PotionType.POISON, PotionType.REGEN -> h;
                case PotionType.WEAKNESS, PotionType.SLOW_FALLING -> t;
                case PotionType.LUCK -> {
                    if (l) {
                        yield 1500;
                    }
                    yield 6000;
                }
                case PotionType.TURTLE_MASTER -> {
                    if (u) {
                        if (l) {
                            yield 100;
                        }
                        yield 400;
                    }
                    if (x) {
                        if (l) {
                            yield 200;
                        }
                        yield 800;
                    }
                    if (l) {
                        yield 100;
                    }
                    yield 400;
                }
                default -> 0;
            }, p.getBasePotionData().isUpgraded() ? 1 : 0);
        }
        return null;
    }

    default public boolean isAdaptableDamageCause(EntityDamageEvent event) {
        Set<EntityDamageEvent.DamageCause> excludedCauses = Set.of(EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.LAVA, EntityDamageEvent.DamageCause.HOT_FLOOR, EntityDamageEvent.DamageCause.CRAMMING, EntityDamageEvent.DamageCause.MELTING, EntityDamageEvent.DamageCause.SUFFOCATION, EntityDamageEvent.DamageCause.SUICIDE, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.FLY_INTO_WALL, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.SONIC_BOOM, EntityDamageEvent.DamageCause.THORNS);
        return !excludedCauses.contains(event.getCause());
    }

    default public void addPotionStacks(Player p, PotionEffectType potionEffect, int amplifier, int duration, boolean overlap) {
        ArrayList activeEffects = new ArrayList(p.getActivePotionEffects());
        for (PotionEffect activeEffect : activeEffects) {
            if (activeEffect.getType() != potionEffect) continue;
            if (!overlap) {
                return;
            }
            int newDuration = activeEffect.getDuration() + duration;
            int newAmplifier = Math.max(activeEffect.getAmplifier(), amplifier);
            p.removePotionEffect(potionEffect);
            p.addPotionEffect(new PotionEffect(potionEffect, newDuration, newAmplifier));
            p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.25f);
            return;
        }
        J.a(() -> {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            J.s(() -> {
                p.addPotionEffect(new PotionEffect(potionEffect, duration, amplifier));
                p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.25f);
            });
        });
    }

    default public void potion(Player p, PotionEffectType type, int power, int duration) {
        p.addPotionEffect(new PotionEffect(type, power, duration, true, false, false));
    }

    default public double blockXP(Block block, double xp) {
        try {
            return Math.round(xp * this.getBlockMultiplier(block));
        }
        catch (Exception e) {
            Adapt.verbose("Error in blockXP: " + e.getMessage());
            return xp;
        }
    }

    default public double getBlockMultiplier(Block block) {
        return WorldData.of(block.getWorld()).reportEarnings(block);
    }

    default public double getValue(Material material) {
        return MaterialValue.getValue(material);
    }

    default public double getValue(BlockData block) {
        return MaterialValue.getValue(block.getMaterial());
    }

    default public double getValue(ItemStack f) {
        return MaterialValue.getValue(f.getType());
    }

    default public double getValue(Block block) {
        return MaterialValue.getValue(block.getType());
    }

    default public void vfxMovingSphere(Location startLocation, Location endLocation, final int ticks, Color color, final double size, final double density) {
        final World world = startLocation.getWorld();
        final double startX = startLocation.getX();
        final double startY = startLocation.getY();
        final double startZ = startLocation.getZ();
        double endX = endLocation.getX();
        double endY = endLocation.getY();
        double endZ = endLocation.getZ();
        final double deltaX = (endX - startX) / (double)ticks;
        final double deltaY = (endY - startY) / (double)ticks;
        final double deltaZ = (endZ - startZ) / (double)ticks;
        final Particle.DustOptions dustOptions = new Particle.DustOptions(color, (float)size);
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= ticks) {
                    this.cancel();
                    return;
                }
                double d = startX + deltaX * (double)this.tick;
                double d2 = startY + deltaY * (double)this.tick;
                double d3 = startZ + deltaZ * (double)this.tick;
                Location location = new Location(world, d, d2, d3);
                for (double d4 = 0.0; d4 < Math.PI; d4 += Math.PI / density) {
                    double d5 = Math.sin(d4) * size;
                    double d6 = Math.cos(d4) * size;
                    for (double d7 = 0.0; d7 < Math.PI * 2; d7 += Math.PI / density) {
                        double d8 = Math.sin(d7) * d5;
                        double d9 = Math.cos(d7) * d5;
                        Location location2 = location.clone().add(d8, d6, d9);
                        world.spawnParticle(Particle.REDSTONE, location2, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    }
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    default public void vfxMovingSwirlingSphere(Location startLocation, Location endLocation, final int ticks, Color color, final double size, final double swirlRadius, final double density) {
        final World world = startLocation.getWorld();
        final double startX = startLocation.getX();
        final double startY = startLocation.getY();
        final double startZ = startLocation.getZ();
        double endX = endLocation.getX();
        double endY = endLocation.getY();
        double endZ = endLocation.getZ();
        final double deltaX = (endX - startX) / (double)ticks;
        final double deltaY = (endY - startY) / (double)ticks;
        final double deltaZ = (endZ - startZ) / (double)ticks;
        final Particle.DustOptions dustOptions = new Particle.DustOptions(color, (float)size);
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= ticks) {
                    this.cancel();
                    return;
                }
                double d = startX + deltaX * (double)this.tick;
                double d2 = startY + deltaY * (double)this.tick;
                double d3 = startZ + deltaZ * (double)this.tick;
                double d4 = Math.PI * 2 * (double)this.tick / (double)ticks;
                Location location = new Location(world, d += swirlRadius * Math.cos(d4), d2, d3 += swirlRadius * Math.sin(d4));
                for (double d5 = 0.0; d5 < Math.PI; d5 += Math.PI / density) {
                    double d6 = Math.sin(d5) * size;
                    double d7 = Math.cos(d5) * size;
                    for (double d8 = 0.0; d8 < Math.PI * 2; d8 += Math.PI / density) {
                        double d9 = Math.sin(d8) * d6;
                        double d10 = Math.cos(d8) * d6;
                        Location location2 = location.clone().add(d9, d7, d10);
                        world.spawnParticle(Particle.REDSTONE, location2, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    }
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    default public void vfxPlayerBoundingBoxOutline(final Player player, Color color, final int ticks, final int particleCount) {
        final World world = player.getWorld();
        final Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= ticks) {
                    this.cancel();
                    return;
                }
                BoundingBox boundingBox = player.getBoundingBox();
                double d = boundingBox.getMinX();
                double d2 = boundingBox.getMinY();
                double d3 = boundingBox.getMinZ();
                double d4 = boundingBox.getMaxX();
                double d5 = boundingBox.getMaxY();
                double d6 = boundingBox.getMaxZ();
                for (int i = 0; i < particleCount; ++i) {
                    double d7 = (double)i / (double)(particleCount - 1);
                    world.spawnParticle(Particle.REDSTONE, d + d7 * (d4 - d), d2, d3, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d + d7 * (d4 - d), d5, d3, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d + d7 * (d4 - d), d2, d6, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d + d7 * (d4 - d), d5, d6, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d, d2 + d7 * (d5 - d2), d3, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d4, d2 + d7 * (d5 - d2), d3, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d, d2 + d7 * (d5 - d2), d6, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d4, d2 + d7 * (d5 - d2), d6, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d, d2, d3 + d7 * (d6 - d3), 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d4, d2, d3 + d7 * (d6 - d3), 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d, d5, d3 + d7 * (d6 - d3), 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    world.spawnParticle(Particle.REDSTONE, d4, d5, d3 + d7 * (d6 - d3), 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    default public void vfxVortexSphere(Location startLocation, Location endLocation, final int ticks, Color color, final double radius) {
        final World world = startLocation.getWorld();
        final Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
        final double startX = startLocation.getX();
        final double startY = startLocation.getY();
        final double startZ = startLocation.getZ();
        double endX = endLocation.getX();
        double endY = endLocation.getY();
        double endZ = endLocation.getZ();
        final double deltaX = (endX - startX) / (double)ticks;
        final double deltaY = (endY - startY) / (double)ticks;
        final double deltaZ = (endZ - startZ) / (double)ticks;
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= ticks) {
                    this.cancel();
                    return;
                }
                double d = startX + deltaX * (double)this.tick;
                double d2 = startY + deltaY * (double)this.tick;
                double d3 = startZ + deltaZ * (double)this.tick;
                Location location = new Location(world, d, d2, d3);
                double d4 = radius * (1.0 - (double)this.tick / (double)ticks);
                for (double d5 = 0.0; d5 < Math.PI * 2; d5 += 0.3141592653589793) {
                    for (double d6 = 0.0; d6 < Math.PI; d6 += 0.3141592653589793) {
                        double d7 = d4 * Math.sin(d6) * Math.cos(d5);
                        double d8 = d4 * Math.sin(d6) * Math.sin(d5);
                        double d9 = d4 * Math.cos(d6);
                        Location location2 = location.clone().add(d7, d8, d9);
                        world.spawnParticle(Particle.REDSTONE, location2, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    }
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    default public void vfxDome(Location center, double range, Color color, int particleCount) {
        Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
        World world = center.getWorld();
        for (int i = 0; i < particleCount; ++i) {
            double theta = Math.PI * 2 * MathUtils.RANDOM.nextDouble();
            double phi = 1.5707963267948966 * MathUtils.RANDOM.nextDouble();
            double x = range * Math.sin(phi) * Math.cos(theta);
            double y = range * Math.sin(phi) * Math.sin(theta);
            double z = range * Math.cos(phi);
            Location particleLocation = center.clone().add(x, y, z);
            world.spawnParticle(Particle.REDSTONE, particleLocation, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
    }

    default public void vfxSphereV1(Player p, Location l, double radius, Particle particle, int verticalDensity, int radialDensity) {
        for (double phi = 0.0; phi <= Math.PI; phi += Math.PI / (double)verticalDensity) {
            for (double theta = 0.0; theta <= Math.PI * 2; theta += Math.PI / (double)radialDensity) {
                double x = radius * Math.cos(theta) * Math.sin(phi);
                double y = radius * Math.cos(phi) + 1.5;
                double z = radius * Math.sin(theta) * Math.sin(phi);
                l.add(x, y, z);
                p.getWorld().spawnParticle(particle, l, 1, 0.0, 0.0, 0.0, 0.001);
                l.subtract(x, y, z);
            }
        }
    }

    default public void vfxZuck(Location from, Location to) {
        Vector v = from.clone().subtract(to).toVector();
        double l = v.length();
        v.normalize();
        if (AdaptConfig.get().isUseEnchantmentTableParticleForActiveEffects()) {
            from.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, to, 1, 6.0, 6.0, 6.0, 0.6);
        }
    }

    default public void vfxZuck(Location from, Location to, Particle particle) {
        Vector v = from.clone().subtract(to).toVector();
        double l = v.length();
        v.normalize();
        if (AdaptConfig.get().isUseEnchantmentTableParticleForActiveEffects()) {
            from.getWorld().spawnParticle(particle, to, 1, 6.0, 6.0, 6.0, 0.6);
        }
    }

    default public void safeGiveItem(Player player, Entity itemEntity, ItemStack is) {
        EntityPickupItemEvent e = new EntityPickupItemEvent((LivingEntity)player, (Item)itemEntity, 0);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (!e.isCancelled()) {
            itemEntity.remove();
            if (!player.getInventory().addItem(new ItemStack[]{is}).isEmpty()) {
                player.getWorld().dropItem(player.getLocation(), is);
            }
        }
    }

    default public void safeGiveItem(Player player, ItemStack item) {
        if (!player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
            player.getWorld().dropItem(player.getLocation(), item);
        }
    }

    default public void vfxParticleLine(Location start, Location end, Particle particle, int pointsPerLine, int particleCount, double offsetX, double offsetY, double offsetZ, double extra, @Nullable Double data, boolean forceDisplay, @Nullable Predicate<Location> operationPerPoint) {
        double d = start.distance(end) / (double)pointsPerLine;
        for (int i = 0; i < pointsPerLine; ++i) {
            Location l = start.clone();
            Vector direction = end.toVector().subtract(start.toVector()).normalize();
            Vector v = direction.multiply((double)i * d);
            l.add(v.getX(), v.getY(), v.getZ());
            if (operationPerPoint == null) {
                start.getWorld().spawnParticle(particle, l, particleCount, offsetX, offsetY, offsetZ, extra, (Object)data, forceDisplay);
                continue;
            }
            if (!operationPerPoint.test(l)) continue;
            start.getWorld().spawnParticle(particle, l, particleCount, offsetX, offsetY, offsetZ, extra, (Object)data, forceDisplay);
        }
    }

    default public void vfxParticleLine(Location start, Location end, int particleCount, Particle particle) {
        World world = start.getWorld();
        double distance = start.distance(end);
        Vector direction = end.toVector().subtract(start.toVector()).normalize();
        double step = distance / (double)(particleCount - 1);
        for (int i = 0; i < particleCount; ++i) {
            Location particleLocation = start.clone().add(direction.clone().multiply((double)i * step));
            world.spawnParticle(particle, particleLocation, 1);
        }
    }

    private List<Location> getHollowCuboid(Location loc, double particleDistance) {
        ArrayList result = Lists.newArrayList();
        World world = loc.getWorld();
        double minX = loc.getBlockX();
        double minY = loc.getBlockY();
        double minZ = loc.getBlockZ();
        double maxX = loc.getBlockX() + 1;
        double maxY = loc.getBlockY() + 1;
        double maxZ = loc.getBlockZ() + 1;
        for (double x = minX; x <= maxX; x += particleDistance) {
            for (double y = minY; y <= maxY; y += particleDistance) {
                for (double z = minZ; z <= maxZ; z += particleDistance) {
                    int components = 0;
                    if (x == minX || x == maxX) {
                        ++components;
                    }
                    if (y == minY || y == maxY) {
                        ++components;
                    }
                    if (z == minZ || z == maxZ) {
                        ++components;
                    }
                    if (components < 2) continue;
                    result.add(new Location(world, x, y, z));
                }
            }
        }
        return result;
    }

    private List<Location> getHollowCuboid(Location loc, Location loc2, double particleDistance) {
        ArrayList result = Lists.newArrayList();
        World world = loc.getWorld();
        double minX = loc.getBlockX();
        double minY = loc.getBlockY();
        double minZ = loc.getBlockZ();
        double maxX = loc2.getBlockX() + 1;
        double maxY = loc2.getBlockY() + 1;
        double maxZ = loc2.getBlockZ() + 1;
        for (double x = minX; x <= maxX; x += particleDistance) {
            for (double y = minY; y <= maxY; y += particleDistance) {
                for (double z = minZ; z <= maxZ; z += particleDistance) {
                    int components = 0;
                    if (x == minX || x == maxX) {
                        ++components;
                    }
                    if (y == minY || y == maxY) {
                        ++components;
                    }
                    if (z == minZ || z == maxZ) {
                        ++components;
                    }
                    if (components < 2) continue;
                    result.add(new Location(world, x, y, z));
                }
            }
        }
        return result;
    }

    default public void vfxCuboidOutline(Block block, Particle particle) {
        List<Location> hollowCube = this.getHollowCuboid(block.getLocation(), 0.25);
        for (Location l : hollowCube) {
            block.getWorld().spawnParticle(particle, l, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    default public void vfxCuboidOutline(Block blockStart, Block blockEnd, Particle particle) {
        List<Location> hollowCube = this.getHollowCuboid(blockStart.getLocation(), blockEnd.getLocation(), 0.25);
        for (Location l : hollowCube) {
            blockStart.getWorld().spawnParticle(particle, l, 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    default public void vfxCuboidOutline(Block blockStart, Block blockEnd, Color color, int size) {
        List<Location> hollowCube = this.getHollowCuboid(blockStart.getLocation(), blockEnd.getLocation(), 0.25);
        Particle.DustOptions dustOptions = new Particle.DustOptions(color, (float)size);
        for (Location l : hollowCube) {
            blockStart.getWorld().spawnParticle(Particle.REDSTONE, l, 2, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
    }

    default public void vfxPrismOutline(Location placer, double outset, Particle particle, int particleCount) {
        Location top = new Location(placer.getWorld(), placer.getX(), placer.getY() + outset, placer.getZ());
        Location baseCorner1 = new Location(placer.getWorld(), placer.getX() - outset, placer.getY(), placer.getZ() - outset);
        Location baseCorner2 = new Location(placer.getWorld(), placer.getX() + outset, placer.getY(), placer.getZ() - outset);
        Location baseCorner3 = new Location(placer.getWorld(), placer.getX() + outset, placer.getY(), placer.getZ() + outset);
        Location baseCorner4 = new Location(placer.getWorld(), placer.getX() - outset, placer.getY(), placer.getZ() + outset);
        this.vfxParticleLine(baseCorner1, baseCorner2, particle, particleCount, 1, 0.0, 0.0, 0.0, 0.0, null, true, l -> l.getBlock().isPassable());
        this.vfxParticleLine(baseCorner2, baseCorner3, particle, particleCount, 1, 0.0, 0.0, 0.0, 0.0, null, true, l -> l.getBlock().isPassable());
        this.vfxParticleLine(baseCorner3, baseCorner4, particle, particleCount, 1, 0.0, 0.0, 0.0, 0.0, null, true, l -> l.getBlock().isPassable());
        this.vfxParticleLine(baseCorner4, baseCorner1, particle, particleCount, 1, 0.0, 0.0, 0.0, 0.0, null, true, l -> l.getBlock().isPassable());
        for (Location location : Arrays.asList(baseCorner1, baseCorner2, baseCorner3, baseCorner4)) {
            this.vfxParticleLine(location, top, particle, particleCount, 1, 0.0, 0.0, 0.0, 0.0, null, true, l -> l.getBlock().isPassable());
        }
    }

    default public void vfxFastSphere(Location center, double range, Color color, int particleCount) {
        Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
        World world = center.getWorld();
        for (int i = 0; i < particleCount; ++i) {
            double z;
            double y;
            double x;
            while ((x = MathUtils.RANDOM.nextDouble() * 2.0 - 1.0) * x + (y = MathUtils.RANDOM.nextDouble() * 2.0 - 1.0) * y + (z = MathUtils.RANDOM.nextDouble() * 2.0 - 1.0) * z > 1.0) {
            }
            double magnitude = Math.sqrt(x * x + y * y + z * z);
            x = x / magnitude * range;
            y = y / magnitude * range;
            z = z / magnitude * range;
            Location particleLocation = center.clone().add(x, y, z);
            world.spawnParticle(Particle.REDSTONE, particleLocation, 0, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
    }

    default public void vfxLoadingRing(final Location center, final double radius, Color color, final int durationTicks, final int particleCount) {
        final World world = center.getWorld();
        final Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= durationTicks) {
                    this.cancel();
                    return;
                }
                double d = Math.PI * 2 * (double)this.tick / (double)durationTicks;
                double d2 = radius * Math.cos(d);
                double d3 = radius * Math.sin(d);
                Location location = center.clone().add(d2, 0.0, d3);
                world.spawnParticle(Particle.REDSTONE, location, particleCount, 0.0, 0.0, 0.0, (Object)dustOptions);
                ++this.tick;
            }
        }.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    default public void vfxLoadingRing(final Location center, final double radius, final Particle particle, final int durationTicks, final int particleCount) {
        final World world = center.getWorld();
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= durationTicks) {
                    this.cancel();
                    return;
                }
                double d = Math.PI * 2 * (double)this.tick / (double)durationTicks;
                double d2 = radius * Math.cos(d);
                double d3 = radius * Math.sin(d);
                Location location = center.clone().add(d2, 0.0, d3);
                world.spawnParticle(particle, location, particleCount, 0.0, 0.0, 0.0);
                ++this.tick;
            }
        }.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    default public void vfxLevelUp(Player p) {
        p.spawnParticle(Particle.REVERSE_PORTAL, p.getLocation().clone().add(0.0, 1.7, 0.0), 100, 0.1, 0.1, 0.1, 4.1);
    }

    default public void vfxFastRing(Location location, double radius, Color color) {
        for (int d = 0; d <= 90; ++d) {
            Location particleLoc = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
            particleLoc.setX(location.getX() + Math.cos(d) * radius);
            particleLoc.setZ(location.getZ() + Math.sin(d) * radius);
            location.getWorld().spawnParticle(Particle.REDSTONE, particleLoc, 1, (Object)new Particle.DustOptions(color, 1.0f));
        }
    }

    default public void vfxFastRing(Location location, double radius, Particle particle) {
        for (int d = 0; d <= 90; ++d) {
            Location particleLoc = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
            particleLoc.setX(location.getX() + Math.cos(d) * radius);
            particleLoc.setZ(location.getZ() + Math.sin(d) * radius);
            location.getWorld().spawnParticle(particle, particleLoc, 1);
        }
    }

    default public void vfxFastRing(Location location, double radius, Particle particle, int angle) {
        for (int d = 0; d <= 90; d += angle) {
            Location particleLoc = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
            particleLoc.setX(location.getX() + Math.cos(d) * radius);
            particleLoc.setZ(location.getZ() + Math.sin(d) * radius);
            location.getWorld().spawnParticle(particle, particleLoc, 1);
        }
    }

    default public void vfxShootParticle(Player player, Particle particle, double velocity, int count) {
        Location location = player.getEyeLocation();
        Vector direction = location.getDirection();
        for (int i = 0; i < count; ++i) {
            player.getWorld().spawnParticle(particle, location.getX(), location.getY(), location.getZ(), 0, (double)((float)direction.getX()), (double)((float)direction.getY()), (double)((float)direction.getZ()), velocity, null);
        }
    }

    default public void vfxParticleSpiral(Location center, int radius, int height, Particle type) {
        double angle = 0.0;
        for (int i = 0; i <= height; ++i) {
            double x = center.getX() + (double)radius * Math.cos(angle);
            double z = center.getZ() + (double)radius * Math.sin(angle);
            center.getWorld().spawnParticle(type, x, center.getY(), z, 1, 0.0, 0.0, 0.0, 0.0);
            angle += 0.1;
        }
    }

    default public void vfxXP(Player p, Location l, int amt) {
        if (AdaptConfig.get().isUseEnchantmentTableParticleForActiveEffects()) {
            p.spawnParticle(Particle.ENCHANTMENT_TABLE, l, Math.min(amt / 10, 20), 0.5, 0.5, 0.5, 1.0);
        }
    }

    default public void vfxXP(Location l) {
        if (AdaptConfig.get().isUseEnchantmentTableParticleForActiveEffects()) {
            l.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, l.add(0.0, 1.7, 0.0), 3, 0.1, 0.1, 0.1, 3.0);
        }
    }

    default public void damageHand(Player p, int damage) {
        ItemStack is = p.getInventory().getItemInMainHand();
        ItemMeta im = is.getItemMeta();
        if (im == null) {
            return;
        }
        if (im.isUnbreakable()) {
            return;
        }
        Damageable dm = (Damageable)im;
        dm.setDamage(dm.getDamage() + damage);
        if (dm.getDamage() > is.getType().getMaxDurability()) {
            p.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            return;
        }
        is.setItemMeta(im);
        p.getInventory().setItemInMainHand(is);
    }

    default public void damageOffHand(Player p, int damage) {
        ItemStack is = p.getInventory().getItemInOffHand();
        ItemMeta im = is.getItemMeta();
        if (im == null) {
            return;
        }
        if (im.isUnbreakable()) {
            return;
        }
        Damageable dm = (Damageable)im;
        dm.setDamage(dm.getDamage() + damage);
        if (dm.getDamage() > is.getType().getMaxDurability()) {
            p.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
            p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            return;
        }
        is.setItemMeta(im);
        p.getInventory().setItemInOffHand(is);
    }

    default public Block getRightBlock(Player p, Block b) {
        float yaw;
        Location l = p.getLocation();
        for (yaw = l.getYaw(); yaw < 0.0f; yaw += 360.0f) {
        }
        if ((yaw %= 360.0f) < 45.0f || yaw >= 315.0f) {
            BlockFace rightFace = BlockFace.EAST;
            return b.getRelative(rightFace);
        }
        if (yaw < 135.0f) {
            BlockFace rightFace = BlockFace.SOUTH;
            return b.getRelative(rightFace);
        }
        if (yaw < 225.0f) {
            BlockFace rightFace = BlockFace.WEST;
            return b.getRelative(rightFace);
        }
        if (yaw < 315.0f) {
            BlockFace rightFace = BlockFace.NORTH;
            return b.getRelative(rightFace);
        }
        return null;
    }

    default public Block getLeftBlock(Player p, Block b) {
        float yaw;
        Location l = p.getLocation();
        for (yaw = l.getYaw(); yaw < 0.0f; yaw += 360.0f) {
        }
        if ((yaw %= 360.0f) < 45.0f || yaw >= 315.0f) {
            BlockFace leftFace = BlockFace.WEST;
            return b.getRelative(leftFace);
        }
        if (yaw < 135.0f) {
            BlockFace leftFace = BlockFace.NORTH;
            return b.getRelative(leftFace);
        }
        if (yaw < 225.0f) {
            BlockFace leftFace = BlockFace.EAST;
            return b.getRelative(leftFace);
        }
        if (yaw < 315.0f) {
            BlockFace leftFace = BlockFace.SOUTH;
            return b.getRelative(leftFace);
        }
        return null;
    }

    default public void setExp(Player p, int exp) {
        p.setExp(0.0f);
        p.setLevel(0);
        p.setTotalExperience(0);
        if (exp <= 0) {
            return;
        }
        this.giveExp(p, exp);
    }

    default public void giveExp(Player p, int exp) {
        while (exp > 0) {
            int xp = this.getExpToLevel(p) - this.getExp(p);
            if (xp > exp) {
                xp = exp;
            }
            p.giveExp(xp);
            exp -= xp;
        }
    }

    default public void takeExp(Player p, int exp) {
        this.takeExp(p, exp, true);
    }

    default public void takeExp(Player p, int exp, boolean fromTotal) {
        int xp = this.getTotalExp(p);
        if (fromTotal) {
            xp -= exp;
        } else {
            int m = this.getExp(p) - exp;
            if (m < 0) {
                m = 0;
            }
            xp -= this.getExp(p) + m;
        }
        this.setExp(p, xp);
    }

    default public int getExp(Player p) {
        return (int)((float)this.getExpToLevel(p) * p.getExp());
    }

    default public int getTotalExp(Player p) {
        return this.getTotalExp(p, false);
    }

    default public int getTotalExp(Player p, boolean recalc) {
        if (recalc) {
            this.recalcTotalExp(p);
        }
        return p.getTotalExperience();
    }

    default public int getLevel(Player p) {
        return p.getLevel();
    }

    default public int getExpToLevel(Player p) {
        return p.getExpToLevel();
    }

    default public int getExpToLevel(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    default public void recalcTotalExp(Player p) {
        int total = this.getExp(p);
        for (int i = 0; i < p.getLevel(); ++i) {
            total += this.getExpToLevel(i);
        }
        p.setTotalExperience(total);
    }

    default public boolean takeAll(Inventory inv, ItemStack is, int amount) {
        ItemStack isf = is.clone();
        isf.setAmount(amount);
        return this.takeAll(inv, is);
    }

    default public boolean takeOne(Inventory inv, ItemStack is, int amount) {
        return this.takeAll(inv, is, 1);
    }

    default public boolean takeAll(Inventory inv, ItemStack is) {
        ItemStack[] items = inv.getStorageContents();
        int take = is.getAmount();
        for (int ii = 0; ii < items.length; ++ii) {
            ItemStack i = items[ii];
            if (i == null || !i.isSimilar(is)) continue;
            if (take > i.getAmount()) {
                i.setAmount(i.getAmount() - take);
                items[ii] = i;
                take = 0;
                break;
            }
            items[ii] = null;
            take -= i.getAmount();
        }
        if (take > 0) {
            return false;
        }
        inv.setStorageContents(items);
        return true;
    }
}

