/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.potion;

import com.google.common.collect.Lists;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionBuilder {
    private final List<PotionEffect> effects = Lists.newArrayList();
    private final Type type;
    private String name;
    private Color color;
    private boolean upgraded;
    private boolean extended;
    private PotionType baseType = PotionType.UNCRAFTABLE;

    private PotionBuilder(Type type) {
        this.type = type;
    }

    public static ItemStack vanilla(Type type, PotionType potionType, boolean bl, boolean bl2) {
        return PotionBuilder.of(type).setFlags(bl, bl2).setBaseType(potionType).build();
    }

    public static PotionBuilder of(Type type) {
        return new PotionBuilder(type);
    }

    public PotionBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public PotionBuilder addEffect(PotionEffectType potionEffectType, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.effects.add(new PotionEffect(potionEffectType, n, n2, bl, bl2, bl3));
        return this;
    }

    public PotionBuilder setFlags(boolean bl, boolean bl2) {
        this.upgraded = bl2;
        this.extended = bl;
        return this;
    }

    public PotionBuilder setName(String string) {
        this.name = string;
        return this;
    }

    private PotionBuilder setBaseType(PotionType potionType) {
        this.baseType = potionType;
        return this;
    }

    public ItemStack build() {
        ItemStack itemStack = new ItemStack(this.type.material);
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        this.effects.forEach(potionEffect -> potionMeta.addCustomEffect(potionEffect, true));
        if (this.color != null) {
            potionMeta.setColor(this.color);
        }
        potionMeta.setBasePotionData(new PotionData(this.baseType, this.extended, this.upgraded));
        if (this.name != null) {
            potionMeta.setDisplayName("\u00a7r" + this.name);
        }
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static enum Type {
        REGULAR(Material.POTION),
        SPLASH(Material.SPLASH_POTION),
        LINGERING(Material.LINGERING_POTION);

        private final Material material;

        private Type(Material material) {
            this.material = material;
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

