/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.manager.AdvancementManager;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;

public class AdvancementHandler {
    private AdvancementManager manager;
    private AdaptPlayer player;
    private Map<Skill<?>, AdaptAdvancement> roots;
    private Map<String, Advancement> real;
    private boolean ready;

    public AdvancementHandler(AdaptPlayer adaptPlayer) {
        this.player = adaptPlayer;
        this.manager = new AdvancementManager(new NameKey("adapt", adaptPlayer.getPlayer().getUniqueId().toString()), adaptPlayer.getPlayer());
        this.roots = new HashMap();
        this.real = new HashMap<String, Advancement>();
        this.ready = false;
    }

    public void activate() {
        if (!AdaptConfig.get().isAdvancements()) {
            return;
        }
        J.s(() -> {
            this.removeAllAdvancements();
            for (Skill<?> skill : this.player.getServer().getSkillRegistry().getSkills()) {
                AdaptAdvancement adaptAdvancement = skill.buildAdvancements();
                this.roots.put(skill, adaptAdvancement);
                for (Advancement advancement : XList.reverse(adaptAdvancement.toAdvancements())) {
                    this.real.put(advancement.getName().getKey(), advancement);
                    try {
                        this.getManager().addAdvancement(advancement);
                    }
                    catch (Throwable throwable) {
                        Adapt.error("Failed to register advancement " + advancement.getName().getKey());
                        throwable.printStackTrace();
                    }
                }
                this.unlockExisting(adaptAdvancement);
                J.s(() -> {
                    this.ready = true;
                }, 40);
            }
        }, 20);
    }

    public void grant(String string, boolean bl) {
        this.getPlayer().getData().ensureGranted(string);
        try {
            J.s(() -> this.getManager().grantAdvancement(this.player.getPlayer(), this.real.get(string)), 5);
        }
        catch (Exception exception) {
            Adapt.error("Failed to grant advancement " + string);
        }
        if (bl && this.getPlayer() != null && this.getPlayer().getPlayer() != null) {
            try {
                this.real.get(string).displayToast(this.getPlayer().getPlayer());
            }
            catch (Exception exception) {
                Adapt.error("Failed to grant advancement " + string + " Reattaching!");
            }
        }
    }

    public void grant(String string) {
        this.grant(string, true);
    }

    private void unlockExisting(AdaptAdvancement adaptAdvancement) {
        if (adaptAdvancement.getChildren() != null) {
            for (AdaptAdvancement adaptAdvancement2 : adaptAdvancement.getChildren()) {
                this.unlockExisting(adaptAdvancement2);
            }
        }
        if (this.getPlayer().getData().isGranted(adaptAdvancement.getKey())) {
            J.s(() -> this.grant(adaptAdvancement.getKey(), false), 20);
        }
    }

    public void deactivate() {
        this.removeAllAdvancements();
    }

    public void removeAllAdvancements() {
        for (Advancement advancement : this.getManager().getAdvancements()) {
            this.getManager().removeAdvancement(advancement);
        }
    }

    public AdvancementManager getManager() {
        return this.manager;
    }

    public AdaptPlayer getPlayer() {
        return this.player;
    }

    public Map<Skill<?>, AdaptAdvancement> getRoots() {
        return this.roots;
    }

    public Map<String, Advancement> getReal() {
        return this.real;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setManager(AdvancementManager advancementManager) {
        this.manager = advancementManager;
    }

    public void setPlayer(AdaptPlayer adaptPlayer) {
        this.player = adaptPlayer;
    }

    public void setRoots(Map<Skill<?>, AdaptAdvancement> map) {
        this.roots = map;
    }

    public void setReal(Map<String, Advancement> map) {
        this.real = map;
    }

    public void setReady(boolean bl) {
        this.ready = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdvancementHandler)) {
            return false;
        }
        AdvancementHandler advancementHandler = (AdvancementHandler)object;
        if (!advancementHandler.canEqual(this)) {
            return false;
        }
        if (this.isReady() != advancementHandler.isReady()) {
            return false;
        }
        AdvancementManager advancementManager = this.getManager();
        AdvancementManager advancementManager2 = advancementHandler.getManager();
        if (advancementManager == null ? advancementManager2 != null : !advancementManager.equals(advancementManager2)) {
            return false;
        }
        AdaptPlayer adaptPlayer = this.getPlayer();
        AdaptPlayer adaptPlayer2 = advancementHandler.getPlayer();
        if (adaptPlayer == null ? adaptPlayer2 != null : !((Object)adaptPlayer).equals(adaptPlayer2)) {
            return false;
        }
        Map<Skill<?>, AdaptAdvancement> map = this.getRoots();
        Map<Skill<?>, AdaptAdvancement> map2 = advancementHandler.getRoots();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        Map<String, Advancement> map3 = this.getReal();
        Map<String, Advancement> map4 = advancementHandler.getReal();
        return !(map3 == null ? map4 != null : !((Object)map3).equals(map4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof AdvancementHandler;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isReady() ? 79 : 97);
        AdvancementManager advancementManager = this.getManager();
        n2 = n2 * 59 + (advancementManager == null ? 43 : advancementManager.hashCode());
        AdaptPlayer adaptPlayer = this.getPlayer();
        n2 = n2 * 59 + (adaptPlayer == null ? 43 : ((Object)adaptPlayer).hashCode());
        Map<Skill<?>, AdaptAdvancement> map = this.getRoots();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        Map<String, Advancement> map2 = this.getReal();
        n2 = n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
        return n2;
    }

    public String toString() {
        return "AdvancementHandler(manager=" + this.getManager() + ", player=" + this.getPlayer() + ", roots=" + this.getRoots() + ", real=" + this.getReal() + ", ready=" + this.isReady() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

