/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.agility;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.util.Vector;

public class AgilityWallJump
extends SimpleAdaptation<Config> {
    private final Map<Player, Double> airjumps;

    public AgilityWallJump() {
        super("agility-wall-jump");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("agility", "walljump", "description"));
        this.setDisplayName(Localizer.dLocalize("agility", "walljump", "name"));
        this.setIcon(Material.LADDER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(50L);
        this.airjumps = new HashMap<Player, Double>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + this.getMaxJumps(n) + C.GRAY + " " + Localizer.dLocalize("agility", "walljump", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.pc(this.getJumpHeight(n), 0) + C.GRAY + " " + Localizer.dLocalize("agility", "walljump", "lore2"));
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.airjumps.remove(player);
    }

    private int getMaxJumps(int n) {
        return (int)((double)n + (double)n / ((Config)this.getConfig()).maxJumpsLevelBonusDivisor);
    }

    private double getJumpHeight(int n) {
        return ((Config)this.getConfig()).jumpHeightBase + this.getLevelPercent(n) * ((Config)this.getConfig()).jumpHeightBonusLevelMultiplier;
    }

    @EventHandler
    public void on(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (!this.canInteract(player, player.getLocation())) {
            return;
        }
        if (this.airjumps.containsKey(player) && player.isOnGround() && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getBlockData().getMaterial().isAir()) {
            this.airjumps.remove(player);
        }
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Double d;
            int n = this.getLevel(player);
            if (n <= 0) continue;
            Double d2 = this.airjumps.get(player);
            if (d2 != null && d2 - 0.25 >= (double)this.getMaxJumps(n)) {
                player.setGravity(true);
                continue;
            }
            if (!this.canInteract(player, player.getLocation())) {
                return;
            }
            if (player.isFlying() || !player.isSneaking() || (double)player.getFallDistance() < 0.3) {
                boolean bl = false;
                if (!player.hasGravity() && (double)player.getFallDistance() > 0.45 && this.canStick(player)) {
                    d = d2 = Double.valueOf(d2 == null ? 0.0 : d2);
                    d2 = d2 + 1.0;
                    if (d2 - 0.25 <= (double)this.getMaxJumps(n) && this.getStick(player) != null) {
                        bl = true;
                        player.setVelocity(player.getVelocity().setY(this.getJumpHeight(n)));
                        if (((Config)this.getConfig()).showParticles) {
                            player.getWorld().spawnParticle(Particle.BLOCK_CRACK, player.getLocation().clone().add(0.0, 0.3, 0.0), 15, 0.1, 0.8, 0.1, 0.1, (Object)this.getStick(player).getBlockData());
                        }
                    }
                    this.airjumps.put(player, d2);
                }
                if (bl || player.hasGravity()) continue;
                player.setGravity(true);
                player.getLocation().getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 0.439f);
                continue;
            }
            if (this.canStick(player)) {
                if (player.hasGravity()) {
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 0.89f);
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_CHAIN, 1.0f, 1.39f);
                    if (((Config)this.getConfig()).showParticles && this.getStick(player) != null) {
                        player.getWorld().spawnParticle(Particle.BLOCK_CRACK, player.getLocation().clone().add(0.0, 0.3, 0.0), 15, 0.1, 0.2, 0.1, 0.1, (Object)this.getStick(player).getBlockData());
                    }
                }
                player.setGravity(false);
                Vector vector = player.getVelocity();
                player.setVelocity(player.getVelocity().setY(vector.getY() * 0.35 - 0.0025));
                d = this.airjumps.get(player);
                d = d == null ? 0.0 : d;
                d = d + 0.0127;
                this.airjumps.put(player, d);
            }
            if (this.canStick(player) || player.hasGravity()) continue;
            player.setGravity(true);
        }
    }

    private boolean canStick(Player player) {
        for (Block block : this.getBlocks(player)) {
            if (!block.getBlockData().getMaterial().isSolid()) continue;
            Vector vector = player.getVelocity();
            Vector vector2 = player.getLocation().subtract(block.getLocation().clone().add(0.5, 0.5, 0.5)).toVector();
            vector.setX(vector.getX() - vector2.getX() / 16.0);
            vector.setZ(vector.getZ() - vector2.getZ() / 16.0);
            player.setVelocity(vector);
            return true;
        }
        return false;
    }

    private Block getStick(Player player) {
        this.getBlocks(player);
        for (Block block : this.getBlocks(player)) {
            if (!block.getBlockData().getMaterial().isSolid()) continue;
            return block;
        }
        return null;
    }

    private Block[] getBlocks(Player player) {
        return new Block[]{player.getLocation().getBlock().getRelative(BlockFace.NORTH), player.getLocation().getBlock().getRelative(BlockFace.SOUTH), player.getLocation().getBlock().getRelative(BlockFace.EAST), player.getLocation().getBlock().getRelative(BlockFace.WEST), player.getLocation().getBlock().getRelative(BlockFace.NORTH_EAST), player.getLocation().getBlock().getRelative(BlockFace.SOUTH_EAST), player.getLocation().getBlock().getRelative(BlockFace.NORTH_WEST), player.getLocation().getBlock().getRelative(BlockFace.SOUTH_WEST), player.getLocation().getBlock().getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.NORTH).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.EAST).getRelative(BlockFace.UP), player.getLocation().getBlock().getRelative(BlockFace.WEST).getRelative(BlockFace.UP)};
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        double costFactor = 0.65;
        int maxLevel = 5;
        int initialCost = 8;
        double maxJumpsLevelBonusDivisor = 2.0;
        double jumpHeightBase = 0.625;
        double jumpHeightBonusLevelMultiplier = 0.225;

        static {
            IBootstrap.dasBoot();
        }
    }
}

