/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class AxeLeafVeinminer
extends SimpleAdaptation<Config> {
    public AxeLeafVeinminer() {
        super("axe-leaf-veinminer");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "leafminer", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "leafminer", "name"));
        this.setIcon(Material.BIRCH_LEAVES);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(5849L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("axe", "leafminer", "lore1"));
        element.addLore(C.GREEN + (n + ((Config)this.getConfig()).baseRange) + C.GRAY + " " + Localizer.dLocalize("axe", "leafminer", "lore2"));
        element.addLore(C.ITALIC + Localizer.dLocalize("axe", "leafminer", "lore3"));
    }

    private int getRadius(int n) {
        return n + ((Config)this.getConfig()).baseRange;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (this.hasAdaptation(player)) {
            if (!player.isSneaking()) {
                return;
            }
            if (!this.isAxe(player.getInventory().getItemInMainHand())) {
                return;
            }
            if (this.isLeaves(new ItemStack(blockBreakEvent.getBlock().getType()))) {
                Block block = blockBreakEvent.getBlock();
                HashMap<Location, Block> hashMap = new HashMap<Location, Block>();
                hashMap.put(block.getLocation(), block);
                for (int i = 0; i < this.getRadius(this.getLevel(player)); ++i) {
                    for (int j = -i; j <= i; ++j) {
                        for (int k = -i; k <= i; ++k) {
                            for (int i2 = -i; i2 <= i; ++i2) {
                                Block block2 = block.getRelative(j, k, i2);
                                if (block2.getType() != block.getType() || block.getLocation().distance(block2.getLocation()) > (double)this.getRadius(this.getLevel(player))) continue;
                                if (!this.canBlockBreak(player, block2.getLocation())) {
                                    Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
                                    continue;
                                }
                                hashMap.put(block2.getLocation(), block2);
                            }
                        }
                    }
                }
                J.s(() -> {
                    for (Location location : hashMap.keySet()) {
                        Block block = blockBreakEvent.getBlock().getWorld().getBlockAt(location);
                        if (this.getPlayer(player).getData().getSkillLines() != null && this.getPlayer(player).getData().getSkillLines().get("axes").getAdaptations() != null && this.getPlayer(player).getData().getSkillLines().get("axes").getAdaptations().get("axe-drop-to-inventory") != null && this.getPlayer(player).getData().getSkillLines().get("axes").getAdaptations().get("axe-drop-to-inventory").getLevel() > 0) {
                            Collection collection = blockBreakEvent.getBlock().getDrops();
                            for (ItemStack itemStack : collection) {
                                player.playSound(player.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.01f, 0.01f);
                                HashMap hashMap = player.getInventory().addItem(new ItemStack[]{itemStack});
                                if (hashMap.isEmpty()) continue;
                                player.getWorld().dropItem(player.getLocation(), (ItemStack)hashMap.get(0));
                            }
                            player.breakBlock(location.getBlock());
                        } else {
                            block.breakNaturally(player.getItemInUse());
                            blockBreakEvent.getBlock().getWorld().playSound(blockBreakEvent.getBlock().getLocation(), Sound.BLOCK_FUNGUS_BREAK, 0.01f, 0.25f);
                            if (((Config)this.getConfig()).showParticles) {
                                blockBreakEvent.getBlock().getWorld().spawnParticle(Particle.ASH, blockBreakEvent.getBlock().getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.1);
                            }
                        }
                        if (!((Config)this.getConfig()).showParticles) continue;
                        this.vfxCuboidOutline(block, Particle.ENCHANTMENT_TABLE);
                    }
                });
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 1;
        double costFactor = 0.325;
        int baseRange = 5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

