/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerExpChangeEvent;
import xyz.xenondevs.particle.utils.MathUtils;

public class DiscoveryUnity
extends SimpleAdaptation<Config> {
    public DiscoveryUnity() {
        super("discovery-unity");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "unity", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "unity", "name"));
        this.setIcon(Material.REDSTONE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(666L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.f(this.getXPGained(this.getLevelPercent(n), 1), 0) + " " + Localizer.dLocalize("discovery", "unity", "lore1") + C.GRAY + " " + Localizer.dLocalize("discovery", "unity", "lore2"));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(PlayerExpChangeEvent playerExpChangeEvent) {
        Player player = playerExpChangeEvent.getPlayer();
        AdaptPlayer adaptPlayer = this.getPlayer(player);
        if (this.hasAdaptation(player) && playerExpChangeEvent.getAmount() > 0) {
            this.xp(player, 5.0);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.9f);
            List<PlayerSkillLine> list = XMap.sortV(adaptPlayer.getData().getSkillLines());
            if (list.size() > 0) {
                PlayerSkillLine playerSkillLine = list.get(MathUtils.RANDOM.nextInt(list.size()));
                playerSkillLine.giveXPFresh(Adapt.instance.getAdaptServer().getPlayer(player).getNot(), this.getXPGained(this.getLevelPercent(this.getLevel(player)), MathUtils.RANDOM.nextInt(3) + 1));
            }
        }
    }

    private double getXPGained(double d, int n) {
        return (double)n * ((Config)this.getConfig()).xpGainedMultiplier * d;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 7;
        double xpGainedMultiplier = 8.0;
        double xpBoostMultiplier = 0.01;
        int xpBoostDuration = 15000;

        static {
            IBootstrap.dasBoot();
        }
    }
}

