/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.enchanting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class EnchantingLapisReturn
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldown = new HashMap<Player, Long>();

    public EnchantingLapisReturn() {
        super("enchanting-lapis-return");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("enchanting", "lapisreturn", "description"));
        this.setDisplayName(Localizer.dLocalize("enchanting", "lapisreturn", "name"));
        this.setIcon(Material.LAPIS_LAZULI);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(20999L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("enchanting", "lapisreturn", "lore1"));
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.cooldown.remove(player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(EnchantItemEvent enchantItemEvent) {
        if (enchantItemEvent.isCancelled()) {
            return;
        }
        Player player = enchantItemEvent.getEnchanter();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (Math.random() * 100.0 > 80.0) {
            if (this.cooldown.containsKey(player) && this.cooldown.get(player) + 20000L < System.currentTimeMillis()) {
                this.cooldown.remove(player);
            } else if (this.cooldown.containsKey(player) && this.cooldown.get(player) + 20000L > System.currentTimeMillis()) {
                return;
            }
            this.cooldown.put(player, System.currentTimeMillis());
            player.getWorld().dropItemNaturally(player.getLocation(), new ItemStack(Material.LAPIS_LAZULI, this.getLevel(player)));
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 3;
        int initialCost = 2;
        double costFactor = 2.25;

        static {
            IBootstrap.dasBoot();
        }
    }
}

