/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.excavation;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.nms.GlowingEntities;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ExcavationSpelunker
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public ExcavationSpelunker() {
        super("excavation-spelunker");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("excavation", "spelunker", "name"));
        this.setDescription(Localizer.dLocalize("excavation", "spelunker", "description"));
        this.setIcon(Material.GOLDEN_HELMET);
        this.setInterval(20388L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("excavation", "spelunker", "lore1"));
        element.addLore(C.YELLOW + Localizer.dLocalize("excavation", "spelunker", "lore2") + ((Config)this.getConfig()).rangeMultiplier * n);
        element.addLore(C.YELLOW + Localizer.dLocalize("excavation", "spelunker", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        Player player = playerToggleSneakEvent.getPlayer();
        if (player.isSneaking() && this.hasGlowberries(player) && this.hasOreInOffhand(player) && this.hasAdaptation(player)) {
            if (this.cooldowns.containsKey(player) && this.cooldowns.get(player).compareTo(System.currentTimeMillis()) > 0) {
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                return;
            }
            int n = ((Config)this.getConfig()).rangeMultiplier * this.getLevel(player);
            this.consumeGlowberry(player);
            this.searchForOres(player, n);
            this.cooldowns.put(player, (long)((double)System.currentTimeMillis() + 1000.0 * ((Config)this.getConfig()).cooldown));
        }
    }

    private boolean hasGlowberries(Player player) {
        return player.getInventory().getItemInMainHand().getType() == Material.GLOW_BERRIES;
    }

    private void consumeGlowberry(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        itemStack.setAmount(itemStack.getAmount() - 1);
        player.getInventory().setItemInMainHand(itemStack);
    }

    private boolean hasOreInOffhand(Player player) {
        Material material = player.getInventory().getItemInOffHand().getType();
        return ItemListings.ores.contains(material);
    }

    private void searchForOres(Player player, int n) {
        Location location = player.getLocation();
        World world = player.getWorld();
        Material material = player.getInventory().getItemInOffHand().getType();
        ChatColor chatColor = ItemListings.oreColorsChatColor.get(material);
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.WHITE, 1.0f);
        J.a(() -> {
            for (int i = -n; i <= n; ++i) {
                for (int j = -n; j <= n; ++j) {
                    for (int k = -n; k <= n; ++k) {
                        if (i * i + j * j + k * k > n * n) continue;
                        Location location2 = location.clone().add((double)i, (double)j, (double)k);
                        Block block = world.getBlockAt(location2);
                        GlowingEntities glowingEntities = Adapt.instance.getGlowingEntities();
                        if (block.getType() != material) continue;
                        Vector vector = location2.clone().subtract(location).toVector().normalize().multiply(0.5);
                        Location location3 = location.clone();
                        while (location3.distance(location2) > 0.5) {
                            location3.add(vector);
                            J.s(() -> player.spawnParticle(Particle.REDSTONE, location3, 1, (Object)dustOptions));
                        }
                        J.s(() -> {
                            world.playSound(block.getLocation().add(0.5, 0.0, 0.5), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                            Slime slime2 = (Slime)block.getWorld().spawn(block.getLocation().add(0.5, 0.0, 0.5), Slime.class, slime -> {
                                slime.setRotation(0.0f, 0.0f);
                                slime.setInvulnerable(true);
                                slime.setCollidable(false);
                                slime.setGravity(false);
                                slime.setSilent(true);
                                slime.setAI(false);
                                slime.setSize(2);
                                slime.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
                                slime.setMetadata("preventSuffocation", (MetadataValue)new FixedMetadataValue((Plugin)Adapt.instance, (Object)true));
                            });
                            try {
                                glowingEntities.setGlowing((Entity)slime2, player, chatColor);
                            }
                            catch (ReflectiveOperationException reflectiveOperationException) {
                                throw new RuntimeException(reflectiveOperationException);
                            }
                            J.s(() -> {
                                try {
                                    glowingEntities.unsetGlowing((Entity)slime2, player);
                                }
                                catch (ReflectiveOperationException reflectiveOperationException) {
                                    throw new RuntimeException(reflectiveOperationException);
                                }
                                slime2.remove();
                            }, 100);
                        });
                    }
                }
            }
        });
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Slime && entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            Slime slime = (Slime)entityDamageEvent.getEntity();
            if (slime.hasMetadata("preventSuffocation")) {
                entityDamageEvent.setCancelled(true);
            } else {
                entityDamageEvent.setCancelled(true);
                slime.remove();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        double cooldown = 6.0;
        int baseCost = 5;
        int initialCost = 10;
        double costFactor = 1.0;
        int maxLevel = 5;
        int rangeMultiplier = 5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

