/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.skill.SkillHerbalism;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class HerbalismReplant
extends SimpleAdaptation<Config> {
    public HerbalismReplant() {
        super("herbalism-replant");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "replant", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "replant", "name"));
        this.setIcon(Material.PUMPKIN_SEEDS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(6090L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + this.getRadius(n) + C.GRAY + Localizer.dLocalize("herbalism", "replant", "lore1"));
    }

    private int getCooldown(double d, int n) {
        if (n == 1) {
            return (int)((Config)this.getConfig()).cooldownLvl1;
        }
        return (int)(((Config)this.getConfig()).baseCooldown - ((Config)this.getConfig()).cooldownFactor * d + ((Config)this.getConfig()).bonusCooldown);
    }

    private float getRadius(int n) {
        return n - ((Config)this.getConfig()).radiusSub;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getClickedBlock() == null) {
            return;
        }
        if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!(playerInteractEvent.getClickedBlock().getBlockData() instanceof Ageable)) {
            return;
        }
        int n = this.getLevel(player);
        if (n > 0) {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            ItemStack itemStack2 = player.getInventory().getItemInOffHand();
            if (this.isTool(itemStack2) && this.isHoe(itemStack2) && !player.hasCooldown(itemStack2.getType())) {
                this.damageOffHand(player, 1 + (n - 1) * 7);
                player.setCooldown(itemStack2.getType(), this.getCooldown(this.getLevelPercent(player), this.getLevel(player)));
            } else if (this.isTool(itemStack) && this.isHoe(itemStack) && !player.hasCooldown(itemStack.getType())) {
                this.damageHand(player, 1 + (n - 1) * 7);
                player.setCooldown(itemStack.getType(), this.getCooldown(this.getLevelPercent(player), this.getLevel(player)));
            } else {
                return;
            }
            if (n > 1) {
                Cuboid cuboid = new Cuboid(playerInteractEvent.getClickedBlock().getLocation().clone().add(0.5, 0.5, 0.5));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.Up, (int)Math.floor(this.getRadius(n)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.Down, (int)Math.floor(this.getRadius(n)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.North, Math.round(this.getRadius(n)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.South, Math.round(this.getRadius(n)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.East, Math.round(this.getRadius(n)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.West, Math.round(this.getRadius(n)));
                for (Block block : cuboid) {
                    J.s(() -> this.hit(player, block), M.irand(1, 6));
                }
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_SHOVEL_FLATTEN, 1.0f, 0.66f);
                player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BAMBOO_SAPLING_BREAK, 1.0f, 0.66f);
                if (((Config)this.getConfig()).showParticles) {
                    player.spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation().clone().add(0.5, 0.5, 0.5), this.getLevel(player) * 3, 0.3 * (double)this.getLevel(player), 0.3 * (double)this.getLevel(player), 0.3 * (double)this.getLevel(player), 0.9);
                }
            } else {
                this.hit(player, playerInteractEvent.getClickedBlock());
            }
        }
    }

    private void hit(Player player, Block block) {
        Object object;
        if (block != null && (object = block.getBlockData()) instanceof Ageable) {
            Ageable ageable = (Ageable)object;
            if (this.hasAdaptation(player)) {
                if (ageable.getAge() == 0) {
                    return;
                }
                this.xp(player, block.getLocation().clone().add(0.5, 0.5, 0.5), ((SkillHerbalism.Config)this.getSkill().getConfig()).harvestPerAgeXP * (double)ageable.getAge());
                this.xp(player, block.getLocation().clone().add(0.5, 0.5, 0.5), ((SkillHerbalism.Config)this.getSkill().getConfig()).plantCropSeedsXP);
                if (this.getPlayer(player).getData().getSkillLines().get("herbalism").getAdaptations().get("herbalism-drop-to-inventory") != null && this.getPlayer(player).getData().getSkillLines().get("herbalism").getAdaptations().get("herbalism-drop-to-inventory").getLevel() > 0) {
                    object = block.getDrops();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ItemStack itemStack = (ItemStack)iterator.next();
                        player.playSound(player.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
                        itemStack.setAmount(1);
                        if (player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) continue;
                        player.getWorld().dropItem(player.getLocation(), itemStack);
                    }
                    ageable.setAge(0);
                    J.s(() -> block.setBlockData((BlockData)ageable, true));
                } else {
                    player.breakBlock(block);
                }
                ageable.setAge(0);
                J.s(() -> block.setBlockData((BlockData)ageable, true));
                this.getPlayer(player).getData().addStat("harvest.blocks", 1.0);
                this.getPlayer(player).getData().addStat("harvest.planted", 1.0);
                if (M.r(1.0 / (double)this.getLevel(player))) {
                    player.getWorld().playSound(block.getLocation(), Sound.ITEM_CROP_PLANT, 1.0f, 0.7f);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 3;
        int initialCost = 4;
        double costFactor = 2.325;
        double cooldownLvl1 = 2.0;
        double baseCooldown = 30.0;
        double cooldownFactor = 30.0;
        double bonusCooldown = 20.0;
        int radiusSub = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

