/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.item.BoundEnderPearl;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;

public class RiftAccess
extends SimpleAdaptation<Config> {
    private final List<InventoryView> activeViews = new ArrayList<InventoryView>();

    public RiftAccess() {
        super("rift-access");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "remoteaccess", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "remoteaccess", "name"));
        this.setMaxLevel(1);
        this.setIcon(Material.NETHER_STAR);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(5544L);
        this.registerRecipe(AdaptRecipe.shapeless().key("rift-remote-access").ingredient(Material.ENDER_PEARL).ingredient(Material.COMPASS).result(BoundEnderPearl.io.withData(new BoundEnderPearl.Data(null))).build());
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore1"));
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore2"));
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        Block block = playerInteractEvent.getClickedBlock();
        boolean bl = BoundEnderPearl.isBindableItem(itemStack);
        boolean bl2 = BoundEnderPearl.isBindableItem(itemStack2);
        if (bl2 && playerInteractEvent.getHand() != null && playerInteractEvent.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (bl) {
            playerInteractEvent.setCancelled(true);
            if (this.hasAdaptation(player)) {
                Adapt.verbose("Player using bound enderpearl.");
                this.handleEnderPearlInteraction(playerInteractEvent, player, block);
            }
        }
    }

    private void handleEnderPearlInteraction(PlayerInteractEvent playerInteractEvent, Player player, Block block) {
        boolean bl;
        boolean bl2 = AdaptConfig.get().allowAdaptationsInCreative;
        boolean bl3 = player.getGameMode() == GameMode.CREATIVE;
        boolean bl4 = player.isSneaking();
        boolean bl5 = bl = bl2 || !bl3;
        if (!bl) {
            Adapt.info("Player " + player.getName() + " tried to use the bound item in creative mode.");
            return;
        }
        switch (playerInteractEvent.getAction()) {
            case LEFT_CLICK_BLOCK: {
                if (!bl4 || !this.isStorage(block.getBlockData())) break;
                if (this.canAccessChest(player, block.getLocation())) {
                    this.linkPearl(player, block, playerInteractEvent);
                    break;
                }
                Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                this.openPearl(player);
                break;
            }
        }
    }

    private void linkPearl(Player player, Block block, PlayerInteractEvent playerInteractEvent) {
        playerInteractEvent.setCancelled(true);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.REVERSE_PORTAL);
        }
        ItemStack itemStack2 = player.getInventory().getItemInMainHand();
        player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_CLOSE, 0.5f, 0.8f);
        if (itemStack2.getAmount() == 1) {
            BoundEnderPearl.setData(itemStack2, block);
        } else {
            itemStack2.setAmount(itemStack2.getAmount() - 1);
            ItemStack itemStack3 = BoundEnderPearl.withData(block);
            player.getInventory().addItem(new ItemStack[]{itemStack3}).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
        }
    }

    private void openPearl(Player player) {
        Block block = BoundEnderPearl.getBlock(player.getInventory().getItemInMainHand());
        if (block == null || !this.canAccessChest(player, block.getLocation())) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            return;
        }
        ChunkLoading.loadChunkAsync(block.getLocation(), chunk -> {
            if (Bukkit.getPluginManager().isPluginEnabled("AdvancedChests") && AdvancedChestsAPI.getChestManager().getAdvancedChest(block.getLocation()) != null) {
                AdvancedChestsAPI.getChestManager().getAdvancedChest(block.getLocation()).openPage((HumanEntity)player, 1);
                Adapt.verbose("Opening AdvancedChests GUI");
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
            } else {
                BlockState blockState = block.getState();
                if (blockState instanceof InventoryHolder) {
                    InventoryHolder inventoryHolder = (InventoryHolder)blockState;
                    this.activeViews.add(player.openInventory(inventoryHolder.getInventory()));
                    player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                    player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                }
            }
        });
    }

    private boolean isBound(ItemStack itemStack) {
        return itemStack.getType().equals((Object)Material.ENDER_PEARL) && BoundEnderPearl.getBlock(itemStack) != null;
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        J.s(() -> {
            for (int i = this.activeViews.size() - 1; i >= 0; --i) {
                InventoryView inventoryView = this.activeViews.get(i);
                if (inventoryView.getPlayer().getOpenInventory().equals(inventoryView)) {
                    if (inventoryView.getTopInventory().getLocation() != null && this.isStorage(inventoryView.getTopInventory().getLocation().getBlock().getBlockData())) continue;
                    inventoryView.getPlayer().closeInventory();
                    inventoryView.getPlayer().removePotionEffect(PotionEffectType.BLINDNESS);
                    this.activeViews.remove(i);
                    continue;
                }
                inventoryView.getPlayer().removePotionEffect(PotionEffectType.BLINDNESS);
                this.activeViews.remove(i);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        double costFactor = 0.2;
        int initialCost = 15;

        static {
            IBootstrap.dasBoot();
        }
    }
}

