/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;

public class StealthGhostArmor
extends SimpleAdaptation<Config> {
    public StealthGhostArmor() {
        super("stealth-ghost-armor");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "ghostarmor", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "ghostarmor", "name"));
        this.setIcon(Material.NETHERITE_CHESTPLATE);
        this.setInterval(5353L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.f(this.getMaxArmorPoints(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("stealth", "ghostarmor", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.f(this.getMaxArmorPerTick(this.getLevelPercent(n)), 1) + C.GRAY + " " + Localizer.dLocalize("stealth", "ghostarmor", "lore2"));
    }

    public double getMaxArmorPoints(double d) {
        return M.lerp(((Config)this.getConfig()).minArmor, ((Config)this.getConfig()).maxArmor, d);
    }

    public double getMaxArmorPerTick(double d) {
        return M.lerp(((Config)this.getConfig()).minArmorPerTick, ((Config)this.getConfig()).maxArmorPerTick, d);
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Collection collection;
            if (!this.hasAdaptation(player)) {
                Collection collection2 = player.getAttribute(Attribute.GENERIC_ARMOR).getModifiers();
                for (AttributeModifier attributeModifier : new ArrayList(collection2)) {
                    if (!attributeModifier.getName().equals("adapt-ghost-armor")) continue;
                    player.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(attributeModifier);
                }
                continue;
            }
            double d = 0.0;
            double d2 = this.getMaxArmorPoints(this.getLevelPercent(player));
            double d3 = d2 = Double.isNaN(d2) ? 0.0 : d2;
            if (d < d2) {
                collection = player.getAttribute(Attribute.GENERIC_ARMOR).getModifiers();
                for (AttributeModifier attributeModifier : new ArrayList(collection)) {
                    if (!attributeModifier.getName().equals("adapt-ghost-armor")) continue;
                    d = attributeModifier.getAmount();
                    d = Double.isNaN(d) ? 0.0 : d;
                    player.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(attributeModifier);
                }
                player.getAttribute(Attribute.GENERIC_ARMOR).addModifier(new AttributeModifier("adapt-ghost-armor", Math.min(d2, d + this.getMaxArmorPerTick(this.getLevelPercent(player))), AttributeModifier.Operation.ADD_NUMBER));
                continue;
            }
            if (!(d > d2)) continue;
            collection = player.getAttribute(Attribute.GENERIC_ARMOR).getModifiers();
            for (AttributeModifier attributeModifier : new ArrayList(collection)) {
                if (!attributeModifier.getName().equals("adapt-ghost-armor")) continue;
                d = attributeModifier.getAmount();
                d = Double.isNaN(d) ? 0.0 : d;
                player.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(attributeModifier);
            }
            player.getAttribute(Attribute.GENERIC_ARMOR).addModifier(new AttributeModifier("adapt-ghost-armor", d2, AttributeModifier.Operation.ADD_NUMBER));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageEvent entityDamageEvent) {
        Player player;
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity) && !entityDamageEvent.isCancelled() && entityDamageEvent.getDamage() > 0.0) {
            this.xp(player, 2.5 * entityDamageEvent.getDamage());
            J.s(() -> {
                Collection collection = player.getAttribute(Attribute.GENERIC_ARMOR).getModifiers();
                for (AttributeModifier attributeModifier : new ArrayList(collection)) {
                    if (!attributeModifier.getName().equals("adapt-ghost-armor")) continue;
                    player.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(attributeModifier);
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxArmor = 16;
        int minArmor = 2;
        int maxArmorPerTick = 3;
        int minArmorPerTick = 1;
        int initialCost = 1;
        double costFactor = 0.335;
        int maxLevel = 7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

