/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Inventories;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StealthSnatch
extends SimpleAdaptation<Config> {
    private final List<Integer> holds;

    public StealthSnatch() {
        super("stealth-snatch");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "snatch", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "snatch", "name"));
        this.setIcon(Material.CHEST_MINECART);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInterval(((Config)this.getConfig()).snatchRate);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.holds = new ArrayList<Integer>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.f(this.getRange(this.getLevelPercent(n)), 1) + C.GRAY + " " + Localizer.dLocalize("stealth", "snatch", "lore1"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.isCancelled()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (!this.canAccessChest(player, player.getLocation())) {
            return;
        }
        if (playerToggleSneakEvent.isSneaking()) {
            this.snatch(player);
        }
    }

    private void snatch(Player player) {
        double d = this.getLevelPercent(player);
        if (d == 0.0) {
            return;
        }
        double d2 = this.getRange(d);
        HashSet<Item> hashSet = new HashSet<Item>();
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), d2, d2 / 1.5, d2)) {
            Item item;
            if (!(entity instanceof Item) || (item = (Item)entity).getPickupDelay() > 0 && item.getTicksLived() <= 1) continue;
            hashSet.add(item);
        }
        for (Item item : hashSet) {
            double d3;
            if (this.holds.contains(item.getEntityId()) || !((d3 = item.getLocation().distanceSquared(player.getLocation())) < d2 * d2)) continue;
            ItemStack itemStack = item.getItemStack().clone();
            if (!Inventories.hasSpace((Inventory)player.getInventory(), itemStack)) continue;
            this.holds.add(item.getEntityId());
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, (float)(1.0 + Math.random() / 3.0));
            this.safeGiveItem(player, (Entity)item, itemStack);
            this.sendCollected(player, item);
            int n = item.getEntityId();
            J.s(() -> this.holds.remove((Object)n));
        }
    }

    private double getRange(double d) {
        return d * ((Config)this.getConfig()).radiusFactor + 1.0;
    }

    public void sendCollected(Player player, Item item) {
        try {
            PacketPlayOutCollect packetPlayOutCollect = new PacketPlayOutCollect(item.getEntityId(), player.getEntityId(), item.getItemStack().getAmount());
            for (Entity entity2 : player.getWorld().getNearbyEntities(player.getLocation(), 8.0, 8.0, 8.0, entity -> entity instanceof Player)) {
                ((CraftPlayer)entity2).getHandle().b.a((Packet)packetPlayOutCollect);
            }
        }
        catch (Exception exception) {
            Adapt.error("Failed to send collected packet");
            exception.printStackTrace();
        }
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isSneaking()) continue;
            J.s(() -> this.snatch(player));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int snatchRate = 250;
        int baseCost = 4;
        int maxLevel = 3;
        int initialCost = 12;
        double costFactor = 0.125;
        double radiusFactor = 5.55;

        static {
            IBootstrap.dasBoot();
        }
    }
}

