/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class StealthSpeed
extends SimpleAdaptation<Config> {
    public StealthSpeed() {
        super("stealth-speed");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "speed", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "speed", "name"));
        this.setIcon(Material.MUSHROOM_STEW);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInterval(2000L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getSpeed(this.getLevelPercent(n)), 0) + C.GRAY + Localizer.dLocalize("stealth", "speed", "lore1"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.isCancelled()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        double d = this.getLevelPercent(player);
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        AttributeModifier attributeModifier = new AttributeModifier("adapt-sneak-speed", this.getSpeed(d), AttributeModifier.Operation.MULTIPLY_SCALAR_1);
        if (playerToggleSneakEvent.isSneaking()) {
            player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).addModifier(attributeModifier);
        } else {
            for (AttributeModifier attributeModifier2 : player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getModifiers()) {
                if (!attributeModifier2.getName().equals("adapt-sneak-speed")) continue;
                player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).removeModifier(attributeModifier2);
            }
        }
    }

    private double getSpeed(double d) {
        return d * ((Config)this.getConfig()).factor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 5;
        double costFactor = 0.6;
        double factor = 1.25;

        static {
            IBootstrap.dasBoot();
        }
    }
}

