/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class TragoulLance
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public TragoulLance() {
        super("tragoul-lance");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "lance", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "lance", "name"));
        this.setIcon(Material.TRIDENT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        EntityDamageByEntityEvent entityDamageByEntityEvent;
        Entity entity;
        EntityDamageEvent entityDamageEvent = entityDeathEvent.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent && (entity = (entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent).getDamager()) instanceof Player && this.hasAdaptation((Player)(entityDamageEvent = (Player)entity))) {
            if (this.cooldowns.containsKey(entityDamageEvent)) {
                if (this.cooldowns.get(entityDamageEvent) + 5000L > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(entityDamageEvent);
            }
            this.cooldowns.put((Player)entityDamageEvent, System.currentTimeMillis());
            int n = this.getLevel((Player)entityDamageEvent);
            double d = 5 + 4 * n;
            double d2 = entityDamageByEntityEvent.getDamage();
            double d3 = ((Config)this.getConfig()).seekerDamageMultiplier * d2;
            this.triggerSeeker((Player)entityDamageEvent, (Entity)entityDeathEvent.getEntity(), d3, n, d);
        }
    }

    private void triggerSeeker(Player player, Entity entity, double d, int n, double d2) {
        if (n <= 0) {
            return;
        }
        LivingEntity livingEntity = null;
        double d3 = d2;
        for (Entity entity2 : entity.getNearbyEntities(d2, d2, d2)) {
            double d4;
            LivingEntity livingEntity2;
            if (!(entity2 instanceof LivingEntity) || (livingEntity2 = (LivingEntity)entity2) == player || !((d4 = entity.getLocation().distance(livingEntity2.getLocation())) < d3)) continue;
            livingEntity = livingEntity2;
            d3 = d4;
        }
        if (livingEntity != null) {
            this.vfxMovingSphere(entity.getLocation(), livingEntity.getLocation(), ((Config)this.getConfig()).seekerDelay, Color.MAROON, 0.25, 4.0);
            double d5 = ((Config)this.getConfig()).seekerDamageMultiplier * d;
            double d6 = ((Config)this.getConfig()).selfDamageMultiplier * d5;
            Adapt.verbose("Seeker damage: " + d5 + " Self damage: " + d6);
            player.damage(d6, (Entity)player);
            LivingEntity livingEntity3 = livingEntity;
            Bukkit.getScheduler().runTaskLater((Plugin)Adapt.instance, () -> {
                double d3 = livingEntity3.getHealth() - d;
                livingEntity3.damage(d, (Entity)player);
                if (d3 <= 0.0) {
                    this.triggerSeeker(player, (Entity)livingEntity3, d * 0.5, n - 1, d2);
                }
            }, (long)((Config)this.getConfig()).seekerDelay);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("tragoul", "lance", "lore1"));
        element.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "lance", "lore2"));
        element.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "lance", "lore3") + n);
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        int seekerDelay = 20;
        double costFactor = 1.1;
        double seekerDamageMultiplier = 0.5;
        double selfDamageMultiplier = 0.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

