/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class TragoulThorns
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public TragoulThorns() {
        super("tragoul-thorns");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "thorns", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "thorns", "name"));
        this.setIcon(Material.ECHO_SHARD);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + ((Config)this.getConfig()).damageMultiplierPerLevel * (double)n + "x " + Localizer.dLocalize("tragoul", "thorns", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity)) {
            Projectile projectile;
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player) + 1500L > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            this.cooldowns.put(player, System.currentTimeMillis());
            entity = null;
            if (entityDamageByEntityEvent.getDamager() instanceof LivingEntity) {
                entity = (LivingEntity)entityDamageByEntityEvent.getDamager();
            } else {
                Entity entity2 = entityDamageByEntityEvent.getDamager();
                if (entity2 instanceof Projectile && (projectile = (Projectile)entity2).getShooter() instanceof LivingEntity) {
                    entity = (LivingEntity)projectile.getShooter();
                }
            }
            if (entity != null) {
                if (((Config)this.getConfig()).showParticles) {
                    projectile = new BleedEffect(Adapt.instance.adaptEffectManager);
                    projectile.setEntity(entity);
                    projectile.height = -1.0;
                    projectile.iterations = 1;
                    projectile.start();
                }
                entity.damage(((Config)this.getConfig()).damageMultiplierPerLevel * (double)this.getLevel(player), (Entity)player);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        double damageMultiplierPerLevel = 1.0;
        double costFactor = 1.1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

