/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.unarmed;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class UnarmedGlassCannon
extends SimpleAdaptation<Config> {
    public UnarmedGlassCannon() {
        super("unarmed-glass-cannon");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("unarmed", "glasscannon", "description"));
        this.setDisplayName(Localizer.dLocalize("unarmed", "glasscannon", "name"));
        this.setIcon(Material.DISC_FRAGMENT_5);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(4544L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + (((Config)this.getConfig()).maxDamageFactor + (double)n * ((Config)this.getConfig()).maxDamagePerLevelMultiplier) + C.GRAY + " " + Localizer.dLocalize("unarmed", "glasscannon", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.f((double)n * ((Config)this.getConfig()).perLevelBonusMultiplier) + C.GRAY + " " + Localizer.dLocalize("unarmed", "glasscannon", "lore2"));
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.hasAdaptation(player)) {
                return;
            }
            if (this.isTool(player.getInventory().getItemInMainHand()) && this.isTool(player.getInventory().getItemInOffHand())) {
                return;
            }
            double d = this.getArmorValue(player);
            double d2 = entityDamageByEntityEvent.getDamage();
            if (d == 0.0) {
                entityDamageByEntityEvent.setDamage(d2 * ((Config)this.getConfig()).maxDamageFactor);
            } else {
                entityDamageByEntityEvent.setDamage(d2 - d2 * d);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 7;
        int initialCost = 6;
        double costFactor = 0.425;
        double perLevelBonusMultiplier = 0.25;
        double maxDamageFactor = 4.0;
        double maxDamagePerLevelMultiplier = 0.15;

        static {
            IBootstrap.dasBoot();
        }
    }
}

