/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.gui;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.UIElement;
import com.volmit.adapt.util.UIWindow;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SkillsGui {
    public static void open(Player player) {
        UIWindow uIWindow = new UIWindow(player);
        uIWindow.setTag("/");
        uIWindow.setDecorator((window, n, n2) -> new UIElement("bg").setName(" ").setMaterial(new MaterialBlock(Material.BLACK_STAINED_GLASS_PANE)));
        AdaptPlayer adaptPlayer = Adapt.instance.getAdaptServer().getPlayer(player);
        int n3 = 0;
        if (adaptPlayer.getData().getSkillLines().size() > 0) {
            for (PlayerSkillLine playerSkillLine : XMap.sortV(adaptPlayer.getData().getSkillLines())) {
                if (playerSkillLine.getRawSkill(adaptPlayer).hasBlacklistPermission(adaptPlayer.getPlayer(), playerSkillLine.getRawSkill(adaptPlayer)) || playerSkillLine.getLevel() < 0) continue;
                int n4 = uIWindow.getPosition(n3);
                int n5 = uIWindow.getRow(n3);
                int n6 = 0;
                for (PlayerAdaptation playerAdaptation : XMap.sortV(playerSkillLine.getAdaptations())) {
                    n6 = playerAdaptation.getLevel();
                }
                Skill<?> skill = Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(playerSkillLine.getLine());
                uIWindow.setElement(n4, n5, new UIElement("skill-" + skill.getName()).setMaterial(new MaterialBlock(skill.getIcon())).setName(skill.getDisplayName(playerSkillLine.getLevel())).setProgress(1.0).addLore(C.ITALIC + C.GRAY + skill.getDescription()).addLore(C.UNDERLINE + C.WHITE + playerSkillLine.getKnowledge() + C.RESET + " " + C.GRAY + Localizer.dLocalize("snippets", "gui", "knowledge")).addLore(C.ITALIC + C.GRAY + Localizer.dLocalize("snippets", "gui", "powerused") + " " + C.DARK_GREEN + n6).onLeftClick(element -> skill.openGui(player)));
                ++n3;
            }
            if (AdaptConfig.get().isUnlearnAllButton()) {
                int n7;
                int n8 = uIWindow.getResolution().getWidth() - 1;
                if (uIWindow.getElement(n8, n7 = uIWindow.getViewportHeight() - 1) != null) {
                    ++n7;
                }
                uIWindow.setElement(n8, n7, new UIElement("unlearn-all").setMaterial(new MaterialBlock(Material.BARRIER)).setName(C.RESET + C.GRAY + Localizer.dLocalize("snippets", "gui", "unlearnall") + (String)(AdaptConfig.get().isHardcoreNoRefunds() ? " " + C.DARK_RED + C.BOLD + Localizer.dLocalize("snippets", "adaptmenu", "norefunds") : "")).onLeftClick(element -> {
                    Adapt.instance.getAdaptServer().getSkillRegistry().getSkills().forEach(skill -> skill.getAdaptations().forEach(adaptation -> adaptation.unlearn(player, 1)));
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_NETHER_GOLD_ORE_PLACE, 0.7f, 1.355f);
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.4f, 0.755f);
                    uIWindow.close();
                    if (AdaptConfig.get().getLearnUnlearnButtonDelayTicks() != 0) {
                        player.sendTitle(" ", C.GRAY + Localizer.dLocalize("snippets", "gui", "unlearnedall"), 1, 5, 11);
                    }
                    J.s(() -> SkillsGui.open(player), AdaptConfig.get().getLearnUnlearnButtonDelayTicks());
                }));
            }
            uIWindow.setTitle(Localizer.dLocalize("snippets", "gui", "level") + " " + (int)XP.getLevelForXp(adaptPlayer.getData().getMasterXp()) + " (" + adaptPlayer.getData().getUsedPower() + "/" + adaptPlayer.getData().getMaxPower() + " " + Localizer.dLocalize("snippets", "gui", "powerused") + ")");
            uIWindow.open();
            uIWindow.onClosed(window -> Adapt.instance.getGuiLeftovers().remove(player.getUniqueId().toString()));
            Adapt.instance.getGuiLeftovers().put(player.getUniqueId().toString(), uIWindow);
        }
    }

    static {
        IBootstrap.dasBoot();
    }
}

