/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.BoardEntry;
import com.volmit.adapt.util.BoardSettings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.ScoreDirection;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Board {
    private static final String[] CACHED_ENTRIES;
    private static final Function<String, String> APPLY_COLOR_TRANSLATION;
    private final Player player;
    private final Objective objective;
    private final Team team;
    private BoardSettings boardSettings;
    private boolean ready;

    public Board(@NonNull Player player, BoardSettings boardSettings) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
        this.boardSettings = boardSettings;
        this.objective = this.getScoreboard().getObjective("board") == null ? this.getScoreboard().registerNewObjective("board", "dummy") : this.getScoreboard().getObjective("board");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.team = this.getScoreboard().getTeam("board") == null ? this.getScoreboard().registerNewTeam("board") : this.getScoreboard().getTeam("board");
        this.team.setAllowFriendlyFire(true);
        this.team.setCanSeeFriendlyInvisibles(false);
        this.team.setPrefix("");
        this.team.setSuffix("");
        this.ready = true;
    }

    public Scoreboard getScoreboard() {
        return this.player != null ? this.player.getScoreboard() : null;
    }

    public void remove() {
        this.resetScoreboard();
    }

    public void update() {
        String string;
        if (!this.ready) {
            return;
        }
        if (!this.player.isOnline()) {
            this.remove();
            return;
        }
        if (this.boardSettings == null) {
            return;
        }
        List list = this.boardSettings.getBoardProvider().getLines(this.player).stream().map(APPLY_COLOR_TRANSLATION).collect(Collectors.toList());
        if (this.boardSettings.getScoreDirection() == ScoreDirection.UP) {
            Collections.reverse(list);
        }
        if ((string = this.boardSettings.getBoardProvider().getTitle(this.player)).length() > 32) {
            Bukkit.getLogger().warning("The title " + string + " is over 32 characters in length, substringing to prevent errors.");
            string = string.substring(0, 32);
        }
        this.objective.setDisplayName(C.translateAlternateColorCodes('&', string));
        if (this.getScoreboard().getEntries().size() != list.size()) {
            this.getScoreboard().getEntries().forEach(this::removeEntry);
        }
        block4: for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            BoardEntry boardEntry = BoardEntry.translateToEntry(string2);
            Team team = this.getScoreboard().getTeam(CACHED_ENTRIES[i]);
            if (team == null) {
                team = this.getScoreboard().registerNewTeam(CACHED_ENTRIES[i]);
                team.addEntry(team.getName());
            }
            team.setPrefix(boardEntry.getPrefix());
            team.setSuffix(boardEntry.getSuffix());
            switch (this.boardSettings.getScoreDirection()) {
                case UP: {
                    this.objective.getScore(team.getName()).setScore(1 + i);
                    continue block4;
                }
                case DOWN: {
                    this.objective.getScore(team.getName()).setScore(15 - i);
                }
            }
        }
    }

    public void removeEntry(String string) {
        this.getScoreboard().resetScores(string);
    }

    public void resetScoreboard() {
        this.ready = false;
        this.player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public void setBoardSettings(BoardSettings boardSettings) {
        this.boardSettings = boardSettings;
    }

    static {
        IBootstrap.dasBoot();
        CACHED_ENTRIES = new String[C.values().length];
        APPLY_COLOR_TRANSLATION = string -> C.translateAlternateColorCodes('&', string);
        IntStream.range(0, 15).forEach(n -> {
            Board.CACHED_ENTRIES[n] = C.values()[n].toString() + C.RESET;
        });
    }
}

