/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class BurstExecutor {
    private final ExecutorService executor;
    private final List<CompletableFuture<Void>> futures;

    public BurstExecutor(ExecutorService executorService, int n) {
        this.executor = executorService;
        this.futures = new ArrayList<CompletableFuture<Void>>(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> queue(Runnable runnable) {
        List<CompletableFuture<Void>> list = this.futures;
        synchronized (list) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable, this.executor);
            this.futures.add(completableFuture);
            return completableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BurstExecutor queue(Runnable[] runnableArray) {
        List<CompletableFuture<Void>> list = this.futures;
        synchronized (list) {
            for (Runnable runnable : runnableArray) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable, this.executor);
                this.futures.add(completableFuture);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        List<CompletableFuture<Void>> list = this.futures;
        synchronized (list) {
            try {
                CompletableFuture.allOf(this.futures.toArray(new CompletableFuture[this.futures.size()])).get();
                this.futures.clear();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        IBootstrap.dasBoot();
    }
}

