/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.ByteArrayTag;
import com.volmit.adapt.util.ByteTag;
import com.volmit.adapt.util.CompoundTag;
import com.volmit.adapt.util.DoubleTag;
import com.volmit.adapt.util.EndTag;
import com.volmit.adapt.util.FloatTag;
import com.volmit.adapt.util.IntArrayTag;
import com.volmit.adapt.util.IntTag;
import com.volmit.adapt.util.ListTag;
import com.volmit.adapt.util.LongTag;
import com.volmit.adapt.util.NBTConstants;
import com.volmit.adapt.util.NBTUtils;
import com.volmit.adapt.util.ShortTag;
import com.volmit.adapt.util.StringTag;
import com.volmit.adapt.util.Tag;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;

    public NBTInputStream(DataInputStream dataInputStream) {
        this.is = dataInputStream;
    }

    public NBTInputStream(InputStream inputStream) {
        this.is = new DataInputStream(new GZIPInputStream(inputStream));
    }

    public Tag readTag() {
        return this.readTag(0);
    }

    private Tag readTag(int n) {
        String string;
        int n2 = this.is.readByte() & 0xFF;
        if (n2 != 0) {
            int n3 = this.is.readShort() & 0xFFFF;
            byte[] byArray = new byte[n3];
            this.is.readFully(byArray);
            string = new String(byArray, NBTConstants.CHARSET);
        } else {
            string = "";
        }
        return this.readTagPayload(n2, string, n);
    }

    private Tag readTagPayload(int n, String string, int n2) {
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case 1: {
                return new ByteTag(string, this.is.readByte());
            }
            case 2: {
                return new ShortTag(string, this.is.readShort());
            }
            case 3: {
                return new IntTag(string, this.is.readInt());
            }
            case 4: {
                return new LongTag(string, this.is.readLong());
            }
            case 5: {
                return new FloatTag(string, this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(string, this.is.readDouble());
            }
            case 7: {
                int n3 = this.is.readInt();
                byte[] byArray = new byte[n3];
                this.is.readFully(byArray);
                return new ByteArrayTag(string, byArray);
            }
            case 8: {
                short s = this.is.readShort();
                byte[] byArray = new byte[s];
                this.is.readFully(byArray);
                return new StringTag(string, new String(byArray, NBTConstants.CHARSET));
            }
            case 9: {
                byte by = this.is.readByte();
                int n4 = this.is.readInt();
                ArrayList<Tag> arrayList = new ArrayList<Tag>();
                for (int i = 0; i < n4; ++i) {
                    Tag tag = this.readTagPayload(by, "", n2 + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    arrayList.add(tag);
                }
                return new ListTag(string, NBTUtils.getTypeClass(by), arrayList);
            }
            case 10: {
                Tag tag;
                HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
                while (!((tag = this.readTag(n2 + 1)) instanceof EndTag)) {
                    hashMap.put(tag.getName(), tag);
                }
                return new CompoundTag(string, hashMap);
            }
            case 11: {
                int n5 = this.is.readInt();
                int[] nArray = new int[n5];
                for (int i = 0; i < n5; ++i) {
                    nArray[i] = this.is.readInt();
                }
                return new IntArrayTag(string, nArray);
            }
        }
        throw new IOException("Invalid tag type: " + n + ".");
    }

    @Override
    public void close() {
        this.is.close();
    }

    static {
        IBootstrap.dasBoot();
    }
}

