/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementReward;
import com.volmit.adapt.util.advancements.advancement.ToastNotification;
import com.volmit.adapt.util.advancements.advancement.criteria.Criteria;
import com.volmit.adapt.util.advancements.advancement.progress.AdvancementProgress;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Advancement {
    private final NameKey name;
    private final AdvancementDisplay display;
    private final Advancement parent;
    private final boolean childrenTracked;
    private final List<AdvancementFlag> flags;
    private final HashSet<Advancement> children = new HashSet();
    private final HashMap<String, AdvancementProgress> progressMap = new HashMap();
    private Criteria criteria = new Criteria(1);
    private AdvancementReward reward;
    private HashMap<String, Boolean> savedVisibilityStatus;

    public Advancement(@Nullable Advancement advancement, NameKey nameKey, AdvancementDisplay advancementDisplay, AdvancementFlag ... advancementFlagArray) {
        this.parent = advancement;
        this.childrenTracked = true;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = nameKey;
        this.display = advancementDisplay;
        this.flags = Arrays.asList(advancementFlagArray);
    }

    public Advancement(@Nullable Advancement advancement, NameKey nameKey, AdvancementDisplay advancementDisplay, boolean bl, AdvancementFlag ... advancementFlagArray) {
        this.parent = null;
        this.childrenTracked = bl;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = nameKey;
        this.display = advancementDisplay;
        this.flags = Arrays.asList(advancementFlagArray);
    }

    public Advancement(NameKey nameKey, AdvancementDisplay advancementDisplay, AdvancementFlag ... advancementFlagArray) {
        this.parent = null;
        this.childrenTracked = true;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = nameKey;
        this.display = advancementDisplay;
        this.flags = Arrays.asList(advancementFlagArray);
    }

    public Advancement(NameKey nameKey, AdvancementDisplay advancementDisplay, boolean bl, AdvancementFlag ... advancementFlagArray) {
        this.parent = null;
        this.childrenTracked = bl;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = nameKey;
        this.display = advancementDisplay;
        this.flags = Arrays.asList(advancementFlagArray);
    }

    public NameKey getName() {
        return this.name;
    }

    public boolean hasName(NameKey nameKey) {
        return nameKey.getNamespace().equalsIgnoreCase(this.name.getNamespace()) && nameKey.getKey().equalsIgnoreCase(this.name.getKey());
    }

    public AdvancementDisplay getDisplay() {
        return this.display;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
        this.progressMap.clear();
    }

    public AdvancementReward getReward() {
        return this.reward;
    }

    public void setReward(AdvancementReward advancementReward) {
        this.reward = advancementReward;
    }

    public Advancement getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    private void addChild(Advancement advancement) {
        if (advancement.getParent() == this && this.childrenTracked) {
            this.children.add(advancement);
        }
    }

    public HashSet<Advancement> getChildren() {
        return new HashSet<Advancement>(this.children);
    }

    public Advancement getRootAdvancement() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootAdvancement();
    }

    public NameKey getTab() {
        return this.getRootAdvancement().getName();
    }

    public List<Advancement> getRow() {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        arrayList.add(this);
        if (this.getParent() != null) {
            for (Advancement advancement : this.getParent().getRowUntil()) {
                if (arrayList.contains(advancement)) continue;
                arrayList.add(advancement);
            }
            Collections.reverse(arrayList);
        }
        for (Advancement advancement : this.getChildren()) {
            for (Advancement advancement2 : advancement.getRowAfter()) {
                if (arrayList.contains(advancement2)) continue;
                arrayList.add(advancement2);
            }
        }
        return arrayList;
    }

    public List<Advancement> getRowUntil() {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        arrayList.add(this);
        if (this.getParent() != null) {
            for (Advancement advancement : this.getParent().getRowUntil()) {
                if (arrayList.contains(advancement)) continue;
                arrayList.add(advancement);
            }
        }
        return arrayList;
    }

    public List<Advancement> getRowAfter() {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        arrayList.add(this);
        for (Advancement advancement : this.getChildren()) {
            for (Advancement advancement2 : advancement.getRowAfter()) {
                if (arrayList.contains(advancement2)) continue;
                arrayList.add(advancement2);
            }
        }
        return arrayList;
    }

    public boolean isAnythingGrantedUntil(Player player) {
        for (Advancement advancement : this.getRowUntil()) {
            if (!advancement.isGranted(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnythingGrantedAfter(Player player) {
        for (Advancement advancement : this.getRowAfter()) {
            if (!advancement.isGranted(player)) continue;
            return true;
        }
        return false;
    }

    public AdvancementProgress getProgress(Player player) {
        return this.getProgress(player.getUniqueId());
    }

    public AdvancementProgress getProgress(UUID uUID) {
        if (uUID == null) {
            Adapt.error("AdvancementProgress.getProgress(UUID) was called with a null UUID!");
            return null;
        }
        if (!this.progressMap.containsKey(uUID.toString())) {
            this.progressMap.put(uUID.toString(), new AdvancementProgress(this.getCriteria().getCriteria(), this.getCriteria().getRequirements()));
        }
        return this.progressMap.get(uUID.toString());
    }

    public void unloadProgress(Player player) {
        this.unloadProgress(player.getUniqueId());
    }

    public void unloadProgress(UUID uUID) {
        this.progressMap.remove(uUID.toString());
    }

    public boolean isGranted(Player player) {
        return this.getProgress(player).isDone();
    }

    public boolean isGranted(UUID uUID) {
        return this.getProgress(uUID).isDone();
    }

    public List<AdvancementFlag> getFlags() {
        return new ArrayList<AdvancementFlag>(this.flags);
    }

    public boolean hasFlag(AdvancementFlag advancementFlag) {
        return this.flags.contains((Object)advancementFlag);
    }

    public void saveVisibilityStatus(Player player, boolean bl) {
        if (this.savedVisibilityStatus == null) {
            this.savedVisibilityStatus = new HashMap();
        }
        this.savedVisibilityStatus.put(player.getUniqueId().toString(), bl);
    }

    public boolean getVisibilityStatus(Player player) {
        if (this.savedVisibilityStatus == null) {
            this.savedVisibilityStatus = new HashMap();
        }
        if (!this.savedVisibilityStatus.containsKey(player.getUniqueId().toString())) {
            this.savedVisibilityStatus.put(player.getUniqueId().toString(), this.getDisplay().isVisible(player, this));
        }
        return this.savedVisibilityStatus.get(player.getUniqueId().toString());
    }

    public void unloadVisibilityStatus(Player player) {
        if (this.savedVisibilityStatus == null) {
            return;
        }
        this.savedVisibilityStatus.remove(player.getUniqueId().toString());
    }

    public void unloadVisibilityStatus(UUID uUID) {
        this.savedVisibilityStatus.remove(uUID.toString());
    }

    public ToastNotification getToastNotification() {
        ToastNotification toastNotification = new ToastNotification(this.getDisplay().getIcon(), this.getDisplay().getTitle(), this.getDisplay().getFrame());
        return toastNotification;
    }

    public void displayToast(Player player) {
        ToastNotification toastNotification = this.getToastNotification();
        toastNotification.send(player);
    }

    public BaseComponent getMessage(Player player) {
        String string = "chat.type.advancement." + this.display.getFrame().name().toLowerCase();
        boolean bl = this.getDisplay().getFrame() == AdvancementDisplay.AdvancementFrame.CHALLENGE;
        TranslatableComponent translatableComponent = new TranslatableComponent();
        translatableComponent.setTranslate(string);
        TextComponent textComponent = new TextComponent(player.getDisplayName());
        TextComponent textComponent2 = new TextComponent("[");
        textComponent2.addExtra(this.display.getTitle().getJson());
        textComponent2.addExtra("]");
        textComponent2.setColor(bl ? ChatColor.DARK_PURPLE : ChatColor.GREEN);
        TextComponent textComponent3 = new TextComponent(new BaseComponent[]{this.display.getTitle().getJson()});
        textComponent3.setColor(textComponent2.getColor());
        Text text = new Text(new BaseComponent[]{textComponent3});
        Text text2 = new Text(new BaseComponent[]{this.display.getDescription().getJson()});
        textComponent2.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{text, new Text("\n"), text2}));
        translatableComponent.setWith(Arrays.asList(textComponent, textComponent2));
        return translatableComponent;
    }

    public void displayMessageToEverybody(Player player) {
        BaseComponent baseComponent = this.getMessage(player);
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            player2.spigot().sendMessage(ChatMessageType.CHAT, baseComponent);
        }
    }

    public boolean equals(Object object) {
        return this.getName().equals(((Advancement)object).getName());
    }

    static {
        IBootstrap.dasBoot();
    }
}

