/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.packet;

import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.packet.PacketConverter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class AdvancementsPacket {
    private final Player player;
    private final boolean reset;
    private final List<Advancement> advancements;
    private final List<NameKey> removedAdvancements;

    public AdvancementsPacket(Player player, boolean bl, List<Advancement> list, List<NameKey> list2) {
        this.player = player;
        this.reset = bl;
        this.advancements = list == null ? new ArrayList<Advancement>() : new ArrayList<Advancement>(list);
        this.removedAdvancements = list2 == null ? new ArrayList<NameKey>() : new ArrayList<NameKey>(list2);
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isReset() {
        return this.reset;
    }

    public List<Advancement> getAdvancements() {
        return new ArrayList<Advancement>(this.advancements);
    }

    public List<NameKey> getRemovedAdvancements() {
        return new ArrayList<NameKey>(this.removedAdvancements);
    }

    public PacketPlayOutAdvancements build() {
        ArrayList<net.minecraft.advancements.Advancement> arrayList = new ArrayList<net.minecraft.advancements.Advancement>();
        HashSet<MinecraftKey> hashSet = new HashSet<MinecraftKey>();
        HashMap<MinecraftKey, AdvancementProgress> hashMap = new HashMap<MinecraftKey, AdvancementProgress>();
        for (Advancement object : this.advancements) {
            net.minecraft.advancements.Advancement advancement = this.convertAdvancement(object);
            arrayList.add(advancement);
            hashMap.put(object.getName().getMinecraftKey(), object.getProgress(this.getPlayer()).getNmsProgress());
        }
        for (NameKey nameKey : this.removedAdvancements) {
            hashSet.add(nameKey.getMinecraftKey());
        }
        Iterator<Object> iterator = new PacketPlayOutAdvancements(this.isReset(), arrayList, hashSet, hashMap);
        return iterator;
    }

    protected net.minecraft.advancements.Advancement convertAdvancement(Advancement advancement) {
        return PacketConverter.toNmsAdvancement(advancement);
    }

    public void send() {
        PacketPlayOutAdvancements packetPlayOutAdvancements = this.build();
        ((CraftPlayer)this.getPlayer()).getHandle().b.a((Packet)packetPlayOutAdvancements);
    }

    static {
        IBootstrap.dasBoot();
    }
}

