/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BigIntegerRange
extends NumberRange<BigInteger, BigIntegerRange> {
    public BigIntegerRange(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, BigInteger.ONE, true, true, false);
    }

    public BigIntegerRange unaryMinus() {
        BigInteger bigInteger = (BigInteger)this.getLeftEndpoint();
        BigInteger bigInteger2 = (BigInteger)this.getRightEndpoint();
        if (this.isReversed()) {
            return new BigIntegerRange(bigInteger, bigInteger2, (BigInteger)this.getStep(), true, true, false);
        }
        return new BigIntegerRange(bigInteger2, bigInteger, (BigInteger)this.getStep(), true, true, true);
    }

    public BigIntegerRange(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, boolean bl, boolean bl2, boolean bl3) {
        super(bigInteger, bigInteger2, bigInteger3, bl, bl2, bl3);
        if (bigInteger3.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + bigInteger3);
        }
    }

    @Override
    public Iterator<BigInteger> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<BigInteger> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public BigInteger getFromLeft(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isLeftClosed()) {
            ++n;
        }
        BigInteger bigInteger = ((BigInteger)this.getLeftEndpoint()).add(((BigInteger)this.getStep()).multiply(BigInteger.valueOf(n)));
        int n2 = bigInteger.compareTo((BigInteger)this.getRightEndpoint());
        if (this.isRightClosed() ? n2 <= 0 : n2 < 0) {
            return bigInteger;
        }
        return null;
    }

    @Override
    public BigInteger getFromRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isRightClosed()) {
            ++n;
        }
        BigInteger bigInteger = ((BigInteger)this.getRightEndpoint()).subtract(((BigInteger)this.getStep()).multiply(BigInteger.valueOf(n)));
        int n2 = bigInteger.compareTo((BigInteger)this.getLeftEndpoint());
        if (this.isLeftClosed() ? n2 >= 0 : n2 > 0) {
            return bigInteger;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    private class ForwardIterator
    implements Iterator<BigInteger> {
        private BigInteger _csr;

        public ForwardIterator() {
            this._csr = (BigInteger)BigIntegerRange.this.getLeftEndpoint();
            if (!BigIntegerRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int n = this._csr.compareTo((BigInteger)BigIntegerRange.this.getRightEndpoint());
            return n < 0 || BigIntegerRange.this.isRightClosed() && n == 0;
        }

        @Override
        public BigInteger next() {
            int n = this._csr.compareTo((BigInteger)BigIntegerRange.this.getRightEndpoint());
            if (n > 0 || !BigIntegerRange.this.isRightClosed() && n == 0) {
                throw new NoSuchElementException();
            }
            BigInteger bigInteger = this._csr;
            this._csr = this._csr.add((BigInteger)BigIntegerRange.this.getStep());
            return bigInteger;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    implements Iterator<BigInteger> {
        private BigInteger _csr;

        public ReverseIterator() {
            this._csr = (BigInteger)BigIntegerRange.this.getRightEndpoint();
            if (!BigIntegerRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int n = this._csr.compareTo((BigInteger)BigIntegerRange.this.getLeftEndpoint());
            return n > 0 || BigIntegerRange.this.isLeftClosed() && n == 0;
        }

        @Override
        public BigInteger next() {
            int n = this._csr.compareTo((BigInteger)BigIntegerRange.this.getLeftEndpoint());
            if (n < 0 || !BigIntegerRange.this.isLeftClosed() && n == 0) {
                throw new NoSuchElementException();
            }
            BigInteger bigInteger = this._csr;
            this._csr = this._csr.subtract((BigInteger)BigIntegerRange.this.getStep());
            return bigInteger;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

