/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util;

import com.volmit.adapt.util.arcane.curse.Curse;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarLoader {
    private final Map<String, Supplier<Class<?>>> classCache = new HashMap();

    public static JarLoader from(Class<?> clazz) {
        return new JarLoader(clazz);
    }

    public static void allFiles(File file, Consumer<File> consumer) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                JarLoader.allFiles(file2, consumer);
            }
        } else {
            consumer.accept(file);
        }
    }

    public JarLoader(File ... fileArray) {
        this(Curse.class.getClassLoader(), fileArray);
    }

    public JarLoader(ClassLoader classLoader, File ... fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(List.of(fileArray));
        for (File file : arrayList) {
            if (file.isDirectory()) {
                JarLoader.allFiles(file, file2 -> {
                    String string = Paths.get(file.getPath(), new String[0]).relativize(Paths.get(file2.getPath(), new String[0])).toString();
                    String string2 = string.replace(".class", "").replaceAll("\\Q/\\E", ".").replaceAll("\\Q" + File.separator + "\\E", ".");
                    this.classCache.put(string2, () -> {
                        try {
                            return Class.forName(string2, true, classLoader);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    });
                });
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(".class") && !zipEntry.getName().contains("$")) {
                    String string = zipEntry.getName().replaceAll("\\Q/\\E", ".").replaceAll("\\Q" + File.separator + "\\E", ".").replace(".class", "");
                    this.classCache.put(string, () -> {
                        try {
                            return Class.forName(string, true, classLoader);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    });
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
    }

    private void attemptTimeout(Supplier<Class<?>> supplier, long l) {
    }

    public JarLoader(Class<?> ... classArray) {
        this((File[])Arrays.stream(classArray).map(clazz -> new File(clazz.getProtectionDomain().getCodeSource().getLocation().getFile())).toArray(File[]::new));
    }

    public Stream<Class<?>> all() {
        return this.classCache.keySet().parallelStream().map(string -> this.classCache.get(string).get()).filter(Objects::nonNull).map(clazz -> clazz);
    }

    public Stream<Class<?>> all(Class<?> clazz) {
        return this.all().filter(clazz2 -> clazz2.isAssignableFrom(clazz) || clazz.isAssignableFrom((Class<?>)clazz2)).filter(clazz2 -> !clazz2.equals(clazz));
    }

    public Stream<Class<?>> inPackageNested(String string3, Class<?> clazz3) {
        return this.classCache.keySet().parallelStream().filter(string2 -> string2.startsWith(string3)).map(string -> this.classCache.get(string).get()).filter(Objects::nonNull).map(clazz -> clazz).filter(clazz2 -> !clazz2.equals(clazz3)).filter(clazz3::isAssignableFrom).map(clazz -> clazz);
    }

    public Stream<Class<?>> inPackageSpecifically(String string3, Class<?> clazz3) {
        return this.classCache.keySet().parallelStream().filter(string2 -> string2.startsWith(string3) && this.removeLast(this.splitAbs((String)string2, ".")).equals(this.splitAbs(string3, "."))).map(string -> this.classCache.get(string).get()).filter(Objects::nonNull).map(clazz -> clazz).filter(clazz2 -> !clazz2.equals(clazz3)).filter(clazz3::isAssignableFrom).map(clazz -> clazz);
    }

    public Stream<Class<?>> inPackageNested(String string3) {
        return this.classCache.keySet().parallelStream().filter(string2 -> string2.startsWith(string3)).map(string -> this.classCache.get(string).get()).filter(Objects::nonNull).map(clazz -> clazz);
    }

    public Stream<Class<?>> inPackageSpecifically(String string3) {
        return this.classCache.keySet().parallelStream().filter(string2 -> string2.startsWith(string3) && this.removeLast(this.splitAbs((String)string2, ".")).equals(this.splitAbs(string3, "."))).map(string -> this.classCache.get(string).get()).filter(Objects::nonNull).map(clazz -> clazz);
    }

    private List<String> splitAbs(String string, String string2) {
        return Arrays.asList(string.split("\\Q" + string2 + "\\E"));
    }

    private List<String> removeLast(List<String> list) {
        list.remove(list.size() - 1);
        return list;
    }
}

