/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeBlock;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class JavaFile {
    private static final Appendable NULL_APPENDABLE = new Appendable(){

        @Override
        public Appendable append(CharSequence charSequence) {
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) {
            return this;
        }

        @Override
        public Appendable append(char c) {
            return this;
        }
    };
    public final CodeBlock fileComment;
    public final String packageName;
    public final TypeSpec typeSpec;
    public final boolean skipJavaLangImports;
    private final Set<String> staticImports;
    private final Set<String> alwaysQualify;
    private final String indent;

    private JavaFile(Builder builder) {
        this.fileComment = builder.fileComment.build();
        this.packageName = builder.packageName;
        this.typeSpec = builder.typeSpec;
        this.skipJavaLangImports = builder.skipJavaLangImports;
        this.staticImports = Util.immutableSet(builder.staticImports);
        this.indent = builder.indent;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.fillAlwaysQualifiedNames(builder.typeSpec, linkedHashSet);
        this.alwaysQualify = Util.immutableSet(linkedHashSet);
    }

    private void fillAlwaysQualifiedNames(TypeSpec typeSpec, Set<String> set) {
        set.addAll(typeSpec.alwaysQualifiedNames);
        for (TypeSpec typeSpec2 : typeSpec.typeSpecs) {
            this.fillAlwaysQualifiedNames(typeSpec2, set);
        }
    }

    public void writeTo(Appendable appendable) {
        CodeWriter codeWriter = new CodeWriter(NULL_APPENDABLE, this.indent, this.staticImports, this.alwaysQualify);
        this.emit(codeWriter);
        Map<String, ClassName> map = codeWriter.suggestedImports();
        CodeWriter codeWriter2 = new CodeWriter(appendable, this.indent, map, this.staticImports, this.alwaysQualify);
        this.emit(codeWriter2);
    }

    public void writeTo(Path path) {
        this.writeToPath(path);
    }

    public void writeTo(Path path, Charset charset) {
        this.writeToPath(path, charset);
    }

    public Path writeToPath(Path path) {
        return this.writeToPath(path, StandardCharsets.UTF_8);
    }

    public Path writeToPath(Path path, Charset charset) {
        Util.checkArgument(Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]), "path %s exists but is not a directory.", path);
        Path path2 = path;
        if (!this.packageName.isEmpty()) {
            for (String string : this.packageName.split("\\.")) {
                path2 = path2.resolve(string);
            }
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        Path path3 = path2.resolve(this.typeSpec.name + ".java");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path3, new OpenOption[0]), charset);){
            this.writeTo(outputStreamWriter);
        }
        return path3;
    }

    public void writeTo(File file) {
        this.writeTo(file.toPath());
    }

    public File writeToFile(File file) {
        Path path = this.writeToPath(file.toPath());
        return path.toFile();
    }

    public void writeTo(Filer filer) {
        String string = this.packageName.isEmpty() ? this.typeSpec.name : this.packageName + "." + this.typeSpec.name;
        List<Element> list = this.typeSpec.originatingElements;
        JavaFileObject javaFileObject = filer.createSourceFile(string, list.toArray(new Element[list.size()]));
        try (Writer writer = javaFileObject.openWriter();){
            this.writeTo(writer);
        }
        catch (Exception exception) {
            try {
                javaFileObject.delete();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    private void emit(CodeWriter codeWriter) {
        codeWriter.pushPackage(this.packageName);
        if (!this.fileComment.isEmpty()) {
            codeWriter.emitComment(this.fileComment);
        }
        if (!this.packageName.isEmpty()) {
            codeWriter.emit("package $L;\n", this.packageName);
            codeWriter.emit("\n");
        }
        if (!this.staticImports.isEmpty()) {
            for (String object : this.staticImports) {
                codeWriter.emit("import static $L;\n", object);
            }
            codeWriter.emit("\n");
        }
        int n = 0;
        for (ClassName className : new TreeSet<ClassName>(codeWriter.importedTypes().values())) {
            if (this.skipJavaLangImports && className.packageName().equals("java.lang") && !this.alwaysQualify.contains(className.simpleName)) continue;
            codeWriter.emit("import $L;\n", className.withoutAnnotations());
            ++n;
        }
        if (n > 0) {
            codeWriter.emit("\n");
        }
        this.typeSpec.emit(codeWriter, null, Collections.emptySet());
        codeWriter.popPackage();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.writeTo(stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public JavaFileObject toJavaFileObject() {
        URI uRI = URI.create((String)(this.packageName.isEmpty() ? this.typeSpec.name : this.packageName.replace('.', '/') + "/" + this.typeSpec.name) + JavaFileObject.Kind.SOURCE.extension);
        return new SimpleJavaFileObject(uRI, JavaFileObject.Kind.SOURCE){
            private final long lastModified;
            {
                this.lastModified = System.currentTimeMillis();
            }

            @Override
            public String getCharContent(boolean bl) {
                return JavaFile.this.toString();
            }

            @Override
            public InputStream openInputStream() {
                return new ByteArrayInputStream(this.getCharContent(true).getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public long getLastModified() {
                return this.lastModified;
            }
        };
    }

    public static Builder builder(String string, TypeSpec typeSpec) {
        Util.checkNotNull(string, "packageName == null", new Object[0]);
        Util.checkNotNull(typeSpec, "typeSpec == null", new Object[0]);
        return new Builder(string, typeSpec);
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.packageName, this.typeSpec);
        builder.fileComment.add(this.fileComment);
        builder.skipJavaLangImports = this.skipJavaLangImports;
        builder.indent = this.indent;
        return builder;
    }

    public static final class Builder {
        private final String packageName;
        private final TypeSpec typeSpec;
        private final CodeBlock.Builder fileComment = CodeBlock.builder();
        private boolean skipJavaLangImports;
        private String indent = "  ";
        public final Set<String> staticImports = new TreeSet<String>();

        private Builder(String string, TypeSpec typeSpec) {
            this.packageName = string;
            this.typeSpec = typeSpec;
        }

        public Builder addFileComment(String string, Object ... objectArray) {
            this.fileComment.add(string, objectArray);
            return this;
        }

        public Builder addStaticImport(Enum<?> enum_) {
            return this.addStaticImport(ClassName.get(enum_.getDeclaringClass()), enum_.name());
        }

        public Builder addStaticImport(Class<?> clazz, String ... stringArray) {
            return this.addStaticImport(ClassName.get(clazz), stringArray);
        }

        public Builder addStaticImport(ClassName className, String ... stringArray) {
            Util.checkArgument(className != null, "className == null", new Object[0]);
            Util.checkArgument(stringArray != null, "names == null", new Object[0]);
            Util.checkArgument(stringArray.length > 0, "names array is empty", new Object[0]);
            for (String string : stringArray) {
                Util.checkArgument(string != null, "null entry in names array: %s", Arrays.toString(stringArray));
                this.staticImports.add(className.canonicalName + "." + string);
            }
            return this;
        }

        public Builder skipJavaLangImports(boolean bl) {
            this.skipJavaLangImports = bl;
            return this;
        }

        public Builder indent(String string) {
            this.indent = string;
            return this;
        }

        public JavaFile build() {
            return new JavaFile(this);
        }
    }
}

