/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeBlock;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.ParameterSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeVariableName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;

public final class MethodSpec {
    static final String CONSTRUCTOR = "<init>";
    public final String name;
    public final CodeBlock javadoc;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final List<TypeVariableName> typeVariables;
    public final TypeName returnType;
    public final List<ParameterSpec> parameters;
    public final boolean varargs;
    public final List<TypeName> exceptions;
    public final CodeBlock code;
    public final CodeBlock defaultValue;

    private MethodSpec(Builder builder) {
        CodeBlock codeBlock = builder.code.build();
        Util.checkArgument(codeBlock.isEmpty() || !builder.modifiers.contains((Object)Modifier.ABSTRACT), "abstract method %s cannot have code", builder.name);
        Util.checkArgument(!builder.varargs || this.lastParameterIsArray(builder.parameters), "last parameter of varargs method %s must be an array", builder.name);
        this.name = Util.checkNotNull(builder.name, "name == null", new Object[0]);
        this.javadoc = builder.javadoc.build();
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.typeVariables = Util.immutableList(builder.typeVariables);
        this.returnType = builder.returnType;
        this.parameters = Util.immutableList(builder.parameters);
        this.varargs = builder.varargs;
        this.exceptions = Util.immutableList(builder.exceptions);
        this.defaultValue = builder.defaultValue;
        this.code = codeBlock;
    }

    private boolean lastParameterIsArray(List<ParameterSpec> list) {
        return !list.isEmpty() && TypeName.asArray(list.get((int)(list.size() - 1)).type) != null;
    }

    void emit(CodeWriter codeWriter, String string, Set<Modifier> set) {
        codeWriter.emitJavadoc(this.javadocWithParameters());
        codeWriter.emitAnnotations(this.annotations, false);
        codeWriter.emitModifiers(this.modifiers, set);
        if (!this.typeVariables.isEmpty()) {
            codeWriter.emitTypeVariables(this.typeVariables);
            codeWriter.emit(" ");
        }
        if (this.isConstructor()) {
            codeWriter.emit("$L($Z", string);
        } else {
            codeWriter.emit("$T $L($Z", this.returnType, this.name);
        }
        boolean bl = true;
        Iterator<ParameterSpec> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ParameterSpec parameterSpec = iterator.next();
            if (!bl) {
                codeWriter.emit(",").emitWrappingSpace();
            }
            parameterSpec.emit(codeWriter, !iterator.hasNext() && this.varargs);
            bl = false;
        }
        codeWriter.emit(")");
        if (this.defaultValue != null && !this.defaultValue.isEmpty()) {
            codeWriter.emit(" default ");
            codeWriter.emit(this.defaultValue);
        }
        if (!this.exceptions.isEmpty()) {
            codeWriter.emitWrappingSpace().emit("throws");
            boolean bl2 = true;
            for (TypeName typeName : this.exceptions) {
                if (!bl2) {
                    codeWriter.emit(",");
                }
                codeWriter.emitWrappingSpace().emit("$T", typeName);
                bl2 = false;
            }
        }
        if (this.hasModifier(Modifier.ABSTRACT)) {
            codeWriter.emit(";\n");
        } else if (this.hasModifier(Modifier.NATIVE)) {
            codeWriter.emit(this.code);
            codeWriter.emit(";\n");
        } else {
            codeWriter.emit(" {\n");
            codeWriter.indent();
            codeWriter.emit(this.code, true);
            codeWriter.unindent();
            codeWriter.emit("}\n");
        }
        codeWriter.popTypeVariables(this.typeVariables);
    }

    private CodeBlock javadocWithParameters() {
        CodeBlock.Builder builder = this.javadoc.toBuilder();
        boolean bl = true;
        for (ParameterSpec parameterSpec : this.parameters) {
            if (parameterSpec.javadoc.isEmpty()) continue;
            if (bl && !this.javadoc.isEmpty()) {
                builder.add("\n", new Object[0]);
            }
            bl = false;
            builder.add("@param $L $L", parameterSpec.name, parameterSpec.javadoc);
        }
        return builder.build();
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public boolean isConstructor() {
        return this.name.equals(CONSTRUCTOR);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CodeWriter codeWriter = new CodeWriter(stringBuilder);
            this.emit(codeWriter, "Constructor", Collections.emptySet());
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public static Builder methodBuilder(String string) {
        return new Builder(string);
    }

    public static Builder constructorBuilder() {
        return new Builder(CONSTRUCTOR);
    }

    public static Builder overriding(ExecutableElement executableElement) {
        Util.checkNotNull(executableElement, "method == null", new Object[0]);
        Element element = executableElement.getEnclosingElement();
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new IllegalArgumentException("Cannot override method on final class " + element);
        }
        Set<Modifier> set = executableElement.getModifiers();
        if (set.contains((Object)Modifier.PRIVATE) || set.contains((Object)Modifier.FINAL) || set.contains((Object)Modifier.STATIC)) {
            throw new IllegalArgumentException("cannot override method with modifiers: " + set);
        }
        String string = executableElement.getSimpleName().toString();
        Builder builder = MethodSpec.methodBuilder(string);
        builder.addAnnotation(Override.class);
        set = new LinkedHashSet<Modifier>(set);
        set.remove((Object)Modifier.ABSTRACT);
        set.remove((Object)Modifier.DEFAULT);
        builder.addModifiers(set);
        for (TypeParameterElement annotatedConstruct : executableElement.getTypeParameters()) {
            TypeVariable typeVariable = (TypeVariable)annotatedConstruct.asType();
            builder.addTypeVariable(TypeVariableName.get(typeVariable));
        }
        builder.returns(TypeName.get(executableElement.getReturnType()));
        builder.addParameters(ParameterSpec.parametersOf(executableElement));
        builder.varargs(executableElement.isVarArgs());
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            builder.addException(TypeName.get(typeMirror));
        }
        return builder;
    }

    public static Builder overriding(ExecutableElement executableElement, DeclaredType declaredType, Types types) {
        int n;
        ExecutableType executableType = (ExecutableType)types.asMemberOf(declaredType, executableElement);
        List<? extends TypeMirror> list = executableType.getParameterTypes();
        List<? extends TypeMirror> list2 = executableType.getThrownTypes();
        TypeMirror typeMirror = executableType.getReturnType();
        Builder builder = MethodSpec.overriding(executableElement);
        builder.returns(TypeName.get(typeMirror));
        int n2 = builder.parameters.size();
        for (n = 0; n < n2; ++n) {
            ParameterSpec parameterSpec = builder.parameters.get(n);
            TypeName typeName = TypeName.get(list.get(n));
            builder.parameters.set(n, parameterSpec.toBuilder(typeName, parameterSpec.name).build());
        }
        builder.exceptions.clear();
        n2 = list2.size();
        for (n = 0; n < n2; ++n) {
            builder.addException(TypeName.get(list2.get(n)));
        }
        return builder;
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name);
        builder.javadoc.add(this.javadoc);
        builder.annotations.addAll(this.annotations);
        builder.modifiers.addAll(this.modifiers);
        builder.typeVariables.addAll(this.typeVariables);
        builder.returnType = this.returnType;
        builder.parameters.addAll(this.parameters);
        builder.exceptions.addAll(this.exceptions);
        builder.code.add(this.code);
        builder.varargs = this.varargs;
        builder.defaultValue = this.defaultValue;
        return builder;
    }

    public static final class Builder {
        private String name;
        private final CodeBlock.Builder javadoc = CodeBlock.builder();
        private TypeName returnType;
        private final Set<TypeName> exceptions = new LinkedHashSet<TypeName>();
        private final CodeBlock.Builder code = CodeBlock.builder();
        private boolean varargs;
        private CodeBlock defaultValue;
        public final List<TypeVariableName> typeVariables = new ArrayList<TypeVariableName>();
        public final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        public final List<Modifier> modifiers = new ArrayList<Modifier>();
        public final List<ParameterSpec> parameters = new ArrayList<ParameterSpec>();

        private Builder(String string) {
            this.setName(string);
        }

        public Builder setName(String string) {
            Util.checkNotNull(string, "name == null", new Object[0]);
            Util.checkArgument(string.equals(MethodSpec.CONSTRUCTOR) || SourceVersion.isName(string), "not a valid name: %s", string);
            this.name = string;
            this.returnType = string.equals(MethodSpec.CONSTRUCTOR) ? null : TypeName.VOID;
            return this;
        }

        public Builder addJavadoc(String string, Object ... objectArray) {
            this.javadoc.add(string, objectArray);
            return this;
        }

        public Builder addJavadoc(CodeBlock codeBlock) {
            this.javadoc.add(codeBlock);
            return this;
        }

        public Builder addAnnotations(Iterable<AnnotationSpec> iterable) {
            Util.checkArgument(iterable != null, "annotationSpecs == null", new Object[0]);
            for (AnnotationSpec annotationSpec : iterable) {
                this.annotations.add(annotationSpec);
            }
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName className) {
            this.annotations.add(AnnotationSpec.builder(className).build());
            return this;
        }

        public Builder addAnnotation(Class<?> clazz) {
            return this.addAnnotation(ClassName.get(clazz));
        }

        public Builder addModifiers(Modifier ... modifierArray) {
            Util.checkNotNull(modifierArray, "modifiers == null", new Object[0]);
            Collections.addAll(this.modifiers, modifierArray);
            return this;
        }

        public Builder addModifiers(Iterable<Modifier> iterable) {
            Util.checkNotNull(iterable, "modifiers == null", new Object[0]);
            for (Modifier modifier : iterable) {
                this.modifiers.add(modifier);
            }
            return this;
        }

        public Builder addTypeVariables(Iterable<TypeVariableName> iterable) {
            Util.checkArgument(iterable != null, "typeVariables == null", new Object[0]);
            for (TypeVariableName typeVariableName : iterable) {
                this.typeVariables.add(typeVariableName);
            }
            return this;
        }

        public Builder addTypeVariable(TypeVariableName typeVariableName) {
            this.typeVariables.add(typeVariableName);
            return this;
        }

        public Builder returns(TypeName typeName) {
            Util.checkState(!this.name.equals(MethodSpec.CONSTRUCTOR), "constructor cannot have return type.", new Object[0]);
            this.returnType = typeName;
            return this;
        }

        public Builder returns(Type type) {
            return this.returns(TypeName.get(type));
        }

        public Builder addParameters(Iterable<ParameterSpec> iterable) {
            Util.checkArgument(iterable != null, "parameterSpecs == null", new Object[0]);
            for (ParameterSpec parameterSpec : iterable) {
                this.parameters.add(parameterSpec);
            }
            return this;
        }

        public Builder addParameter(ParameterSpec parameterSpec) {
            this.parameters.add(parameterSpec);
            return this;
        }

        public Builder addParameter(TypeName typeName, String string, Modifier ... modifierArray) {
            return this.addParameter(ParameterSpec.builder(typeName, string, modifierArray).build());
        }

        public Builder addParameter(Type type, String string, Modifier ... modifierArray) {
            return this.addParameter(TypeName.get(type), string, modifierArray);
        }

        public Builder varargs() {
            return this.varargs(true);
        }

        public Builder varargs(boolean bl) {
            this.varargs = bl;
            return this;
        }

        public Builder addExceptions(Iterable<? extends TypeName> iterable) {
            Util.checkArgument(iterable != null, "exceptions == null", new Object[0]);
            for (TypeName typeName : iterable) {
                this.exceptions.add(typeName);
            }
            return this;
        }

        public Builder addException(TypeName typeName) {
            this.exceptions.add(typeName);
            return this;
        }

        public Builder addException(Type type) {
            return this.addException(TypeName.get(type));
        }

        public Builder addCode(String string, Object ... objectArray) {
            this.code.add(string, objectArray);
            return this;
        }

        public Builder addNamedCode(String string, Map<String, ?> map) {
            this.code.addNamed(string, map);
            return this;
        }

        public Builder addCode(CodeBlock codeBlock) {
            this.code.add(codeBlock);
            return this;
        }

        public Builder addComment(String string, Object ... objectArray) {
            this.code.add("// " + string + "\n", objectArray);
            return this;
        }

        public Builder defaultValue(String string, Object ... objectArray) {
            return this.defaultValue(CodeBlock.of(string, objectArray));
        }

        public Builder defaultValue(CodeBlock codeBlock) {
            Util.checkState(this.defaultValue == null, "defaultValue was already set", new Object[0]);
            this.defaultValue = Util.checkNotNull(codeBlock, "codeBlock == null", new Object[0]);
            return this;
        }

        public Builder beginControlFlow(String string, Object ... objectArray) {
            this.code.beginControlFlow(string, objectArray);
            return this;
        }

        public Builder beginControlFlow(CodeBlock codeBlock) {
            return this.beginControlFlow("$L", codeBlock);
        }

        public Builder nextControlFlow(String string, Object ... objectArray) {
            this.code.nextControlFlow(string, objectArray);
            return this;
        }

        public Builder nextControlFlow(CodeBlock codeBlock) {
            return this.nextControlFlow("$L", codeBlock);
        }

        public Builder endControlFlow() {
            this.code.endControlFlow();
            return this;
        }

        public Builder endControlFlow(String string, Object ... objectArray) {
            this.code.endControlFlow(string, objectArray);
            return this;
        }

        public Builder endControlFlow(CodeBlock codeBlock) {
            return this.endControlFlow("$L", codeBlock);
        }

        public Builder addStatement(String string, Object ... objectArray) {
            this.code.addStatement(string, objectArray);
            return this;
        }

        public Builder addStatement(CodeBlock codeBlock) {
            this.code.addStatement(codeBlock);
            return this;
        }

        public MethodSpec build() {
            return new MethodSpec(this);
        }
    }
}

