/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.container.DataBits;
import com.volmit.adapt.util.arcane.spatial.container.HashPalette;
import com.volmit.adapt.util.arcane.spatial.container.LinearPalette;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.util.Varint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DataContainer<T> {
    protected static final int INITIAL_BITS = 3;
    protected static final int LINEAR_BITS_LIMIT = 4;
    protected static final int LINEAR_INITIAL_LENGTH = (int)Math.pow(2.0, 4.0) + 1;
    protected static final int[] BIT = DataContainer.computeBitLimits();
    private final AtomicReference<Palette<T>> palette;
    private final AtomicReference<DataBits> data;
    private final AtomicInteger bits;
    private final int length;
    private final NodeWritable<T> writer;

    public DataContainer(NodeWritable<T> nodeWritable, int n) {
        this.writer = nodeWritable;
        this.length = n;
        this.bits = new AtomicInteger(3);
        this.data = new AtomicReference<DataBits>(new DataBits(3, n));
        this.palette = new AtomicReference<Palette<T>>(this.newPalette(3));
    }

    public DataContainer(byte[] byArray, NodeWritable<T> nodeWritable) {
        this(new ByteArrayInputStream(byArray), nodeWritable);
    }

    public DataContainer(InputStream inputStream, NodeWritable<T> nodeWritable) {
        this(new DataInputStream(inputStream), nodeWritable);
    }

    public DataContainer(DataInputStream dataInputStream, NodeWritable<T> nodeWritable) {
        this.writer = nodeWritable;
        this.length = Varint.readUnsignedVarInt(dataInputStream);
        this.palette = new AtomicReference<Palette<T>>(this.newPalette(dataInputStream));
        this.data = new AtomicReference<DataBits>(new DataBits(this.palette.get().bits(), this.length, dataInputStream));
        this.bits = new AtomicInteger(this.palette.get().bits());
    }

    public static String readBitString(DataInputStream dataInputStream) {
        DataContainer<Character> dataContainer = new DataContainer<Character>(dataInputStream, new NodeWritable<Character>(){

            @Override
            public Character readNodeData(DataInputStream dataInputStream) {
                return Character.valueOf(dataInputStream.readChar());
            }

            @Override
            public void writeNodeData(DataOutputStream dataOutputStream, Character c) {
                dataOutputStream.writeChar(c.charValue());
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = dataContainer.size() - 1; i >= 0; --i) {
            stringBuilder.setCharAt(i, dataContainer.get(i).charValue());
        }
        return stringBuilder.toString();
    }

    public static void writeBitString(String string, DataOutputStream dataOutputStream) {
        DataContainer<Character> dataContainer = new DataContainer<Character>(new NodeWritable<Character>(){

            @Override
            public Character readNodeData(DataInputStream dataInputStream) {
                return Character.valueOf(dataInputStream.readChar());
            }

            @Override
            public void writeNodeData(DataOutputStream dataOutputStream, Character c) {
                dataOutputStream.writeChar(c.charValue());
            }
        }, string.length());
        for (int i = 0; i < string.length(); ++i) {
            dataContainer.set(i, Character.valueOf(string.charAt(i)));
        }
        dataContainer.writeDos(dataOutputStream);
    }

    public DataBits getData() {
        return this.data.get();
    }

    public Palette<T> getPalette() {
        return this.palette.get();
    }

    public String toString() {
        return "DataContainer <" + this.length + " x " + this.bits + " bits> -> Palette<" + this.palette.get().getClass().getSimpleName().replaceAll("\\QPalette\\E", "") + ">: " + this.palette.get().size() + " " + this.data.get().toString() + " PalBit: " + this.palette.get().bits();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void write(OutputStream outputStream) {
        this.writeDos(new DataOutputStream(outputStream));
    }

    public void writeDos(DataOutputStream dataOutputStream) {
        Varint.writeUnsignedVarInt(this.length, dataOutputStream);
        Varint.writeUnsignedVarInt(this.palette.get().size(), dataOutputStream);
        this.palette.get().iterateIO((object, n) -> this.writer.writeNodeData(dataOutputStream, object));
        this.data.get().write(dataOutputStream);
        dataOutputStream.flush();
    }

    private Palette<T> newPalette(DataInputStream dataInputStream) {
        int n = Varint.readUnsignedVarInt(dataInputStream);
        Palette<T> palette = this.newPalette(DataContainer.bits(n + 1));
        palette.from(n, this.writer, dataInputStream);
        return palette;
    }

    private Palette<T> newPalette(int n) {
        if (n <= 4) {
            return new LinearPalette(LINEAR_INITIAL_LENGTH);
        }
        return new HashPalette();
    }

    public void ensurePaletted(T t) {
        if (this.palette.get().id(t) == -1) {
            this.expandOne();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int n, T t) {
        DataContainer dataContainer = this;
        synchronized (dataContainer) {
            int n2 = this.palette.get().id(t);
            if (n2 == -1) {
                this.expandOne();
                n2 = this.palette.get().add(t);
            }
            this.data.get().set(n, n2);
        }
    }

    private void expandOne() {
        if (this.palette.get().size() + 1 >= BIT[this.bits.get()]) {
            this.setBits(this.bits.get() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int n) {
        DataContainer dataContainer = this;
        synchronized (dataContainer) {
            int n2 = this.data.get().get(n) + 1;
            if (n2 <= 0) {
                return null;
            }
            return this.palette.get().get(n2 - 1);
        }
    }

    public void setBits(int n) {
        if (this.bits.get() != n) {
            if (this.bits.get() <= 4 != n <= 4) {
                this.palette.set(this.newPalette(n).from(this.palette.get()));
            }
            this.bits.set(n);
            this.data.set(this.data.get().setBits(n));
        }
    }

    private static int[] computeBitLimits() {
        int[] nArray = new int[16];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)Math.pow(2.0, i);
        }
        return nArray;
    }

    protected static int bits(int n) {
        if (BIT[3] >= n) {
            return 3;
        }
        for (int i = 0; i < BIT.length; ++i) {
            if (BIT[i] < n) continue;
            return i;
        }
        return BIT.length - 1;
    }

    public int size() {
        return this.getData().getSize();
    }
}

