/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk;

import com.volmit.adapt.util.arcane.spatial.hunk.HunkFace;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.ArrayHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.AtomicDoubleHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.AtomicHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.AtomicIntegerHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.AtomicLongHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.MappedHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.SynchronizedArrayHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.view.DriftHunkView;
import com.volmit.adapt.util.arcane.spatial.hunk.view.FringedHunkView;
import com.volmit.adapt.util.arcane.spatial.hunk.view.FunctionalHunkView;
import com.volmit.adapt.util.arcane.spatial.hunk.view.HunkView;
import com.volmit.adapt.util.arcane.spatial.hunk.view.InvertedHunkView;
import com.volmit.adapt.util.arcane.spatial.hunk.view.ListeningHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.view.ReadOnlyHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.view.SynchronizedHunkView;
import com.volmit.adapt.util.arcane.spatial.hunk.view.WriteTrackHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import com.volmit.adapt.util.arcane.spatial.util.Function;
import com.volmit.adapt.util.arcane.spatial.util.Pos;
import com.volmit.adapt.util.arcane.spatial.util.Supplier3R;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface Hunk<T> {
    public static <T> Hunk<T> view(Hunk<T> src) {
        return new HunkView<T>(src);
    }

    public static <A, B> Hunk<B> convertedReadView(Hunk<A> src, Function.One<A, B> reader) {
        return new FunctionalHunkView<A, B>(src, reader, null);
    }

    public static <A, B> Hunk<B> convertedWriteView(Hunk<A> src, Function.One<B, A> writer) {
        return new FunctionalHunkView<A, B>(src, null, writer);
    }

    public static <A, B> Hunk<B> convertedReadWriteView(Hunk<A> src, Function.One<A, B> reader, Function.One<B, A> writer) {
        return new FunctionalHunkView<A, B>(src, reader, writer);
    }

    public static <T> Hunk<T> fringe(Hunk<T> i, Hunk<T> o) {
        return new FringedHunkView<T>(i, o);
    }

    public static <T> Hunk<T> newHunk(int w, int h, int d) {
        return Hunk.newArrayHunk(w, h, d);
    }

    @SafeVarargs
    public static <T> Hunk<T> newCombinedHunk(Hunk<T> ... hunks) {
        return Hunk.newCombinedArrayHunk(hunks);
    }

    public static <T> Hunk<T> newArrayHunk(int w, int h, int d) {
        return new ArrayHunk(w, h, d);
    }

    @SafeVarargs
    public static <T> Hunk<T> newCombinedArrayHunk(Hunk<T> ... hunks) {
        return Hunk.combined(Hunk::newArrayHunk, hunks);
    }

    public static <T> Hunk<T> newSynchronizedArrayHunk(int w, int h, int d) {
        return new SynchronizedArrayHunk(w, h, d);
    }

    @SafeVarargs
    public static <T> Hunk<T> newCombinedSynchronizedArrayHunk(Hunk<T> ... hunks) {
        return Hunk.combined(Hunk::newSynchronizedArrayHunk, hunks);
    }

    public static <T> Hunk<T> newMappedHunk(int w, int h, int d) {
        return new MappedHunk(w, h, d);
    }

    public static <T> Hunk<T> newMappedHunkSynced(int w, int h, int d) {
        return new MappedHunk(w, h, d).synchronize();
    }

    @SafeVarargs
    public static <T> Hunk<T> newCombinedMappedHunk(Hunk<T> ... hunks) {
        return Hunk.combined(Hunk::newMappedHunk, hunks);
    }

    public static <T> Hunk<T> newAtomicHunk(int w, int h, int d) {
        return new AtomicHunk(w, h, d);
    }

    @SafeVarargs
    public static <T> Hunk<T> newCombinedAtomicHunk(Hunk<T> ... hunks) {
        return Hunk.combined(Hunk::newAtomicHunk, hunks);
    }

    public static Hunk<Double> newAtomicDoubleHunk(int w, int h, int d) {
        return new AtomicDoubleHunk(w, h, d);
    }

    @SafeVarargs
    public static Hunk<Double> newCombinedAtomicDoubleHunk(Hunk<Double> ... hunks) {
        return Hunk.combined(Hunk::newAtomicDoubleHunk, hunks);
    }

    public static Hunk<Long> newAtomicLongHunk(int w, int h, int d) {
        return new AtomicLongHunk(w, h, d);
    }

    @SafeVarargs
    public static Hunk<Long> newCombinedAtomicLongHunk(Hunk<Long> ... hunks) {
        return Hunk.combined(Hunk::newAtomicLongHunk, hunks);
    }

    public static Hunk<Integer> newAtomicIntegerHunk(int w, int h, int d) {
        return new AtomicIntegerHunk(w, h, d);
    }

    @SafeVarargs
    public static Hunk<Integer> newCombinedAtomicIntegerHunk(Hunk<Integer> ... hunks) {
        return Hunk.combined(Hunk::newAtomicIntegerHunk, hunks);
    }

    @SafeVarargs
    public static <T> Hunk<T> combined(Function.Three<Integer, Integer, Integer, Hunk<T>> factory, Hunk<T> ... hunks) {
        int w = 0;
        int h = 0;
        int d = 0;
        for (Hunk<T> i : hunks) {
            w = Math.max(w, i.getWidth());
            h = Math.max(h, i.getHeight());
            d = Math.max(d, i.getDepth());
        }
        Hunk<T> b = factory.apply(w, h, d);
        for (Hunk<T> i : hunks) {
            b.insert(i);
        }
        return b;
    }

    public static <A, B> void getDualSections2D(int sections, Hunk<A> a2, Hunk<B> b, Consume.Six<Integer, Integer, Integer, Hunk<A>, Hunk<B>, Runnable> v, Consume.Five<Integer, Integer, Integer, Hunk<A>, Hunk<B>> inserterAB) {
        if (a2.getWidth() != b.getWidth() || a2.getHeight() != b.getHeight() || a2.getDepth() != b.getDepth()) {
            throw new RuntimeException("Hunk sizes must match!");
        }
        int dim = a2.get2DDimension(sections);
        if (sections <= 1) {
            Hunk.getDualSection(0, 0, 0, a2.getWidth(), a2.getHeight(), a2.getDepth(), a2, b, (ha, hr, r) -> v.accept(0, 0, 0, (Hunk)ha, (Hunk)hr, (Runnable)r), inserterAB);
            return;
        }
        int w = a2.getWidth() / dim;
        int wr = a2.getWidth() - w * dim;
        int d = a2.getDepth() / dim;
        int dr = a2.getDepth() - d * dim;
        for (int i = 0; i < a2.getWidth(); i += w) {
            int ii = i;
            for (int j = 0; j < a2.getDepth(); j += d) {
                int jj = j;
                Hunk.getDualSection(i, 0, j, i + w + (i == 0 ? wr : 0), a2.getHeight(), j + d + (j == 0 ? dr : 0), a2, b, (ha, hr, r) -> v.accept(ii, 0, jj, (Hunk)ha, (Hunk)hr, (Runnable)r), inserterAB);
                i = i == 0 ? i + wr : i;
                j = j == 0 ? j + dr : j;
            }
        }
    }

    public static <A, B> void getDualSection(int x, int y, int z, int x1, int y1, int z1, Hunk<A> a2, Hunk<B> b, Consume.Three<Hunk<A>, Hunk<B>, Runnable> v, Consume.Five<Integer, Integer, Integer, Hunk<A>, Hunk<B>> inserter) {
        ArrayHunk copya = a2.crop(x, y, z, x1, y1, z1);
        ArrayHunk copyb = b.crop(x, y, z, x1, y1, z1);
        v.accept(copya, copyb, () -> inserter.accept(x, y, z, copya, copyb));
    }

    public static <T> Hunk<T> newHunk(int w, int h, int d, Class<T> type, boolean packed, boolean concurrent) {
        if (type.equals(Double.class)) {
            return concurrent ? (packed ? Hunk.newAtomicDoubleHunk(w, h, d) : Hunk.newMappedHunk(w, h, d)) : (packed ? Hunk.newArrayHunk(w, h, d) : Hunk.newMappedHunkSynced(w, h, d));
        }
        if (type.equals(Integer.class)) {
            return concurrent ? (packed ? Hunk.newAtomicIntegerHunk(w, h, d) : Hunk.newMappedHunk(w, h, d)) : (packed ? Hunk.newArrayHunk(w, h, d) : Hunk.newMappedHunkSynced(w, h, d));
        }
        if (type.equals(Long.class)) {
            return concurrent ? (packed ? Hunk.newAtomicLongHunk(w, h, d) : Hunk.newMappedHunk(w, h, d)) : (packed ? Hunk.newArrayHunk(w, h, d) : Hunk.newMappedHunkSynced(w, h, d));
        }
        return concurrent ? (packed ? Hunk.newAtomicHunk(w, h, d) : Hunk.newMappedHunk(w, h, d)) : (packed ? Hunk.newArrayHunk(w, h, d) : Hunk.newMappedHunkSynced(w, h, d));
    }

    public static int max(int a1, int a2, int a3, int a4, int a5, int a6, int a7, int a8) {
        return Math.max(Math.max(Math.max(a5, a6), Math.max(a7, a8)), Math.max(Math.max(a1, a2), Math.max(a3, a4)));
    }

    public static int min(int a1, int a2, int a3, int a4, int a5, int a6, int a7, int a8) {
        return Math.min(Math.min(Math.min(a5, a6), Math.min(a7, a8)), Math.min(Math.min(a1, a2), Math.min(a3, a4)));
    }

    public static void rotate(double x, double y, double z, int[] c) {
        if (x % 360.0 != 0.0) {
            Hunk.rotateAroundX(Math.toRadians(x), c);
        }
        if (y % 360.0 != 0.0) {
            Hunk.rotateAroundY(Math.toRadians(y), c);
        }
        if (z % 360.0 != 0.0) {
            Hunk.rotateAroundZ(Math.toRadians(z), c);
        }
    }

    public static void rotateAroundX(double a2, int[] c) {
        Hunk.rotateAroundX(Math.cos(a2), Math.sin(a2), c);
    }

    public static void rotateAroundX(double cos, double sin, int[] c) {
        int y = (int)Math.floor(cos * ((double)c[1] + 0.5) - sin * ((double)c[2] + 0.5));
        int z = (int)Math.floor(sin * ((double)c[1] + 0.5) + cos * ((double)c[2] + 0.5));
        c[1] = y;
        c[2] = z;
    }

    public static void rotateAroundY(double a2, int[] c) {
        Hunk.rotateAroundY(Math.cos(a2), Math.sin(a2), c);
    }

    public static void rotateAroundY(double cos, double sin, int[] c) {
        int x = (int)Math.floor(cos * ((double)c[0] + 0.5) + sin * ((double)c[2] + 0.5));
        int z = (int)Math.floor(-sin * ((double)c[0] + 0.5) + cos * ((double)c[2] + 0.5));
        c[0] = x;
        c[2] = z;
    }

    public static void rotateAroundZ(double a2, int[] c) {
        Hunk.rotateAroundZ(Math.cos(a2), Math.sin(a2), c);
    }

    public static void rotateAroundZ(double cos, double sin, int[] c) {
        int x = (int)Math.floor(cos * ((double)c[0] + 0.5) - sin * ((double)c[1] + 0.5));
        int y = (int)Math.floor(sin * ((double)c[0] + 0.5) + cos * ((double)c[1] + 0.5));
        c[0] = x;
        c[1] = y;
    }

    default public boolean isMapped() {
        return false;
    }

    default public int getEntryCount() {
        return this.getWidth() * this.getHeight() * this.getDepth();
    }

    default public Hunk<T> listen(Consume.Four<Integer, Integer, Integer, T> l) {
        return new ListeningHunk<T>(this, l);
    }

    default public Hunk<T> synchronize() {
        return new SynchronizedHunkView(this);
    }

    default public Hunk<T> trackWrite(AtomicBoolean b) {
        return new WriteTrackHunk(this, b);
    }

    default public Hunk<T> readOnly() {
        return new ReadOnlyHunk(this);
    }

    default public int getNonNullEntries() {
        AtomicInteger count = new AtomicInteger();
        this.iterateSync((Integer x, Integer y, Integer z, T v) -> count.getAndAdd(1));
        return count.get();
    }

    default public boolean isAtomic() {
        return false;
    }

    default public Hunk<T> invertY() {
        return new InvertedHunkView(this);
    }

    default public int getMaximumDimension() {
        return Math.max(this.getWidth(), Math.max(this.getHeight(), this.getDepth()));
    }

    default public int getIdeal2DParallelism() {
        return this.getMax2DParallelism() / 4;
    }

    default public int getIdeal3DParallelism() {
        return this.getMax3DParallelism() / 8;
    }

    default public int getMinimumDimension() {
        return Math.min(this.getWidth(), Math.min(this.getHeight(), this.getDepth()));
    }

    default public int getMax2DParallelism() {
        return (int)Math.pow((float)this.getMinimumDimension() / 2.0f, 2.0);
    }

    default public int getMax3DParallelism() {
        return (int)Math.pow((float)this.getMinimumDimension() / 2.0f, 3.0);
    }

    default public int filterDimension(int dim) {
        if (dim <= 1) {
            return 1;
        }
        int n = dim = dim % 2 != 0 ? dim + 1 : dim;
        if (dim > this.getMinimumDimension() / 2) {
            if (dim <= 2) {
                return 1;
            }
            dim -= 2;
        }
        return dim;
    }

    default public int get2DDimension(int sections) {
        if (sections <= 1) {
            return 1;
        }
        return this.filterDimension((int)Math.ceil(Math.sqrt(sections)));
    }

    default public int get3DDimension(int sections) {
        if (sections <= 1) {
            return 1;
        }
        return this.filterDimension((int)Math.ceil(Math.cbrt(sections)));
    }

    default public Hunk<T> drift(int x, int y, int z) {
        return new DriftHunkView(this, x, y, z);
    }

    default public Hunk<T> iterateSync(Consume.Three<Integer, Integer, Integer> c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    c.accept(i, j, k);
                }
            }
        }
        return this;
    }

    default public Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    c.accept(i, j, k, this.get(i, j, k));
                }
            }
        }
        return this;
    }

    default public Hunk<T> updateSync(Function.Four<Integer, Integer, Integer, T, T> c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    this.set(i, j, k, c.apply(i, j, k, this.get(i, j, k)));
                }
            }
        }
        return this;
    }

    default public Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> c) throws IOException {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    c.accept(i, j, k, this.get(i, j, k));
                }
            }
        }
        return this;
    }

    default public Hunk<T> getSections2D(int sections, Consume.Five<Integer, Integer, Integer, Hunk<T>, Runnable> v) {
        return this.getSections2D(sections, v, this::insert);
    }

    default public Hunk<T> getSectionsAtomic2D(int sections, Consume.Four<Integer, Integer, Integer, Hunk<T>> v) {
        int dim = this.get2DDimension(sections);
        if (sections <= 1) {
            this.getAtomicSection(0, 0, 0, this.getWidth(), this.getHeight(), this.getDepth(), hh -> v.accept(0, 0, 0, (Hunk)hh));
            return this;
        }
        int w = this.getWidth() / dim;
        int wr = this.getWidth() - w * dim;
        int d = this.getDepth() / dim;
        int dr = this.getDepth() - d * dim;
        for (int i = 0; i < this.getWidth(); i += w) {
            int ii = i;
            for (int j = 0; j < this.getDepth(); j += d) {
                int jj = j;
                this.getAtomicSection(i, 0, j, i + w + (i == 0 ? wr : 0), this.getHeight(), j + d + (j == 0 ? dr : 0), h -> v.accept(ii, 0, jj, (Hunk)h));
                i = i == 0 ? i + wr : i;
                j = j == 0 ? j + dr : j;
            }
        }
        return this;
    }

    default public Hunk<T> getSections2D(int sections, Consume.Five<Integer, Integer, Integer, Hunk<T>, Runnable> v, Consume.Four<Integer, Integer, Integer, Hunk<T>> inserter) {
        int dim = this.get2DDimension(sections);
        if (sections <= 1) {
            this.getSection(0, 0, 0, this.getWidth(), this.getHeight(), this.getDepth(), (hh, r) -> v.accept(0, 0, 0, (Hunk)hh, (Runnable)r), inserter);
            return this;
        }
        int w = this.getWidth() / dim;
        int wr = this.getWidth() - w * dim;
        int d = this.getDepth() / dim;
        int dr = this.getDepth() - d * dim;
        for (int i = 0; i < this.getWidth(); i += w) {
            int ii = i;
            for (int j = 0; j < this.getDepth(); j += d) {
                int jj = j;
                this.getSection(i, 0, j, i + w + (i == 0 ? wr : 0), this.getHeight(), j + d + (j == 0 ? dr : 0), (h, r) -> v.accept(ii, 0, jj, (Hunk)h, (Runnable)r), inserter);
                i = i == 0 ? i + wr : i;
                j = j == 0 ? j + dr : j;
            }
        }
        return this;
    }

    default public Hunk<T> getSections2DYLimit(int sections, int ymin, int ymax, Consume.Five<Integer, Integer, Integer, Hunk<T>, Runnable> v, Consume.Four<Integer, Integer, Integer, Hunk<T>> inserter) {
        int dim = this.get2DDimension(sections);
        if (sections <= 1) {
            this.getSection(0, 0, 0, this.getWidth(), this.getHeight(), this.getDepth(), (hh, r) -> v.accept(0, 0, 0, (Hunk)hh, (Runnable)r), inserter);
            return this;
        }
        int w = this.getWidth() / dim;
        int wr = this.getWidth() - w * dim;
        int d = this.getDepth() / dim;
        int dr = this.getDepth() - d * dim;
        for (int i = 0; i < this.getWidth(); i += w) {
            int ii = i;
            for (int j = 0; j < this.getDepth(); j += d) {
                int jj = j;
                this.getSection(i, ymin, j, i + w + (i == 0 ? wr : 0), ymax, j + d + (j == 0 ? dr : 0), (h, r) -> v.accept(ii, ymin, jj, (Hunk)h, (Runnable)r), inserter);
                i = i == 0 ? i + wr : i;
                j = j == 0 ? j + dr : j;
            }
        }
        return this;
    }

    default public Hunk<T> getSections3D(int sections, Consume.Five<Integer, Integer, Integer, Hunk<T>, Runnable> v) {
        return this.getSections3D(sections, v, (xx, yy, zz, c) -> this.insert((int)xx, (int)yy, (int)zz, (Hunk<T>)c));
    }

    default public Hunk<T> getSections3D(int sections, Consume.Five<Integer, Integer, Integer, Hunk<T>, Runnable> v, Consume.Four<Integer, Integer, Integer, Hunk<T>> inserter) {
        int dim = this.get3DDimension(sections);
        if (sections <= 1) {
            this.getSection(0, 0, 0, this.getWidth(), this.getHeight(), this.getDepth(), (hh, r) -> v.accept(0, 0, 0, (Hunk)hh, (Runnable)r), inserter);
            return this;
        }
        int w = this.getWidth() / dim;
        int h = this.getHeight() / dim;
        int d = this.getDepth() / dim;
        int wr = this.getWidth() - w * dim;
        int hr = this.getHeight() - h * dim;
        int dr = this.getDepth() - d * dim;
        for (int i = 0; i < this.getWidth(); i += w) {
            int ii = i;
            for (int j = 0; j < this.getHeight(); j += d) {
                int jj = j;
                for (int k = 0; k < this.getDepth(); k += d) {
                    int kk = k;
                    this.getSection(ii, jj, kk, i + w + (i == 0 ? wr : 0), j + h + (j == 0 ? hr : 0), k + d + (k == 0 ? dr : 0), (hh, r) -> v.accept(ii, jj, kk, (Hunk)hh, (Runnable)r), inserter);
                    i = i == 0 ? i + wr : i;
                    j = j == 0 ? j + hr : j;
                    k = k == 0 ? k + dr : k;
                }
            }
        }
        return this;
    }

    default public Hunk<T> getSection(int x, int y, int z, int x1, int y1, int z1, Consume.Two<Hunk<T>, Runnable> v) {
        return this.getSection(x, y, z, x1, y1, z1, v, (xx, yy, zz, c) -> this.insert((int)xx, (int)yy, (int)zz, (Hunk<T>)c));
    }

    default public Hunk<T> getSection(int x, int y, int z, int x1, int y1, int z1, Consume.Two<Hunk<T>, Runnable> v, Consume.Four<Integer, Integer, Integer, Hunk<T>> inserter) {
        ArrayHunk copy = this.crop(x, y, z, x1, y1, z1);
        v.accept(copy, () -> inserter.accept(x, y, z, copy));
        return this;
    }

    default public Hunk<T> getAtomicSection(int x, int y, int z, int x1, int y1, int z1, Consumer<Hunk<T>> v) {
        Hunk<T> copy = this.croppedView(x, y, z, x1, y1, z1);
        v.accept(copy);
        return this;
    }

    default public ArrayHunk<T> crop(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayHunk<T> h = new ArrayHunk<T>(x2 - x1, y2 - y1, z2 - z1);
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                for (int k = z1; k < z2; ++k) {
                    h.setRaw(i - x1, j - y1, k - z1, this.getRaw(i, j, k));
                }
            }
        }
        return h;
    }

    default public Hunk<T> croppedView(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new HunkView(this, x2 - x1, y2 - y1, z2 - z1, x1, y1, z1);
    }

    public int getWidth();

    public int getDepth();

    public int getHeight();

    default public void set(int x1, int y1, int z1, int x2, int y2, int z2, T t) {
        for (int i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                for (int k = z1; k <= z2; ++k) {
                    this.setRaw(i, j, k, t);
                }
            }
        }
    }

    default public T getClosest(int x, int y, int z) {
        return this.getRaw(x >= this.getWidth() ? this.getWidth() - 1 : (x < 0 ? 0 : x), y >= this.getHeight() ? this.getHeight() - 1 : (y < 0 ? 0 : y), z >= this.getDepth() ? this.getDepth() - 1 : (z < 0 ? 0 : z));
    }

    default public Pos getCenter() {
        return new Pos(this.getCenterX(), this.getCenterY(), this.getCenterZ());
    }

    default public int getCenterX() {
        return (int)Math.floor(this.getWidth() / 2);
    }

    default public int getCenterY() {
        return (int)Math.floor(this.getHeight() / 2);
    }

    default public int getCenterZ() {
        return (int)Math.floor(this.getDepth() / 2);
    }

    default public void fill(T t) {
        this.set(0, 0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1, t);
    }

    default public Hunk<T> viewFace(HunkFace f) {
        switch (f) {
            case BOTTOM: {
                return this.croppedView(0, 0, 0, this.getWidth() - 1, 0, this.getDepth() - 1);
            }
            case EAST: {
                return this.croppedView(this.getWidth() - 1, 0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1);
            }
            case NORTH: {
                return this.croppedView(0, 0, 0, this.getWidth() - 1, this.getHeight() - 1, 0);
            }
            case SOUTH: {
                return this.croppedView(0, 0, 0, 0, this.getHeight() - 1, this.getDepth() - 1);
            }
            case TOP: {
                return this.croppedView(0, this.getHeight() - 1, 0, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1);
            }
            case WEST: {
                return this.croppedView(0, 0, this.getDepth() - 1, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1);
            }
        }
        return null;
    }

    default public Hunk<T> cropFace(HunkFace f) {
        switch (f) {
            case BOTTOM: {
                return this.crop(0, 0, 0, this.getWidth() - 1, 0, this.getDepth() - 1);
            }
            case EAST: {
                return this.crop(this.getWidth() - 1, 0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1);
            }
            case NORTH: {
                return this.crop(0, 0, 0, this.getWidth() - 1, this.getHeight() - 1, 0);
            }
            case SOUTH: {
                return this.crop(0, 0, 0, 0, this.getHeight() - 1, this.getDepth() - 1);
            }
            case TOP: {
                return this.crop(0, this.getHeight() - 1, 0, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1);
            }
            case WEST: {
                return this.crop(0, 0, this.getDepth() - 1, this.getWidth() - 1, this.getHeight() - 1, this.getDepth() - 1);
            }
        }
        return null;
    }

    default public void set(int x, int y, int z, T t) {
        this.setRaw(x, y, z, t);
    }

    default public void setIfExists(int x, int y, int z, T t) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight() || z < 0 || z >= this.getDepth()) {
            return;
        }
        this.setRaw(x, y, z, t);
    }

    default public T getIfExists(int x, int y, int z, T t) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight() || z < 0 || z >= this.getDepth()) {
            return t;
        }
        return this.getOr(x, y, z, t);
    }

    default public T getIfExists(int x, int y, int z) {
        return this.getIfExists(x, y, z, null);
    }

    public void setRaw(int var1, int var2, int var3, T var4);

    public T getRaw(int var1, int var2, int var3);

    default public T get(int x, int y, int z) {
        return this.getRaw(x, y, z);
    }

    default public T getOr(int x, int y, int z, T t) {
        T v = this.getRaw(x, y, z);
        if (v == null) {
            return t;
        }
        return v;
    }

    default public void insert(int offX, int offY, int offZ, Hunk<T> hunk) {
        this.insert(offX, offY, offZ, hunk, false);
    }

    default public void insertSoftly(int offX, int offY, int offZ, Hunk<T> hunk, Predicate<T> shouldOverwrite) {
        this.insertSoftly(offX, offY, offZ, hunk, false, shouldOverwrite);
    }

    default public void insert(Hunk<T> hunk) {
        this.insert(0, 0, 0, hunk, false);
    }

    default public Hunk<T> getSource() {
        return null;
    }

    default public void insert(Hunk<T> hunk, boolean inverted) {
        this.insert(0, 0, 0, hunk, inverted);
    }

    default public void insert(int offX, int offY, int offZ, Hunk<T> hunk, boolean invertY) {
        for (int i = offX; i < offX + hunk.getWidth(); ++i) {
            for (int j = offY; j < offY + hunk.getHeight(); ++j) {
                for (int k = offZ; k < offZ + hunk.getDepth(); ++k) {
                    this.setRaw(i, j, k, hunk.getRaw(i - offX, j - offY, k - offZ));
                }
            }
        }
    }

    default public void insertSoftly(int offX, int offY, int offZ, Hunk<T> hunk, boolean invertY, Predicate<T> shouldOverwrite) {
        for (int i = offX; i < offX + hunk.getWidth(); ++i) {
            for (int j = offY; j < offY + hunk.getHeight(); ++j) {
                for (int k = offZ; k < offZ + hunk.getDepth(); ++k) {
                    if (!shouldOverwrite.test(this.getRaw(i, j, k))) continue;
                    this.setRaw(i, j, k, hunk.getRaw(i - offX, j - offY, k - offZ));
                }
            }
        }
    }

    default public void empty(T b) {
        this.fill(b);
    }

    default public Hunk<T> rotate(double x, double y, double z, Supplier3R<Integer, Integer, Integer, Hunk<T>> builder) {
        int w = this.getWidth();
        int h = this.getHeight();
        int d = this.getDepth();
        int[] c = new int[]{w / 2, h / 2, d / 2};
        int[] b = new int[]{0, 0, 0};
        int[] iii = new int[]{0, 0, 0};
        int[] aaa = new int[]{w, h, d};
        int[] aai = new int[]{w, h, 0};
        int[] iaa = new int[]{0, h, d};
        int[] aia = new int[]{w, 0, d};
        int[] iai = new int[]{0, h, 0};
        int[] iia = new int[]{0, 0, d};
        int[] aii = new int[]{w, 0, 0};
        Hunk.rotate(x, y, z, iii);
        Hunk.rotate(x, y, z, aaa);
        Hunk.rotate(x, y, z, aai);
        Hunk.rotate(x, y, z, iaa);
        Hunk.rotate(x, y, z, aia);
        Hunk.rotate(x, y, z, iai);
        Hunk.rotate(x, y, z, iia);
        Hunk.rotate(x, y, z, aii);
        int maxX = Hunk.max(iii[0], aaa[0], aai[0], iaa[0], aia[0], iai[0], iia[0], aii[0]);
        int minX = Hunk.min(iii[0], aaa[0], aai[0], iaa[0], aia[0], iai[0], iia[0], aii[0]);
        int maxY = Hunk.max(iii[1], aaa[1], aai[1], iaa[1], aia[1], iai[1], iia[1], aii[1]);
        int minY = Hunk.min(iii[1], aaa[1], aai[1], iaa[1], aia[1], iai[1], iia[1], aii[1]);
        int maxZ = Hunk.max(iii[2], aaa[2], aai[2], iaa[2], aia[2], iai[2], iia[2], aii[2]);
        int minZ = Hunk.min(iii[2], aaa[2], aai[2], iaa[2], aia[2], iai[2], iia[2], aii[2]);
        Hunk<T> r = builder.get(maxX - minX, maxY - minY, maxZ - minZ);
        int[] cr = new int[]{(maxX - minX) / 2, (maxY - minY) / 2, (maxZ - minZ) / 2};
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                for (int k = 0; k < d; ++k) {
                    b[0] = i - c[0];
                    b[1] = j - c[1];
                    b[2] = k - c[2];
                    Hunk.rotate(x, y, z, b);
                    try {
                        r.set(b[0] + cr[0], b[1] + cr[1], b[2] + cr[2], this.get(i, j, k));
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return r;
    }

    default public boolean isEmpty() {
        return false;
    }

    default public boolean contains(int x, int y, int z) {
        return x < this.getWidth() && x >= 0 && y < this.getHeight() && y >= 0 && z < this.getDepth() && z >= 0;
    }
}

