/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.google.common.util.concurrent.AtomicDoubleArray;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;

public class AtomicDoubleHunk
extends StorageHunk<Double>
implements Hunk<Double> {
    private final AtomicDoubleArray data;

    public AtomicDoubleHunk(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new AtomicDoubleArray(n * n2 * n3);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int n, int n2, int n3, Double d) {
        this.data.set(this.index(n, n2, n3), d.doubleValue());
    }

    @Override
    public Double getRaw(int n, int n2, int n3) {
        return this.data.get(this.index(n, n2, n3));
    }

    private int index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    public AtomicDoubleArray getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicDoubleHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AtomicDoubleHunk)) {
            return false;
        }
        AtomicDoubleHunk atomicDoubleHunk = (AtomicDoubleHunk)object;
        if (!atomicDoubleHunk.canEqual(this)) {
            return false;
        }
        AtomicDoubleArray atomicDoubleArray = this.getData();
        AtomicDoubleArray atomicDoubleArray2 = atomicDoubleHunk.getData();
        return !(atomicDoubleArray == null ? atomicDoubleArray2 != null : !atomicDoubleArray.equals(atomicDoubleArray2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof AtomicDoubleHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        AtomicDoubleArray atomicDoubleArray = this.getData();
        n2 = n2 * 59 + (atomicDoubleArray == null ? 43 : atomicDoubleArray.hashCode());
        return n2;
    }
}

