/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;

public abstract class StorageHunk<T>
implements Hunk<T> {
    private final int width;
    private final int height;
    private final int depth;

    public StorageHunk(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new RuntimeException("Unsupported size " + n + " " + n2 + " " + n3);
        }
        this.width = n;
        this.height = n2;
        this.depth = n3;
    }

    @Override
    public abstract void setRaw(int var1, int var2, int var3, T var4);

    @Override
    public abstract T getRaw(int var1, int var2, int var3);

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StorageHunk)) {
            return false;
        }
        StorageHunk storageHunk = (StorageHunk)object;
        if (!storageHunk.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != storageHunk.getWidth()) {
            return false;
        }
        if (this.getHeight() != storageHunk.getHeight()) {
            return false;
        }
        return this.getDepth() == storageHunk.getDepth();
    }

    protected boolean canEqual(Object object) {
        return object instanceof StorageHunk;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getWidth();
        n2 = n2 * 59 + this.getHeight();
        n2 = n2 * 59 + this.getDepth();
        return n2;
    }

    public String toString() {
        return "StorageHunk(width=" + this.getWidth() + ", height=" + this.getHeight() + ", depth=" + this.getDepth() + ")";
    }
}

