/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.view;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.util.Function;

public class FunctionalHunkView<R, T>
implements Hunk<T> {
    private final Hunk<R> src;
    private final Function.One<R, T> converter;
    private final Function.One<T, R> backConverter;

    public FunctionalHunkView(Hunk<R> hunk, Function.One<R, T> one, Function.One<T, R> one2) {
        this.src = hunk;
        this.converter = one;
        this.backConverter = one2;
    }

    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        if (this.backConverter == null) {
            throw new UnsupportedOperationException("You cannot write to this hunk (Read Only)");
        }
        this.src.setRaw(n, n2, n3, this.backConverter.apply(t));
    }

    @Override
    public T getRaw(int n, int n2, int n3) {
        if (this.converter == null) {
            throw new UnsupportedOperationException("You cannot read this hunk (Write Only)");
        }
        return this.converter.apply(this.src.getRaw(n, n2, n3));
    }

    @Override
    public int getWidth() {
        return this.src.getWidth();
    }

    @Override
    public int getDepth() {
        return this.src.getDepth();
    }

    @Override
    public int getHeight() {
        return this.src.getHeight();
    }

    @Override
    public Hunk<T> getSource() {
        throw new UnsupportedOperationException("You cannot read this hunk's source because it's a different type.");
    }
}

