/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.matter;

import com.volmit.adapt.util.arcane.spatial.container.DataPalette;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.util.IOAdapter;
import com.volmit.adapt.util.arcane.spatial.util.Varint;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class MatterPalette<T>
implements IOAdapter<T> {
    private final MatterSlice<T> slice;
    private final DataPalette<T> palette;

    public MatterPalette(MatterSlice<T> matterSlice) {
        this.slice = matterSlice;
        this.palette = new DataPalette();
    }

    public MatterPalette(MatterSlice<T> matterSlice, DataInputStream dataInputStream) {
        this.slice = matterSlice;
        this.palette = DataPalette.getPalette(this, dataInputStream);
    }

    public void writeNode(T t, DataOutputStream dataOutputStream) {
        Varint.writeUnsignedVarInt(this.palette.getIndex(t), dataOutputStream);
    }

    public T readNode(DataInputStream dataInputStream) {
        return this.palette.get(Varint.readUnsignedVarInt(dataInputStream));
    }

    public void writePalette(DataOutputStream dataOutputStream) {
        this.palette.write(this, dataOutputStream);
    }

    @Override
    public void write(T t, DataOutputStream dataOutputStream) {
        this.slice.writeNode(t, dataOutputStream);
    }

    @Override
    public T read(DataInputStream dataInputStream) {
        return this.slice.readNode(dataInputStream);
    }

    public void assign(T t) {
        this.palette.getIndex(t);
    }
}

