/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt;

import com.google.common.collect.Maps;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiExpansion
extends PlaceholderExpansion {
    private final Map<String, Function<PlayerSkillLine, String>> skillMap = Maps.newHashMap();
    private final Map<String, Function<PlayerData, String>> playerMap = Maps.newHashMap();
    private final Map<String, BiFunction<PlayerData, Adaptation<?>, String>> adaptationMap = Maps.newHashMap();

    public PapiExpansion() {
        this.skillMap.put("level", playerSkillLine -> String.valueOf(playerSkillLine.getLevel()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getLevel()));
        this.skillMap.put("knowledge", playerSkillLine -> String.valueOf(playerSkillLine.getKnowledge()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getKnowledge()));
        this.skillMap.put("xp", playerSkillLine -> String.format("%.2f", playerSkillLine.getXp()).equals("-5000.00") ? "0" : String.format("%.2f", playerSkillLine.getXp()));
        this.skillMap.put("freshness", playerSkillLine -> String.valueOf(playerSkillLine.getFreshness()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getFreshness()));
        this.skillMap.put("multiplier", playerSkillLine -> String.valueOf(playerSkillLine.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getMultiplier()));
        this.skillMap.put("name", playerSkillLine -> Localizer.dLocalize("skill", playerSkillLine.getLine(), "name"));
        this.playerMap.put("level", playerData -> String.valueOf(playerData.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerData.getLevel()));
        this.playerMap.put("multiplier", playerData -> String.valueOf(playerData.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerData.getMultiplier()));
        this.playerMap.put("availablepower", playerData -> String.valueOf(playerData.getAvailablePower()).equals("-5000") ? "0" : String.valueOf(playerData.getAvailablePower()));
        this.playerMap.put("maxpower", playerData -> String.valueOf(playerData.getMaxPower()).equals("-5000") ? "0" : String.valueOf(playerData.getMaxPower()));
        this.playerMap.put("usedpower", playerData -> String.valueOf(playerData.getUsedPower()).equals("-5000") ? "0" : String.valueOf(playerData.getUsedPower()));
        this.playerMap.put("wisdom", playerData -> String.valueOf(playerData.getWisdom()).equals("-5000") ? "0" : String.valueOf(playerData.getWisdom()));
        this.playerMap.put("masterxp", playerData -> String.valueOf(playerData.getMasterXp()).equals("-5000") ? "0" : String.valueOf(playerData.getMasterXp()));
        this.playerMap.put("seenthings", playerData -> String.valueOf(playerData.getSeenBlocks().getSeen().size() + playerData.getSeenBiomes().getSeen().size() + playerData.getSeenEnchants().getSeen().size() + playerData.getSeenEnvironments().getSeen().size() + playerData.getSeenFoods().getSeen().size() + playerData.getSeenItems().getSeen().size() + playerData.getSeenMobs().getSeen().size() + playerData.getSeenPeople().getSeen().size() + playerData.getSeenPotionEffects().getSeen().size() + playerData.getSeenRecipes().getSeen().size() + playerData.getSeenPotionEffects().getSeen().size() + playerData.getSeenWorlds().getSeen().size()));
        this.adaptationMap.put("maxlevel", (playerData, adaptation) -> String.valueOf(adaptation.getMaxLevel()));
        this.adaptationMap.put("level", (playerData, adaptation) -> String.valueOf(this.getAdaptionLevel((Adaptation<?>)adaptation, (PlayerData)playerData)));
        this.adaptationMap.put("name", (playerData, adaptation) -> String.valueOf(this.getAdaptionLocalizedName((Adaptation<?>)adaptation)));
    }

    private Integer getAdaptionLevel(Adaptation<?> adaptation, PlayerData playerData) {
        List<Skill<?>> list = Adapt.instance.getAdaptServer().getSkillRegistry().getSkills();
        for (Skill<?> skill : list) {
            List<Adaptation<?>> list2 = skill.getAdaptations();
            for (Adaptation<?> adaptation2 : list2) {
                if (!adaptation2.equals(adaptation)) continue;
                return playerData.getSkillLine(skill.getName()).getAdaptationLevel(adaptation.getName());
            }
        }
        return 0;
    }

    private String getAdaptionLocalizedName(Adaptation<?> adaptation) {
        List<Skill<?>> list = Adapt.instance.getAdaptServer().getSkillRegistry().getSkills();
        for (Skill<?> skill : list) {
            List<Adaptation<?>> list2 = skill.getAdaptations();
            for (Adaptation<?> adaptation2 : list2) {
                if (!adaptation2.equals(adaptation)) continue;
                return Localizer.dLocalize(skill.getId(), adaptation.getDisplayName(), "name");
            }
        }
        return "Unknown";
    }

    @NotNull
    public String getIdentifier() {
        return Adapt.instance.getDescription().getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", Adapt.instance.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return Adapt.instance.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String string) {
        Object object;
        Object object2;
        String string2;
        String[] stringArray = string.split("_");
        PlayerData playerData = Adapt.instance.getAdaptServer().peekData(offlinePlayer.getUniqueId());
        String string3 = stringArray[0];
        if (string3.equals("player")) {
            String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
            if (this.playerMap.containsKey(string2)) {
                return this.playerMap.get(string2).apply(playerData);
            }
        }
        if (string3.equals("skill")) {
            string2 = stringArray.length > 1 ? stringArray[1] : "";
            object2 = playerData.getSkillLine(string2);
            Object object3 = object = stringArray.length > 2 ? stringArray[2] : "";
            if (object2 != null && this.skillMap.containsKey(object)) {
                return this.skillMap.get(object).apply((PlayerSkillLine)object2);
            }
        }
        if (string3.equals("adaptation")) {
            string2 = stringArray.length > 1 ? stringArray[1] : "";
            object2 = stringArray.length > 2 ? stringArray[2] : "";
            Adapt.verbose("Triggered adaptation Lookup: " + string2 + " " + (String)object2);
            object = Adapt.instance.getAdaptServer().getSkillRegistry().getSkills();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Skill skill = (Skill)iterator.next();
                List<Adaptation<?>> list = skill.getAdaptations();
                for (Adaptation<?> adaptation : list) {
                    String string5 = adaptation.getId().substring(37);
                    Adapt.verbose(string2 + " " + string5);
                    if (!string5.equals(string2)) continue;
                    Adapt.verbose("Found adaptation: " + adaptation.getId());
                    if ("level".equalsIgnoreCase((String)object2)) {
                        Adapt.verbose("Doing Level Lookup");
                        return this.adaptationMap.get("level").apply(playerData, adaptation);
                    }
                    if ("maxlevel".equalsIgnoreCase((String)object2)) {
                        Adapt.verbose("Doing MaxLevel Lookup");
                        return this.adaptationMap.get("maxlevel").apply(playerData, adaptation);
                    }
                    if (!"name".equalsIgnoreCase((String)object2)) continue;
                    Adapt.verbose("Doing Name Lookup");
                    return this.adaptationMap.get("name").apply(playerData, adaptation);
                }
            }
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }
}

