/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.notification.ActionBarNotification;
import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Notifier
extends TickedObject {
    private final List<Notification> queue = new ArrayList<Notification>();
    private final AdaptPlayer target;
    private final Map<String, Long> lastSkills = new HashMap<String, Long>();
    private final Map<String, Double> lastSkillValues = new HashMap<String, Double>();
    private int busyTicks = 0;
    private int delayTicks = 0;
    private long lastInstance;

    public Notifier(AdaptPlayer adaptPlayer) {
        super("notifications", adaptPlayer.getPlayer().getUniqueId() + "-notify", 97L);
        this.target = adaptPlayer;
        this.lastInstance = 0L;
    }

    public void notifyXP(String string, double d) {
        try {
            if (!this.lastSkills.containsKey(string)) {
                this.lastSkillValues.put(string, 0.0);
            }
            this.lastSkills.put(string, M.ms());
            this.lastSkillValues.put(string, this.lastSkillValues.get(string) + d);
            this.lastInstance = M.ms();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : XList.reverse(XMap.sortKNumber(this.lastSkills))) {
                Skill<?> skill = this.getServer().getSkillRegistry().getSkill(string2);
                stringBuilder.append(string2.equals(string) ? skill.getDisplayName() : skill.getShortName()).append((Object)C.RESET).append((Object)C.GRAY).append(" +").append((Object)C.WHITE).append(string.equals(string2) ? C.UNDERLINE : "").append(Form.f(this.lastSkillValues.get(string2).intValue())).append((Object)C.RESET).append((Object)C.GRAY).append("XP ");
            }
            while (this.lastSkills.size() > 5) {
                String string3 = XList.reverse(XMap.sortKNumber(this.lastSkills)).get(0);
                this.lastSkills.remove(string3);
                this.lastSkillValues.remove(string3);
            }
            this.target.getActionBarNotifier().queue(ActionBarNotification.builder().duration(0L).maxTTL(M.ms() + 100L).title(stringBuilder.toString()).group("xp").build());
        }
        catch (Throwable throwable) {
            Adapt.verbose("Failed to notify xp: " + throwable.getMessage());
        }
    }

    public void queue(Notification ... notificationArray) {
        XList.add(this.queue, notificationArray);
    }

    public boolean isBusy() {
        return this.busyTicks > 1 || XList.isNotEmpty(this.queue);
    }

    @Override
    public void onTick() {
        Notification notification;
        this.cleanupSkills();
        if (this.busyTicks > 6) {
            this.busyTicks = 6;
        }
        if (this.busyTicks-- > 0) {
            return;
        }
        if (this.busyTicks < 0) {
            this.busyTicks = 0;
        }
        --this.delayTicks;
        if (this.delayTicks > 0) {
            return;
        }
        if (this.delayTicks < 0) {
            this.delayTicks = 0;
        }
        if (!this.isBusy()) {
            this.cleanupStackedNotifications();
        }
        if ((notification = XList.pop(this.queue)) == null) {
            return;
        }
        this.delayTicks = (int)((double)this.delayTicks + ((double)notification.getTotalDuration() / 50.0 + 1.0));
        Adapt.verbose("Playing Notification " + notification + " --> " + System.identityHashCode(this));
        notification.play(this.target);
    }

    private void cleanupStackedNotifications() {
    }

    private void cleanupSkills() {
        for (String string : XMap.k(this.lastSkills)) {
            if (this.lastSkills.get(string) == null) {
                return;
            }
            if (M.ms() - this.lastSkills.get(string) <= 10000L && (M.ms() - this.lastInstance <= 3100L || M.ms() - this.lastSkills.get(string) <= 3100L)) continue;
            this.lastSkills.remove(string);
            this.lastSkillValues.remove(string);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Notifier)) {
            return false;
        }
        Notifier notifier = (Notifier)object;
        if (!notifier.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getBusyTicks() != notifier.getBusyTicks()) {
            return false;
        }
        if (this.getDelayTicks() != notifier.getDelayTicks()) {
            return false;
        }
        if (this.getLastInstance() != notifier.getLastInstance()) {
            return false;
        }
        List<Notification> list = this.getQueue();
        List<Notification> list2 = notifier.getQueue();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        AdaptPlayer adaptPlayer = this.getTarget();
        AdaptPlayer adaptPlayer2 = notifier.getTarget();
        if (adaptPlayer == null ? adaptPlayer2 != null : !((Object)adaptPlayer).equals(adaptPlayer2)) {
            return false;
        }
        Map<String, Long> map = this.getLastSkills();
        Map<String, Long> map2 = notifier.getLastSkills();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        Map<String, Double> map3 = this.getLastSkillValues();
        Map<String, Double> map4 = notifier.getLastSkillValues();
        return !(map3 == null ? map4 != null : !((Object)map3).equals(map4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Notifier;
    }

    public int hashCode() {
        int n = 59;
        int n2 = super.hashCode();
        n2 = n2 * 59 + this.getBusyTicks();
        n2 = n2 * 59 + this.getDelayTicks();
        long l = this.getLastInstance();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        List<Notification> list = this.getQueue();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        AdaptPlayer adaptPlayer = this.getTarget();
        n2 = n2 * 59 + (adaptPlayer == null ? 43 : ((Object)adaptPlayer).hashCode());
        Map<String, Long> map = this.getLastSkills();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        Map<String, Double> map2 = this.getLastSkillValues();
        n2 = n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
        return n2;
    }

    public List<Notification> getQueue() {
        return this.queue;
    }

    public AdaptPlayer getTarget() {
        return this.target;
    }

    public Map<String, Long> getLastSkills() {
        return this.lastSkills;
    }

    public Map<String, Double> getLastSkillValues() {
        return this.lastSkillValues;
    }

    public int getBusyTicks() {
        return this.busyTicks;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    public long getLastInstance() {
        return this.lastInstance;
    }

    public void setBusyTicks(int n) {
        this.busyTicks = n;
    }

    public void setDelayTicks(int n) {
        this.delayTicks = n;
    }

    public void setLastInstance(long l) {
        this.lastInstance = l;
    }

    public String toString() {
        return "Notifier(queue=" + this.getQueue() + ", target=" + this.getTarget() + ", lastSkills=" + this.getLastSkills() + ", lastSkillValues=" + this.getLastSkillValues() + ", busyTicks=" + this.getBusyTicks() + ", delayTicks=" + this.getDelayTicks() + ", lastInstance=" + this.getLastInstance() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

