/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.notification.AdvancementNotification;
import com.volmit.adapt.api.notification.Notifier;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdvancementHandler;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.ChronoLatch;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RollingSequence;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class AdaptPlayer
extends TickedObject {
    private final Player player;
    private final PlayerData data;
    private ChronoLatch savelatch;
    private ChronoLatch updatelatch;
    private Notifier not;
    private Notifier actionBarNotifier;
    private AdvancementHandler advancementHandler;
    private RollingSequence speed;
    private long lastloc;
    private Vector velocity;
    private Location lastpos;

    public AdaptPlayer(Player player) {
        super("players", player.getUniqueId().toString(), 50L);
        this.player = player;
        this.data = this.loadPlayerData();
        this.updatelatch = new ChronoLatch(1000L);
        this.savelatch = new ChronoLatch(60000L);
        this.not = new Notifier(this);
        this.actionBarNotifier = new Notifier(this);
        this.advancementHandler = new AdvancementHandler(this);
        this.speed = new RollingSequence(7);
        this.lastloc = M.ms();
        this.getAdvancementHandler().activate();
        this.velocity = new Vector();
    }

    public boolean canConsumeFood(double d, int n) {
        return (double)((float)this.player.getFoodLevel() + this.player.getSaturation() - (float)n) > d;
    }

    public boolean consumeFood(double d, int n) {
        if (this.canConsumeFood(d, n)) {
            int n2 = this.player.getFoodLevel();
            double d2 = this.player.getSaturation();
            if (d2 >= d) {
                d2 = (double)this.player.getSaturation() - d;
                d = 0.0;
            } else if (this.player.getSaturation() > 0.0f) {
                d -= d2;
                d2 = 0.0;
            }
            if (d >= 1.0) {
                n2 -= (int)Math.floor(d);
                d = Math.floor(d);
            }
            if (d > 0.0) {
                if (d2 >= d) {
                    d2 -= d;
                    d = 0.0;
                } else {
                    d2 += 1.0;
                    --n2;
                }
            }
            if (d2 >= d && d > 0.0) {
                d2 -= d;
                d = 0.0;
            }
            this.player.setFoodLevel(n2);
            this.player.setSaturation((float)d2);
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.not.isBusy();
    }

    public PlayerSkillLine getSkillLine(String string) {
        return this.getData().getSkillLine(string);
    }

    private void save() {
        UUID uUID = this.player.getUniqueId();
        String string = new Gson().toJson((Object)this.data);
        if (Adapt.instance.getSqlManager().useSql()) {
            Adapt.instance.getSqlManager().updateData(uUID, string);
        } else {
            IO.writeAll(this.getPlayerDataFile(uUID), new JSONObject(string).toString(4));
        }
    }

    private void unSave() {
        UUID uUID = this.player.getUniqueId();
        String string = new Gson().toJson((Object)new PlayerData());
        this.unregister();
        if (Adapt.instance.getSqlManager().useSql()) {
            Adapt.instance.getSqlManager().updateData(uUID, string);
        } else {
            IO.writeAll(this.getPlayerDataFile(uUID), new JSONObject(string).toString(4));
        }
    }

    @Override
    public void unregister() {
        super.unregister();
        this.getAdvancementHandler().deactivate();
        this.save();
    }

    public void delete(UUID uUID) {
        File file = this.getPlayerDataFile(this.player.getUniqueId());
        Adapt.warn("Deleting Player Data: " + file.getAbsolutePath());
        Player player = this.player;
        J.s(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            player.kickPlayer("Your data has been deleted.");
            if (file.exists()) {
                file.delete();
                this.unSave();
                file.delete();
                this.save();
                file.delete();
                this.unSave();
            }
            if (Adapt.instance.getSqlManager().useSql()) {
                Adapt.instance.getSqlManager().delete(uUID);
            }
        });
    }

    private PlayerData loadPlayerData() {
        Object object;
        boolean bl = false;
        if (Adapt.instance.getSqlManager().useSql()) {
            object = Adapt.instance.getSqlManager().fetchData(this.player.getUniqueId());
            if (object != null) {
                return (PlayerData)new Gson().fromJson((String)object, PlayerData.class);
            }
            bl = true;
        }
        if (((File)(object = this.getPlayerDataFile(this.player.getUniqueId()))).exists()) {
            try {
                String string = IO.readAll((File)object);
                if (bl) {
                    Adapt.instance.getSqlManager().updateData(this.player.getUniqueId(), string);
                }
                return (PlayerData)new Gson().fromJson(string, PlayerData.class);
            }
            catch (Throwable throwable) {
                Adapt.verbose("Failed to load player data for " + this.player.getName() + " (" + this.player.getUniqueId() + ")");
            }
        }
        return new PlayerData();
    }

    @Override
    public void onTick() {
        if (this.updatelatch.flip()) {
            this.getData().update(this);
        }
        if (this.savelatch.flip()) {
            this.save();
        }
        this.getServer().takeSpatial(this);
        Location location = this.player.getLocation();
        if (this.lastpos != null && this.lastpos.getWorld().equals(location.getWorld()) && this.lastpos.distanceSquared(location) <= 49.0) {
            this.speed.put(this.lastpos.distance(location) / ((double)(M.ms() - this.lastloc) / 50.0));
            this.velocity = this.velocity.clone().add(location.clone().subtract(this.lastpos).toVector()).multiply(0.5);
            this.velocity.setX(Math.abs(this.velocity.getX()) < 0.01 ? 0.0 : this.velocity.getX());
            this.velocity.setY(Math.abs(this.velocity.getY()) < 0.01 ? 0.0 : this.velocity.getY());
            this.velocity.setZ(Math.abs(this.velocity.getZ()) < 0.01 ? 0.0 : this.velocity.getZ());
        }
        this.lastpos = location.clone();
        this.lastloc = M.ms();
    }

    public double getSpeed() {
        return this.speed.getAverage();
    }

    public boolean hasAdaptation(String string) {
        String string2 = string.split("-")[0];
        Adapt.verbose("Checking for adaptation " + string + " in skill line " + string2);
        if (string2 == null) {
            return false;
        }
        PlayerSkillLine playerSkillLine = this.getData().getSkillLine(string2);
        Adapt.verbose("Found skill line " + playerSkillLine);
        if (playerSkillLine.getAdaptation(string) == null || playerSkillLine.getAdaptation(string).getLevel() == 0) {
            Adapt.verbose("Adaptation " + string + " not found or level 0");
            return false;
        }
        return playerSkillLine.getAdaptation(string).getLevel() > 0;
    }

    public void giveXPToRecents(AdaptPlayer adaptPlayer, double d, int n) {
        for (PlayerSkillLine playerSkillLine : XMap.v(adaptPlayer.getData().getSkillLines())) {
            if (M.ms() - playerSkillLine.getLast() >= (long)n) continue;
            playerSkillLine.giveXP(this.not, d);
        }
    }

    public void giveXPToRandom(AdaptPlayer adaptPlayer, double d) {
        XList.getRandom(XMap.v(adaptPlayer.getData().getSkillLines())).giveXP(adaptPlayer.getNot(), d);
    }

    public void boostXPToRandom(AdaptPlayer adaptPlayer, double d, int n) {
        XList.getRandom(XMap.v(adaptPlayer.getData().getSkillLines())).boost(d, n);
    }

    public void boostXPToRecents(double d, int n) {
        for (PlayerSkillLine playerSkillLine : XMap.v(this.getData().getSkillLines())) {
            if (M.ms() - playerSkillLine.getLast() >= (long)n) continue;
            playerSkillLine.boost(d, n);
        }
    }

    public void loggedIn() {
        if (AdaptConfig.get().isLoginBonus()) {
            long l = M.ms() - this.getData().getLastLogin();
            boolean bl = this.getData().getLastLogin() == 0L;
            this.getData().setLastLogin(M.ms());
            long l2 = (long)Math.min((double)l / 12.0, (double)TimeUnit.HOURS.toMillis(1L));
            if (l2 < TimeUnit.MINUTES.toMillis(5L)) {
                return;
            }
            double d = M.lerp(0.1, 0.25, (double)l2 / (double)TimeUnit.HOURS.toMillis(1L));
            this.getData().globalXPMultiplier(d, (int)l2);
            this.getNot().queue(AdvancementNotification.builder().title(bl ? Localizer.dLocalize("snippets", "gui", "welcome") : Localizer.dLocalize("snippets", "gui", "welcomeback")).description("+" + C.GREEN + Form.pc(d, 0) + C.GRAY + " " + Localizer.dLocalize("snippets", "gui", "xpbonusfortime") + " " + C.AQUA + Form.duration(l2, 0)).build());
        }
    }

    public boolean hasSkill(Skill skill) {
        return this.getData().getSkillLines().containsKey(skill.getName()) && this.getData().getSkillLines().get(skill.getId()).getXp() > 1.0;
    }

    private File getPlayerDataFile(UUID uUID) {
        return new File(Adapt.instance.getDataFolder("data", "players"), uUID.toString() + ".json");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdaptPlayer)) {
            return false;
        }
        AdaptPlayer adaptPlayer = (AdaptPlayer)object;
        if (!adaptPlayer.canEqual(this)) {
            return false;
        }
        if (this.getLastloc() != adaptPlayer.getLastloc()) {
            return false;
        }
        Player player = this.getPlayer();
        Player player2 = adaptPlayer.getPlayer();
        if (player == null ? player2 != null : !player.equals(player2)) {
            return false;
        }
        PlayerData playerData = this.getData();
        PlayerData playerData2 = adaptPlayer.getData();
        if (playerData == null ? playerData2 != null : !((Object)playerData).equals(playerData2)) {
            return false;
        }
        ChronoLatch chronoLatch = this.getSavelatch();
        ChronoLatch chronoLatch2 = adaptPlayer.getSavelatch();
        if (chronoLatch == null ? chronoLatch2 != null : !chronoLatch.equals(chronoLatch2)) {
            return false;
        }
        ChronoLatch chronoLatch3 = this.getUpdatelatch();
        ChronoLatch chronoLatch4 = adaptPlayer.getUpdatelatch();
        if (chronoLatch3 == null ? chronoLatch4 != null : !chronoLatch3.equals(chronoLatch4)) {
            return false;
        }
        Notifier notifier = this.getNot();
        Notifier notifier2 = adaptPlayer.getNot();
        if (notifier == null ? notifier2 != null : !((Object)notifier).equals(notifier2)) {
            return false;
        }
        Notifier notifier3 = this.getActionBarNotifier();
        Notifier notifier4 = adaptPlayer.getActionBarNotifier();
        if (notifier3 == null ? notifier4 != null : !((Object)notifier3).equals(notifier4)) {
            return false;
        }
        AdvancementHandler advancementHandler = this.getAdvancementHandler();
        AdvancementHandler advancementHandler2 = adaptPlayer.getAdvancementHandler();
        if (advancementHandler == null ? advancementHandler2 != null : !((Object)advancementHandler).equals(advancementHandler2)) {
            return false;
        }
        if (Double.compare(this.getSpeed(), adaptPlayer.getSpeed()) != 0) {
            return false;
        }
        Vector vector = this.getVelocity();
        Vector vector2 = adaptPlayer.getVelocity();
        if (vector == null ? vector2 != null : !vector.equals(vector2)) {
            return false;
        }
        Location location = this.getLastpos();
        Location location2 = adaptPlayer.getLastpos();
        return !(location == null ? location2 != null : !location.equals(location2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof AdaptPlayer;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getLastloc();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        Player player = this.getPlayer();
        n2 = n2 * 59 + (player == null ? 43 : player.hashCode());
        PlayerData playerData = this.getData();
        n2 = n2 * 59 + (playerData == null ? 43 : ((Object)playerData).hashCode());
        ChronoLatch chronoLatch = this.getSavelatch();
        n2 = n2 * 59 + (chronoLatch == null ? 43 : chronoLatch.hashCode());
        ChronoLatch chronoLatch2 = this.getUpdatelatch();
        n2 = n2 * 59 + (chronoLatch2 == null ? 43 : chronoLatch2.hashCode());
        Notifier notifier = this.getNot();
        n2 = n2 * 59 + (notifier == null ? 43 : ((Object)notifier).hashCode());
        Notifier notifier2 = this.getActionBarNotifier();
        n2 = n2 * 59 + (notifier2 == null ? 43 : ((Object)notifier2).hashCode());
        AdvancementHandler advancementHandler = this.getAdvancementHandler();
        n2 = n2 * 59 + (advancementHandler == null ? 43 : ((Object)advancementHandler).hashCode());
        long l2 = Double.doubleToLongBits(this.getSpeed());
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        Vector vector = this.getVelocity();
        n2 = n2 * 59 + (vector == null ? 43 : vector.hashCode());
        Location location = this.getLastpos();
        n2 = n2 * 59 + (location == null ? 43 : location.hashCode());
        return n2;
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerData getData() {
        return this.data;
    }

    public ChronoLatch getSavelatch() {
        return this.savelatch;
    }

    public ChronoLatch getUpdatelatch() {
        return this.updatelatch;
    }

    public Notifier getNot() {
        return this.not;
    }

    public Notifier getActionBarNotifier() {
        return this.actionBarNotifier;
    }

    public AdvancementHandler getAdvancementHandler() {
        return this.advancementHandler;
    }

    public long getLastloc() {
        return this.lastloc;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public Location getLastpos() {
        return this.lastpos;
    }

    public void setSavelatch(ChronoLatch chronoLatch) {
        this.savelatch = chronoLatch;
    }

    public void setUpdatelatch(ChronoLatch chronoLatch) {
        this.updatelatch = chronoLatch;
    }

    public void setNot(Notifier notifier) {
        this.not = notifier;
    }

    public void setActionBarNotifier(Notifier notifier) {
        this.actionBarNotifier = notifier;
    }

    public void setAdvancementHandler(AdvancementHandler advancementHandler) {
        this.advancementHandler = advancementHandler;
    }

    public void setSpeed(RollingSequence rollingSequence) {
        this.speed = rollingSequence;
    }

    public void setLastloc(long l) {
        this.lastloc = l;
    }

    public void setVelocity(Vector vector) {
        this.velocity = vector;
    }

    public void setLastpos(Location location) {
        this.lastpos = location;
    }

    public String toString() {
        return "AdaptPlayer(player=" + this.getPlayer() + ", data=" + this.getData() + ", savelatch=" + this.getSavelatch() + ", updatelatch=" + this.getUpdatelatch() + ", not=" + this.getNot() + ", actionBarNotifier=" + this.getActionBarNotifier() + ", advancementHandler=" + this.getAdvancementHandler() + ", speed=" + this.getSpeed() + ", lastloc=" + this.getLastloc() + ", velocity=" + this.getVelocity() + ", lastpos=" + this.getLastpos() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

