/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.notification.AdvancementNotification;
import com.volmit.adapt.api.notification.SoundNotification;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.skill.SkillRegistry;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptServerData;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.xp.SpatialXP;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.content.item.ExperienceOrb;
import com.volmit.adapt.content.item.KnowledgeOrb;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class AdaptServer
extends TickedObject {
    private final Map<Player, AdaptPlayer> players;
    private final List<SpatialXP> spatialTickets;
    private SkillRegistry skillRegistry;
    private AdaptServerData data = new AdaptServerData();

    public AdaptServer() {
        super("core", UUID.randomUUID().toString(), 1000L);
        this.spatialTickets = new ArrayList<SpatialXP>();
        this.players = new HashMap<Player, AdaptPlayer>();
        this.load();
        this.skillRegistry = new SkillRegistry();
        Bukkit.getOnlinePlayers().forEach(this::join);
    }

    public void offer(SpatialXP spatialXP) {
        if (spatialXP == null || spatialXP.getSkill() == null || spatialXP.getRadius() > 0.0 || spatialXP.getMs() > 0L || spatialXP.getLocation() == null) {
            return;
        }
        this.spatialTickets.add(spatialXP);
    }

    public void takeSpatial(AdaptPlayer adaptPlayer) {
        J.attempt(() -> {
            double d;
            Optional optional = this.spatialTickets.stream().findAny();
            if (optional.isEmpty()) {
                return;
            }
            SpatialXP spatialXP = (SpatialXP)optional.get();
            if (M.ms() > spatialXP.getMs()) {
                this.spatialTickets.remove(spatialXP);
                return;
            }
            if (!adaptPlayer.getPlayer().getClass().getSimpleName().equals("CraftPlayer")) {
                this.spatialTickets.remove(spatialXP);
                return;
            }
            if (adaptPlayer.getPlayer().getWorld().equals(spatialXP.getLocation().getWorld()) && (d = adaptPlayer.getPlayer().getLocation().distanceSquared(spatialXP.getLocation())) < spatialXP.getRadius() * spatialXP.getRadius()) {
                double d2 = M.lerpInverse(0.0, spatialXP.getRadius() * spatialXP.getRadius(), d);
                double d3 = spatialXP.getXp() / (1.5 * (d2 * 9.0 + 1.0));
                spatialXP.setXp(spatialXP.getXp() - d3);
                if (spatialXP.getXp() < 10.0) {
                    d3 += spatialXP.getXp();
                    this.spatialTickets.remove(spatialXP);
                }
                XP.xp(adaptPlayer, spatialXP.getSkill(), d3);
            }
        });
    }

    public void join(Player player) {
        AdaptPlayer adaptPlayer = new AdaptPlayer(player);
        this.players.put(player, adaptPlayer);
        adaptPlayer.loggedIn();
    }

    public void quit(Player player) {
        Optional.ofNullable(this.players.remove(player)).ifPresent(AdaptPlayer::unregister);
    }

    @Override
    public void unregister() {
        new HashSet<Player>(this.players.keySet()).forEach(this::quit);
        this.skillRegistry.unregister();
        this.save();
        super.unregister();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(ProjectileLaunchEvent projectileLaunchEvent) {
        Object object = projectileLaunchEvent.getEntity();
        if (object instanceof Snowball) {
            Snowball snowball = (Snowball)object;
            object = projectileLaunchEvent.getEntity().getShooter();
            if (object instanceof Player) {
                Player player = (Player)object;
                object = KnowledgeOrb.get(snowball.getItem());
                if (object != null) {
                    Skill<?> skill = this.getSkillRegistry().getSkill(((KnowledgeOrb.Data)object).getSkill());
                    ((KnowledgeOrb.Data)object).apply(player);
                    SoundNotification.builder().sound(Sound.ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM).volume(0.35f).pitch(1.455f).build().play(this.getPlayer(player));
                    SoundNotification.builder().sound(Sound.ENTITY_SHULKER_OPEN).volume(1.0f).pitch(1.655f).build().play(this.getPlayer(player));
                    this.getPlayer(player).getNot().queue(AdvancementNotification.builder().icon(Material.BOOK).title(C.GRAY + "+ " + C.WHITE + ((KnowledgeOrb.Data)object).getKnowledge() + " " + skill.getDisplayName() + " Knowledge").build());
                    projectileLaunchEvent.setCancelled(false);
                    projectileLaunchEvent.getEntity().setVelocity(projectileLaunchEvent.getEntity().getVelocity().multiply(1000));
                } else {
                    ExperienceOrb.Data data = ExperienceOrb.get(snowball.getItem());
                    if (data != null) {
                        data.apply(player);
                        SoundNotification.builder().sound(Sound.ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM).volume(0.35f).pitch(1.455f).build().play(this.getPlayer(player));
                        SoundNotification.builder().sound(Sound.ENTITY_SHULKER_OPEN).volume(1.0f).pitch(1.655f).build().play(this.getPlayer(player));
                        projectileLaunchEvent.setCancelled(false);
                        projectileLaunchEvent.getEntity().setVelocity(projectileLaunchEvent.getEntity().getVelocity().multiply(1000));
                    }
                }
            }
        }
    }

    @EventHandler
    public void on(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        this.join(player);
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.quit(player);
    }

    @EventHandler
    public void on(CraftItemEvent craftItemEvent) {
        HumanEntity humanEntity = craftItemEvent.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            for (Skill skill : this.getSkillRegistry().getSkills()) {
                for (Adaptation<?> adaptation : skill.getAdaptations()) {
                    if (!adaptation.isAdaptationRecipe(craftItemEvent.getRecipe()) || adaptation.hasAdaptation(player)) continue;
                    Adapt.actionbar(player, C.RED + "Requires " + adaptation.getDisplayName() + C.RED + " from " + skill.getDisplayName());
                    player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.5f, 1.8f);
                    craftItemEvent.setCancelled(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTick() {
        List<SpatialXP> list = this.spatialTickets;
        synchronized (list) {
            for (int i = 0; i < this.spatialTickets.size(); ++i) {
                if (M.ms() <= this.spatialTickets.get(i).getMs()) continue;
                this.spatialTickets.remove(i);
            }
        }
    }

    public PlayerData peekData(UUID uUID) {
        Object object;
        if (Bukkit.getPlayer((UUID)uUID) != null) {
            return this.getPlayer(Bukkit.getPlayer((UUID)uUID)).getData();
        }
        if (Adapt.instance.getSqlManager().useSql() && (object = Adapt.instance.getSqlManager().fetchData(uUID)) != null) {
            return (PlayerData)new Gson().fromJson((String)object, PlayerData.class);
        }
        object = new File(Adapt.instance.getDataFolder("data", "players"), uUID + ".json");
        if (((File)object).exists()) {
            try {
                return (PlayerData)new Gson().fromJson(IO.readAll((File)object), PlayerData.class);
            }
            catch (Throwable throwable) {
                Adapt.verbose("Failed to load player data for " + uUID);
            }
        }
        return new PlayerData();
    }

    @Override
    public AdaptPlayer getPlayer(Player player) {
        return this.players.get(player);
    }

    public void openSkillGUI(Skill<?> skill, Player player) {
        skill.openGui(player);
    }

    public void openAdaptGui(Player player) {
        SkillsGui.open(player);
    }

    public void openAdaptationGUI(Adaptation<?> adaptation, Player player) {
        adaptation.openGui(player);
    }

    public void boostXP(double d, int n) {
        this.data.getMultipliers().add(new XPMultiplier(d, n));
    }

    public void load() {
        File file = new File(Adapt.instance.getDataFolder("data"), "server-data.json");
        if (file.exists()) {
            try {
                String string = IO.readAll(file);
                this.data = (AdaptServerData)new Gson().fromJson(string, AdaptServerData.class);
            }
            catch (Throwable throwable) {
                Adapt.verbose("Failed to load global boosts data");
            }
        }
    }

    public void save() {
        IO.writeAll(new File(Adapt.instance.getDataFolder("data"), "server-data.json"), new JSONObject(this.data).toString(4));
    }

    public List<SpatialXP> getSpatialTickets() {
        return this.spatialTickets;
    }

    public SkillRegistry getSkillRegistry() {
        return this.skillRegistry;
    }

    public AdaptServerData getData() {
        return this.data;
    }

    static {
        IBootstrap.dasBoot();
    }
}

