/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.xp;

import com.volmit.adapt.api.xp.NewtonCurve;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.function.Function;

public enum Curves {
    QLOG(Curves.resolved(d -> Math.pow(d, 2.0) * Math.log(d), d -> Math.sqrt(d / Math.log(d)), 0.001)),
    ELIN(Curves.resolved(d -> 1000.0 * Math.exp(0.001 * d), d -> Math.log(d / 1000.0) / 0.001, 0.001)),
    CUBRT(Curves.resolved(d -> Math.pow(d, 0.3333333333333333), d -> Math.pow(d, 3.0), 0.001)),
    HYPER(Curves.resolved(d -> 1000.0 / (2.0 - d), d -> 2.0 - 1000.0 / d, 0.001)),
    SIGM(Curves.resolved(d -> 1000.0 / (1.0 + Math.exp(-0.01 * (d - 50.0))), d -> 50.0 + Math.log(d / (1000.0 - d)) / -0.01, 0.001)),
    X1D2(Curves.resolved(d -> Math.pow(d, 1.2), d -> Math.pow(d, 0.8333333333333334), 0.001)),
    X1D5(Curves.resolved(d -> Math.pow(d, 1.5), d -> Math.pow(d, 0.6666666666666666), 0.001)),
    X2(Curves.resolved(d -> Math.pow(d, 2.0), d -> Math.pow(d, 0.5), 0.001)),
    X3(Curves.resolved(d -> Math.pow(d, 3.0), d -> Math.pow(d, 0.3333333333333333), 0.001)),
    X4(Curves.resolved(d -> Math.pow(d, 4.0), d -> Math.pow(d, 0.25), 0.001)),
    X5(Curves.resolved(d -> Math.pow(d, 5.0), d -> Math.pow(d, 0.2), 0.001)),
    X6(Curves.resolved(d -> Math.pow(d, 6.0), d -> Math.pow(d, 0.16666666666666666), 0.001)),
    X7(Curves.resolved(d -> Math.pow(d, 7.0), d -> Math.pow(d, 0.14285714285714285), 0.001)),
    L1K(Curves.resolved(d -> d * 1000.0, d -> d / 1000.0, 0.001)),
    L4K(Curves.resolved(d -> d * 4000.0, d -> d / 4000.0, 0.001)),
    L8K(Curves.resolved(d -> d * 8000.0, d -> d / 8000.0, 0.001)),
    L16K(Curves.resolved(d -> d * 16000.0, d -> d / 16000.0, 0.001)),
    SKYRIM(SkyrimNewtonCurve.create()),
    WOW(WOWNewtonCurve.create()),
    XL05L7(d -> (537.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL1L7(d -> (1337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL15L7(d -> (1837.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL2L7(d -> (2337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL3L7(d -> (3337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL4L7(d -> (4337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL5L7(d -> (5337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL6L7(d -> (6337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL7L7(d -> (7337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL8L7(d -> (8337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL9L7(d -> (9337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL20L7(d -> (20337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL40L7(d -> (40337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL80L7(d -> (80337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL160L7(d -> (160337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    XL100L7(d -> (1000337.0 * d + Math.pow(d * 0.95, Math.PI)) / 1.137),
    LINEAR_EXPONENTIAL_1(Curves.resolved(d -> 1000.0 * d + 100.0 * Math.pow(d, 2.0), d -> {
        double d2 = 1000.0;
        double d3 = 100.0;
        return (-d2 + Math.sqrt(d2 * d2 + 4.0 * d3 * d)) / (2.0 * d3);
    }, 0.001)),
    LINEAR_EXPONENTIAL_2(Curves.resolved(d -> 2000.0 * d + 50.0 * Math.pow(d, 2.5), d -> {
        double d2 = 2000.0;
        double d3 = 50.0;
        double d4 = (-d2 + Math.sqrt(d2 * d2 + 4.0 * d3 * d)) / (2.0 * d3);
        return Math.pow((d - d2 * d4) / d3, 0.4);
    }, 0.001)),
    LINEAR_EXPONENTIAL_3(Curves.resolved(d -> 500.0 * d + 200.0 * Math.pow(d, 1.5), d -> {
        double d2 = 500.0;
        double d3 = 200.0;
        double d4 = (-d2 + Math.sqrt(d2 * d2 + 4.0 * d3 * d)) / (2.0 * d3);
        return Math.pow((d - d2 * d4) / d3, 0.6666666666666666);
    }, 0.001));

    private final NewtonCurve curve;

    private Curves(NewtonCurve newtonCurve) {
        this.curve = newtonCurve;
    }

    private static NewtonCurve resolved(final Function<Double, Double> function, final Function<Double, Double> function2, double d) {
        return new NewtonCurve(){

            @Override
            public double getXPForLevel(double d) {
                return (Double)function.apply(d);
            }

            @Override
            public double computeLevelForXP(double d, double d2) {
                return (Double)function2.apply(d);
            }
        };
    }

    public NewtonCurve getCurve() {
        return this.curve;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class SkyrimNewtonCurve {
        public static NewtonCurve create() {
            Function<Double, Double> function = d -> {
                double d2 = 0.0;
                int n = 1;
                while ((double)n < d) {
                    d2 += SkyrimNewtonCurve.getNextLevelCost(n);
                    ++n;
                }
                return d2;
            };
            Function<Double, Double> function2 = d -> {
                double d2 = 1.0;
                while (d.compareTo(SkyrimNewtonCurve.getNextLevelCost(d2)) >= 0) {
                    d = d - SkyrimNewtonCurve.getNextLevelCost(d2);
                    d2 += 1.0;
                }
                return d2;
            };
            return Curves.resolved(function, function2, 0.001);
        }

        private static double getNextLevelCost(double d) {
            return Math.pow(d - 1.0, 1.95) + 300.0;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public class WOWNewtonCurve {
        public static NewtonCurve create() {
            Function<Double, Double> function = d -> {
                double d2 = 0.0;
                int n = 1;
                while ((double)n < d) {
                    d2 += WOWNewtonCurve.getNextLevelCost(n);
                    ++n;
                }
                return d2;
            };
            Function<Double, Double> function2 = d -> {
                double d2 = 1.0;
                while (d.compareTo(WOWNewtonCurve.getNextLevelCost(d2)) >= 0) {
                    d = d - WOWNewtonCurve.getNextLevelCost(d2);
                    d2 += 1.0;
                }
                return d2;
            };
            return Curves.resolved(function, function2, 0.001);
        }

        private static double getNextLevelCost(double d) {
            return (8.0 * d + WOWNewtonCurve.getDiff(d)) * WOWNewtonCurve.getMXP(d) * WOWNewtonCurve.getDRF(d);
        }

        private static double getMXP(double d) {
            return 235.0 + 5.0 * d;
        }

        private static double getDRF(double d) {
            if (d >= 11.0 && d <= 27.0) {
                return 1.0 - (d - 10.0) / 100.0;
            }
            if (d >= 28.0 && d <= 59.0) {
                return 0.82;
            }
            return 1.0;
        }

        private static double getDiff(double d) {
            if (d <= 28.0) {
                return 0.0;
            }
            if (d == 29.0) {
                return 1.0;
            }
            if (d == 30.0) {
                return 3.0;
            }
            if (d == 31.0) {
                return 6.0;
            }
            return 5.0 * (Math.min(d, 59.0) - 30.0);
        }
    }
}

