/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.command.item;

import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.skill.SkillRegistry;
import com.volmit.adapt.content.item.ExperienceOrb;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.FConst;
import com.volmit.adapt.util.command.suggest.AdaptSkillListingProvider;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.github.mqzn.commands.annotations.base.Arg;
import io.github.mqzn.commands.annotations.base.Default;
import io.github.mqzn.commands.annotations.base.ExecutionMeta;
import io.github.mqzn.commands.annotations.base.Range;
import io.github.mqzn.commands.annotations.base.Suggest;
import io.github.mqzn.commands.annotations.subcommands.SubCommandExecution;
import io.github.mqzn.commands.annotations.subcommands.SubCommandInfo;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@SubCommandInfo(name="experience")
@ExecutionMeta(description="Give yourself an experience orb", syntax="<skillname> <amount> [player]", permission="adapt.cheatitem")
public final class CommandExperience {
    @SubCommandExecution
    public void execute(CommandSender commandSender, @Arg(id="skillname") @Suggest(provider=AdaptSkillListingProvider.class) String string, @Arg(id="amount") @Range(min="1", max="100000") int n, @Arg(id="player", optional=true) @Nullable Player player) {
        Object object;
        Player player2 = player;
        if (player2 == null) {
            if (commandSender instanceof Player) {
                object = (Player)commandSender;
                player2 = object;
            } else {
                FConst.error("You must be a player to use this command, or Reference a player", new Object[0]).send(commandSender);
                return;
            }
        }
        if (string.equals("[all]")) {
            for (Skill skill : XMap.sortV(SkillRegistry.skills)) {
                player2.getInventory().addItem(new ItemStack[]{ExperienceOrb.with(skill.getName(), n)});
            }
            FConst.success("Giving all orbs", new Object[0]).send(commandSender);
            return;
        }
        if (string.equals("[random]")) {
            player2.getInventory().addItem(new ItemStack[]{ExperienceOrb.with(XList.getRandom(XMap.sortV(SkillRegistry.skills)).getName(), n)});
            FConst.success("Giving random orb", new Object[0]).send(commandSender);
            return;
        }
        object = SkillRegistry.skills.get(string);
        if (object != null) {
            player2.getInventory().addItem(new ItemStack[]{ExperienceOrb.with(object.getName(), n)});
            FConst.success("Giving " + object.getName() + " orb", new Object[0]).send(commandSender);
        }
    }

    @Default
    public void info(CommandSender commandSender) {
        FConst.success(" --- === " + C.GRAY + "[" + C.DARK_RED + "Adapt Item Help" + C.GRAY + "]:  === ---", new Object[0]);
        FConst.info("/adapt item (this command)", new Object[0]).send(commandSender);
        FConst.info("/adapt item experience <Skill> <Amount> [Player]", new Object[0]).send(commandSender);
        FConst.info("/adapt item knowledge <Skill> <Amount> [Player]", new Object[0]).send(commandSender);
    }

    static {
        IBootstrap.dasBoot();
    }
}

