/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.agility;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class AgilityWindUp
extends SimpleAdaptation<Config> {
    private final Map<Player, Integer> ticksRunning;

    public AgilityWindUp() {
        super("agility-wind-up");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("agility", "windup", "description"));
        this.setDisplayName(Localizer.dLocalize("agility", "windup", "name"));
        this.setIcon(Material.POWERED_RAIL);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(120L);
        this.ticksRunning = new HashMap<Player, Integer>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getWindupSpeed(this.getLevelPercent(n)), 0) + C.GRAY + Localizer.dLocalize("agility", "windup", "lore1"));
        element.addLore(C.YELLOW + "* " + Form.duration(this.getWindupTicks(this.getLevelPercent(n)) * 50.0, 1) + C.GRAY + Localizer.dLocalize("agility", "windup", "lore2"));
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.ticksRunning.remove(player);
    }

    @EventHandler
    public void on(EntityMountEvent entityMountEvent) {
        Entity entity = entityMountEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.ticksRunning.remove(player);
        }
    }

    @EventHandler
    public void on(EntityDismountEvent entityDismountEvent) {
        Entity entity = entityDismountEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.ticksRunning.remove(player);
        }
    }

    private double getWindupTicks(double d) {
        return M.lerp(((Config)this.getConfig()).windupTicksSlowest, ((Config)this.getConfig()).windupTicksFastest, d);
    }

    private double getWindupSpeed(double d) {
        return ((Config)this.getConfig()).windupSpeedBase + d * ((Config)this.getConfig()).windupSpeedLevelMultiplier;
    }

    @Override
    public void onTick() {
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (player2.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED) == null) {
                return;
            }
            try {
                for (AttributeModifier attributeModifier : player2.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getModifiers()) {
                    if (!attributeModifier.getName().equals("adapt-wind-up")) continue;
                    player2.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).removeModifier(attributeModifier);
                }
            }
            catch (Exception exception) {
                Adapt.verbose("Failed to remove windup modifier: " + exception.getMessage());
            }
            if (player2.isSwimming() || player2.isFlying() || player2.isGliding() || player2.isSneaking()) {
                this.ticksRunning.remove(player2);
                return;
            }
            if (player2.isSprinting() && this.getLevel(player2) > 0) {
                this.ticksRunning.compute(player2, (player, n) -> {
                    if (n == null) {
                        return 1;
                    }
                    return n + 1;
                });
                Integer n2 = this.ticksRunning.get(player2);
                if (n2 == null || n2.compareTo(0) <= 0) continue;
                double d = this.getLevelPercent(player2);
                double d2 = this.getWindupTicks(d);
                double d3 = Math.min(M.lerpInverse(0.0, d2, n2.intValue()), 1.0);
                double d4 = M.lerp(0.0, this.getWindupSpeed(d), d3);
                if (((Config)this.getConfig()).showParticles) {
                    if (M.r(0.2 * d3)) {
                        player2.getWorld().spawnParticle(Particle.LAVA, player2.getLocation(), 1);
                    }
                    if (M.r(0.25 * d3)) {
                        player2.getWorld().spawnParticle(Particle.FLAME, player2.getLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                player2.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).addModifier(new AttributeModifier("adapt-wind-up", d4, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
                continue;
            }
            this.ticksRunning.remove(player2);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        double costFactor = 0.65;
        int initialCost = 8;
        double windupTicksSlowest = 180.0;
        double windupTicksFastest = 60.0;
        double windupSpeedBase = 0.22;
        double windupSpeedLevelMultiplier = 0.225;

        static {
            IBootstrap.dasBoot();
        }
    }
}

